/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import System.Exception;
import com.starbase.starteam.ForeignPasswordException;
import com.starbase.starteam.ServerException;
import com.starbase.starteam.vts.comm.Cipher;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandException;
import com.starbase.starteam.vts.comm.CommandRoute;
import com.starbase.starteam.vts.comm.Connection;
import com.starbase.starteam.vts.comm.ConnectionException;
import com.starbase.starteam.vts.comm.Res;
import com.starbase.starteam.vts.comm.ResIDs;
import com.starbase.util.GUID;
import java.io.IOException;

public abstract class CommandMacro {
    private static final boolean TEST_RECONNECT = false;
    private static final int RECONNECT_FAIL_START = -1;
    private static final int RECONNECT_FAIL_MIDDLE = 0;
    private static final int RECONNECT_FAIL_END = 1;
    private static final int m_nReconnectTestMode = 0;
    private boolean m_bEditCommandsCanBeRetried = true;
    private boolean m_nReconnectTested = false;

    protected abstract boolean isRetrySupported();

    protected boolean isRetrySupportedForEditCommand() {
        return this.m_bEditCommandsCanBeRetried;
    }

    protected void prepareForRetry() {
    }

    public final void execute(Connection connection, GUID gUID, int n, int n2) {
        try {
            this.executeOnce(connection, gUID, n, n2);
        }
        catch (ConnectionException connectionException) {
            this.handleConnectionException(connectionException, connection, gUID, n, n2);
        }
        catch (ForeignPasswordException foreignPasswordException) {
            this.handleForeignPasswordException(foreignPasswordException, connection, gUID, n, n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeOnce(Connection connection, GUID gUID, int n, int n2) {
        Command command = null;
        if (gUID == null && connection.getRevisionLevel() >= 100) {
            gUID = connection.getClientGUID();
        }
        Connection connection2 = connection;
        synchronized (connection2) {
            block17: {
                block16: {
                    connection.usingCommand(this.getClass().getName());
                    boolean bl = false;
                    this.m_bEditCommandsCanBeRetried = true;
                    try {
                        try {
                            command = this.prepare(connection, gUID, n, n2);
                            this.push(command);
                            connection.execCommand(command);
                            this.m_bEditCommandsCanBeRetried = false;
                            this.pop(command);
                            this.terminateCommand(connection, command);
                        }
                        catch (IOException iOException) {
                            command.onError(iOException);
                            bl = true;
                            throw CommandException.forError(iOException);
                        }
                        catch (RuntimeException runtimeException) {
                            command.onError(runtimeException);
                            bl = true;
                            throw runtimeException;
                        }
                        Object var10_8 = null;
                        if (!bl) break block16;
                    }
                    catch (Throwable throwable) {
                        Object var10_9 = null;
                        if (!bl) {
                            connection.commandNotInUse();
                            throw throwable;
                        }
                        try {
                            try {
                                connection.commandNotInUse();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throw throwable;
                            }
                        }
                        catch (Exception exception) {
                            throw throwable;
                        }
                    }
                    try {}
                    catch (Exception exception) {}
                    try {}
                    catch (Throwable throwable) {
                    }
                    connection.commandNotInUse();
                    break block17;
                }
                connection.commandNotInUse();
            }
            return;
        }
    }

    private void terminateCommand(Connection connection, Command command) {
        try {
            connection.terminateCommand(command);
        }
        catch (ServerException serverException) {
            connection.onCommandException(serverException);
            throw serverException;
        }
        catch (IOException iOException) {
            connection.onCommandException(iOException);
            throw CommandException.forError(iOException);
        }
    }

    protected final Command prepare(Connection connection, GUID gUID, int n, int n2) throws IOException {
        int n3 = connection.getServerEncryptID();
        Cipher cipher = connection.getEncrypter();
        Cipher cipher2 = connection.getDecrypter();
        int n4 = 0;
        if (connection.getCompressionLevel() != 0) {
            n4 |= 1;
        }
        if (connection.isEncryptionOn()) {
            n4 |= 2;
        }
        CommandRoute commandRoute = this.getCommandRoute();
        n4 |= commandRoute.getFlag();
        if (gUID == null) {
            gUID = new GUID();
        }
        Command command = connection.prepareCommand(n4, n3, cipher, cipher2, gUID, n, n2, commandRoute.getCommand(), commandRoute.getService());
        command.startCommand(this.getCommandRoute().getCommand(), this.getCommandRoute().getCommandName(), connection.getRevisionLevel());
        command.pushCommandHeader();
        return command;
    }

    protected abstract void push(Command var1) throws IOException;

    protected abstract void pop(Command var1) throws IOException;

    protected abstract CommandRoute getCommandRoute();

    private void handleConnectionException(ConnectionException connectionException, Connection connection, GUID gUID, int n, int n2) {
        if (this.isRetrySupported() && connection.isAutoReconnect(gUID)) {
            int n3 = connection.getAutoReconnectAttempts();
            int n4 = connection.getAutoReconnectWait() * 1000;
            int n5 = 0;
            while (n5 < n3) {
                try {
                    Thread.currentThread();
                    Thread.sleep(n4);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    connection.reconnect(gUID);
                    this.prepareForRetry();
                    this.executeOnce(connection, gUID, n, n2);
                    return;
                }
                catch (CommandException commandException) {
                    connectionException.addReconnectException(commandException.getIOException());
                    ++n5;
                }
            }
            connection.pauseReconnect(n4);
        }
        throw connectionException;
    }

    private void testReconnect(int n, Connection connection, GUID gUID) throws IOException {
    }

    private void handleForeignPasswordException(ForeignPasswordException foreignPasswordException, Connection connection, GUID gUID, int n, int n2) {
        String string = foreignPasswordException.getConfigPath();
        int n3 = foreignPasswordException.getProjectType();
        connection.setForeignPassword(gUID, string, n3, null);
        this.m_bEditCommandsCanBeRetried = true;
        if (!this.isRetrySupported()) {
            this.setErrorMessage(foreignPasswordException, connection, null);
            throw foreignPasswordException;
        }
        this.prepareForRetry();
        this.executeOnce(connection, gUID, n, n2);
    }

    private void setErrorMessage(ForeignPasswordException foreignPasswordException, Connection connection, String string) {
        String string2 = foreignPasswordException.getConfigPath();
        if (string == null && !connection.isNotifiedForeignPasswordException(string2)) {
            string = ResIDs.FOREIGN_PW_REQUIRED_FMT;
            connection.setNotifiedForeignPasswordException(string2);
        }
        if (string != null) {
            Object[] objectArray = new Object[]{string2};
            foreignPasswordException.setErrorMessage(Res.formatKey(string, objectArray));
        }
    }
}

