/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import com.starbase.starteam.Server;
import com.starbase.starteam.vts.comm.Cipher;
import com.starbase.starteam.vts.comm.CommandExceptionDetected;
import com.starbase.starteam.vts.comm.CommandFile;
import com.starbase.starteam.vts.comm.NetMonitor;
import com.starbase.starteam.vts.comm.ReceiveCommandFile;
import com.starbase.starteam.vts.comm.SendCommandFile;
import com.starbase.starteam.vts.comm.SystemRevisionNumbers;
import com.starbase.util.Assert;
import com.starbase.util.ByteOrder;
import com.starbase.util.GUID;
import com.starbase.util.MD5;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Locale;

public abstract class Command {
    public static final int CMDFLAG_PUBLIC_SERVER_COMMAND = 0x10000000;
    public static final int CMDFLAG_LOGIN_SERVER_COMMAND = 0x20000000;
    public static final int CMDFLAG_SECURE_SERVER_COMMAND = 0x40000000;
    public static final int CMDFLAG_SECURE_PROJECT_COMMAND = Integer.MIN_VALUE;
    public static final int CMDFLAG_GLOBAL_SERVICE_COMMAND = 0x1000000;
    static final int CMDFLAG_COMPACTED = 1;
    static final int CMDFLAG_ENCRYPTED = 2;
    static final int CMDFLAG_CHECKPARAMETERS = 16;
    public static final int PARAM_TYPE_SHORT = 0x11000000;
    public static final int PARAM_TYPE_USHORT = 0x12000000;
    public static final int PARAM_TYPE_INT = 0x21000000;
    public static final int PARAM_TYPE_UINT = 0x22000000;
    public static final int PARAM_TYPE_FLOAT = 0x30000000;
    public static final int PARAM_TYPE_DOUBLE = 0x40000000;
    public static final int PARAM_TYPE_RAW = 0x50000000;
    public static final int PARAM_TYPE_INT64 = 0x61000000;
    public static final int PARAM_TYPE_UINT64 = 0x62000000;
    protected static boolean m_debug = false;
    protected short m_rev = (short)-1;
    protected String m_api = "1.0";
    protected boolean m_checkingParameters = false;
    protected byte[] m_parameterTypeBuffer = new byte[4];
    protected Server m_server = null;
    protected SendCommandFile m_aSendFile = null;
    protected ReceiveCommandFile m_aReceiveFile = null;
    protected boolean m_bPopping = false;
    protected boolean m_bPushing = false;
    protected int m_nSessionTag = 0;
    protected int m_nClientTimestamp = 0;
    protected int m_nFlags = 0;
    protected int m_nKeyID = 0;
    protected GUID m_ClientID = null;
    protected int m_nConnectID = 0;
    protected int m_nComponentID = 0;
    protected int m_nCommandID = 0;
    protected byte[] m_aBuf = new byte[8];
    protected double m_commandTime = 0.0;
    protected int m_nCommandUserID = -1;
    private NetMonitor m_NetMonitor = new NetMonitor(this);
    private boolean m_bHasGZIPContents = false;
    private boolean m_bReadingGZIPContents = false;

    void startCommand(int n, String string, short s) {
        this.m_NetMonitor.start(n, string, s);
    }

    void wrote(int n) {
        this.m_NetMonitor.wrote(n);
    }

    void read(int n) {
        this.m_NetMonitor.read(n);
    }

    public void onError(Throwable throwable) {
        this.m_NetMonitor.error(throwable);
    }

    void endCommand() {
        this.m_NetMonitor.end();
    }

    void setRevisionLevel(short s) {
        this.m_rev = s;
    }

    public short getRevisionLevel() {
        return this.m_rev;
    }

    void setCommandAPIRevisionLevel(String string) {
        this.m_api = string;
    }

    public String getCommandAPIRevisionLevel() {
        return this.m_api;
    }

    public boolean supports(short s, String string) {
        return SystemRevisionNumbers.equalOrGreater(this.getRevisionLevel(), this.getCommandAPIRevisionLevel(), s, string);
    }

    boolean supportsSingleBlockFileStreaming() {
        return SystemRevisionNumbers.supportsSingleBlockFileStreaming(this.getRevisionLevel(), this.getCommandAPIRevisionLevel());
    }

    boolean isCheckingParameters() {
        return this.m_checkingParameters;
    }

    static void setPacketSize(int n) {
        CommandFile.setPacketSize(n);
    }

    final int getSessionTag() {
        return this.m_nSessionTag;
    }

    final int getClientTimestamp() {
        return this.m_nClientTimestamp;
    }

    final int getFlags() {
        return this.m_nFlags;
    }

    final int getKeyID() {
        return this.m_nKeyID;
    }

    final GUID getClientID() {
        return this.m_ClientID;
    }

    final int getConnectID() {
        return this.m_nConnectID;
    }

    final int getComponentID() {
        return this.m_nComponentID;
    }

    final int getCommandID() {
        return this.m_nCommandID;
    }

    final ReceiveCommandFile getReceiveFile() {
        return this.m_aReceiveFile;
    }

    final SendCommandFile getSendFile() {
        return this.m_aSendFile;
    }

    final Server getServer() {
        return this.m_server;
    }

    abstract void resetForNewCommand(int var1, int var2, int var3, int var4, int var5, Cipher var6, Cipher var7, int var8, GUID var9, int var10, int var11, double var12, int var14) throws IOException;

    void pushCommandHeader() throws IOException {
        this.pushMessageDataHeader();
        this.pushIDs();
    }

    private void pushMessageDataHeader() throws IOException {
        this.m_aSendFile.writeInt(this.getSessionTag());
        this.m_aSendFile.writeInt(this.getClientTimestamp());
        this.m_aSendFile.writeInt(this.getFlags());
        this.m_aSendFile.writeInt(this.getKeyID());
        this.m_aSendFile.writeInt(0);
    }

    private void pushIDs() throws IOException {
        short s = this.getRevisionLevel();
        this.writeUShort(s);
        this.writeGUID(this.m_ClientID);
        this.writeUInt(this.m_nConnectID);
        this.writeUInt(this.m_nComponentID);
        this.writeUInt(this.m_nCommandID);
        this.writeDouble(this.getCommandTime());
        if (s >= 79) {
            this.writeUInt(this.m_nCommandUserID);
        }
    }

    abstract void enableCompaction(int var1);

    abstract void enableEncryption(int var1, Cipher var2, Cipher var3);

    protected int generateClientTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    protected double getCommandTime() {
        return this.m_commandTime;
    }

    protected void setCommandTime(double d) {
        this.m_commandTime = d;
    }

    protected int getCommandUserID() {
        return this.m_nCommandUserID;
    }

    protected void setCommandUserID(int n) {
        this.m_nCommandUserID = n;
    }

    public abstract InputStream getChunkStream() throws IOException;

    public abstract void writeTime(double var1) throws IOException;

    public abstract void writeTime(Date var1) throws IOException;

    public abstract double readTime() throws IOException;

    public abstract void writeGUID(GUID var1) throws IOException;

    public abstract GUID readGUID() throws IOException;

    public abstract void writeMD5(MD5 var1) throws IOException;

    public abstract MD5 readMD5() throws IOException;

    public abstract void writePassword(String var1) throws IOException;

    public abstract void writePassword(byte[] var1) throws IOException;

    public abstract String readLoginInfo() throws IOException;

    public abstract byte[] readRawLoginInfo() throws IOException;

    public abstract void writeByte(byte var1) throws IOException;

    public abstract byte readByte() throws IOException;

    public abstract void writeShort(short var1) throws IOException;

    public abstract short readShort() throws IOException;

    public abstract void writeUShort(short var1) throws IOException;

    public abstract short readUShort() throws IOException;

    public abstract void writeInt(int var1) throws IOException;

    public abstract int readInt() throws IOException;

    public abstract void writeUInt(int var1) throws IOException;

    public abstract int readUInt() throws IOException;

    public abstract void writeLong(long var1) throws IOException;

    public abstract long readLong() throws IOException;

    public abstract void writeDouble(double var1) throws IOException;

    public abstract double readDouble() throws IOException;

    public abstract void writeString(String var1) throws IOException;

    public abstract String readString() throws IOException;

    public abstract void writeBoolean(boolean var1) throws IOException;

    public abstract boolean readBoolean() throws IOException;

    public abstract void writeStringArray(String[] var1) throws IOException;

    public abstract String[] readStringArray() throws IOException;

    public abstract void writeIntArray(int[] var1) throws IOException;

    public abstract int[] readIntArray() throws IOException;

    public abstract void writeVariantBytes(byte[] var1) throws IOException;

    public abstract byte[] readVariantBytes() throws IOException;

    public abstract void writeVariantIDs(int[] var1) throws IOException;

    public abstract int[] readVariantIDs() throws IOException;

    public abstract void writeBlob(byte[] var1) throws IOException;

    public abstract byte[] readBlob() throws IOException;

    public abstract int writeFileStream(InputStream var1) throws IOException;

    public abstract int writeStream(InputStream var1) throws IOException;

    public abstract long readStream(OutputStream var1) throws IOException;

    public abstract void writeRaw(byte[] var1) throws IOException;

    public abstract byte[] readRaw() throws IOException;

    public abstract byte[] readRaw(int var1) throws IOException;

    public abstract GUID[] readGUIDArray() throws IOException;

    public abstract Locale readLocale() throws IOException;

    public abstract void writeLocale(Locale var1) throws IOException;

    void push(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (this.m_bPopping) {
            this.terminatePop();
        }
        this.m_bPushing = true;
        if (m_debug) {
            // empty if block
        }
        if (this.m_checkingParameters) {
            int n4 = n3 | n2 & 0xFFFFFF;
            ByteOrder.writeInt(this.m_parameterTypeBuffer, n4);
            this.m_aSendFile.write(this.m_parameterTypeBuffer, 0, 4);
        }
        this.m_aSendFile.write(byArray, n, n2);
    }

    public abstract int readBuffer(byte[] var1, int var2) throws IOException;

    public final void pop(byte[] byArray, int n, int n2) throws IOException {
        this.pop(byArray, 0, n, n2);
    }

    public final void pop(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (this.m_bPushing) {
            Assert.internalError("Command.pop(), m_bPushing=true");
        }
        this.m_bPopping = true;
        if (this.m_aReceiveFile == null) {
            Assert.internalError("Command.pop(), m_aReceiveFile=null");
        }
        try {
            if (this.m_checkingParameters) {
                this.m_aReceiveFile.read(this.m_parameterTypeBuffer, 4);
                int n4 = ByteOrder.readInt(this.m_parameterTypeBuffer);
                int n5 = n4 & 0xFFFFFF;
                if (n5 != n2) {
                    Assert.internalError("Command.op(), bytesReceived != nBytes");
                }
            }
            this.m_aReceiveFile.read(byArray, n, n2);
        }
        catch (CommandExceptionDetected commandExceptionDetected) {
            this.popException();
        }
    }

    void popIDs() throws IOException {
        short s = this.readShort();
        if (s != this.getRevisionLevel()) {
            Assert.internalError("Command.popIDs(), nCommandID=" + s);
        }
        this.m_ClientID = this.readGUID();
        this.m_nConnectID = this.readInt();
        this.m_nComponentID = this.readInt();
        this.m_nCommandID = this.readInt();
        this.m_commandTime = this.readTime();
    }

    abstract void terminatePush() throws IOException;

    abstract void terminatePop() throws IOException;

    abstract void popException() throws IOException;

    public boolean hasGZIPContents() {
        return this.m_bHasGZIPContents;
    }

    public void setHasGZIPContents(boolean bl) {
        this.m_bHasGZIPContents = bl;
    }

    public boolean readingGZIPContents() {
        return this.m_bReadingGZIPContents;
    }

    public void setReadingGZIPContents(boolean bl) {
        this.m_bReadingGZIPContents = bl;
        if (!bl) {
            this.m_aReceiveFile.resetInflater();
        }
    }

    Command() {
    }
}

