/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.vts.comm;

import com.starbase.starteam.ClientApplication;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandMacro;
import com.starbase.starteam.vts.comm.CommandRoute;
import com.starbase.starteam.vts.comm.SystemRevisionNumbers;
import com.starbase.util.GUID;
import java.io.IOException;
import java.util.Locale;

class CmdServerConnect
extends CommandMacro {
    private static final CommandRoute m_route = new CommandRoute(0x10000000, 0, 4, "SRVR_CMD_SERVER_CONNECT");
    private GUID m_WorkstationID;
    private String m_hostName = null;
    private String m_apiRevision = null;
    private GUID m_ClientID;

    public GUID getClientID() {
        return this.m_ClientID;
    }

    protected boolean isRetrySupported() {
        return false;
    }

    protected void push(Command command) throws IOException {
        command.writeGUID(this.m_WorkstationID);
        command.writeString(this.m_hostName);
        command.writeString(this.m_apiRevision);
        if (SystemRevisionNumbers.equalOrGreater(command.getRevisionLevel(), this.m_apiRevision, (short)100, "1.9")) {
            command.writeLocale(Locale.getDefault());
        }
        if (SystemRevisionNumbers.equalOrGreater(command.getRevisionLevel(), this.m_apiRevision, (short)100, "1.13")) {
            command.writeString(ClientApplication.getDescription());
        }
    }

    protected void pop(Command command) throws IOException {
        this.m_ClientID = command.readGUID();
    }

    protected CommandRoute getCommandRoute() {
        return m_route;
    }

    public CmdServerConnect(GUID gUID, String string, String string2) {
        this.m_WorkstationID = gUID;
        this.m_hostName = string;
        this.m_apiRevision = string2;
    }
}

