/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.names;

import com.starbase.starteam.names.NameUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

class ResMan {
    private static final String CLASS_NAME_PREFIX = "com.starbase.starteam.names.Resources";
    private static Hashtable RESOURCE_MAP = null;
    private static Hashtable TRIED = new Hashtable();

    public static String[] getSupportedLocales() {
        ResMan.cacheResources();
        String[] stringArray = new String[RESOURCE_MAP.size()];
        int n = 0;
        Enumeration enumeration = RESOURCE_MAP.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public static String getString(String string, String string2) {
        String string3 = null;
        ResourceBundle resourceBundle = (ResourceBundle)RESOURCE_MAP.get(string2);
        if (resourceBundle != null) {
            try {
                string3 = resourceBundle.getString(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return string3;
    }

    private static void cacheResources() {
        if (RESOURCE_MAP == null) {
            String[] stringArray = NameUtils.ALL_LANGUAGES;
            Hashtable<String, ResourceBundle> hashtable = new Hashtable<String, ResourceBundle>();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                ResourceBundle resourceBundle = ResMan.getBundle(string);
                if (resourceBundle != null) {
                    hashtable.put(string, resourceBundle);
                }
                ++n;
            }
            RESOURCE_MAP = hashtable;
        }
        ResMan.cacheDefaultLocale();
    }

    private static void cacheDefaultLocale() {
        String string;
        Object v;
        Locale locale = Locale.getDefault();
        if (locale != null && (v = RESOURCE_MAP.get(string = locale.toString())) == null && TRIED.get(string) == null) {
            TRIED.put(string, string);
            ResourceBundle resourceBundle = ResMan.getBundle(string);
            if (resourceBundle != null) {
                RESOURCE_MAP.put(string, resourceBundle);
            }
        }
    }

    private static ResourceBundle getBundle(String string) {
        try {
            Class<?> clazz;
            String string2 = string;
            if (string.length() != 0) {
                string2 = "_" + string2;
            }
            if ((clazz = Class.forName(CLASS_NAME_PREFIX + string2)) == null) {
                return null;
            }
            ResourceBundle resourceBundle = (ResourceBundle)clazz.newInstance();
            return resourceBundle;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private ResMan() {
    }
}

