/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.User;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.util.Platform;
import java.io.IOException;

class Lock
extends CommonCommand {
    String description() {
        return Res.getString(ResIDs.LOCK_DESCRIPTION);
    }

    String name() {
        return "lck";
    }

    boolean treatNoFilesAsAll() {
        return true;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return true;
    }

    boolean ignoreUserFileList() {
        return false;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(true, false);
        Object object = new Object();
        Object object2 = new Object();
        commonSpec.addOption(new Option("ELock", false, object));
        commonSpec.addOption(new Option("UNLock", false, object));
        commonSpec.addOption(new Option("NELLock", false, object));
        commonSpec.addOption(new Option("ReadOnly", false, object2, object));
        commonSpec.addOption(new Option("ReadWrite", false, object2, object));
        commonSpec.addOption(new Option("BreakLock", false));
        commonSpec.removeViewConfigOptions();
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    private boolean getReadOnly() {
        return this.getIsOptionOn("ReadOnly");
    }

    private boolean getReadWrite() {
        return this.getIsOptionOn("ReadWrite");
    }

    private boolean getBreakLock() {
        return this.getIsOptionOn("BreakLock");
    }

    private int getRequestedLockStatus() {
        if (this.getIsOptionOn("ELock")) {
            return 1;
        }
        if (this.getIsOptionOn("UNLock")) {
            return 0;
        }
        if (this.getIsOptionOn("NELLock")) {
            return 2;
        }
        return 1;
    }

    private String lockMessage(User user) {
        String string = "";
        int n = this.getRequestedLockStatus();
        switch (n) {
            case 1: {
                string = Res.getString(ResIDs.LOCK_LOCKED_MSG);
                break;
            }
            case 0: {
                if (user == null) {
                    string = Res.getString(ResIDs.LOCK_UNLOCKED_MSG);
                    break;
                }
                string = Res.formatKey(ResIDs.LOCK_NOT_UNLOCKED_ERROR_MSG, new Object[]{user.getName()});
                break;
            }
            case 2: {
                string = Res.getString(ResIDs.LOCK_NON_EXCLUSIVE_MSG);
                break;
            }
            case 3: {
                string = Res.getString(ResIDs.LOCK_LOCK_UNCHANGED_MSG);
                break;
            }
            default: {
                string = Res.formatKey(ResIDs.LOCK_INVALID_LOCK_STATUS_ERROR_MSG, new Object[]{new Integer(n)});
            }
        }
        return string;
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        this.message(Res.formatKey(ResIDs.LOCK_FILE_NOT_IN_PROJECT_ERROR_MSG, new Object[]{string}));
    }

    void processOneFile(Folder folder, File file) throws IOException {
        String string = file.getFullName();
        java.io.File file2 = new java.io.File(string);
        int n = this.getRequestedLockStatus();
        file.putLock(n, this.getBreakLock());
        User user = file.getServer().getUser(file.getLocker());
        String string2 = this.fixLocalRW(file2, n);
        this.message(Res.formatKey(ResIDs.LOCK_COMMAND_MSG, new Object[]{file.getName(), this.lockMessage(user), string2}));
    }

    private String fixLocalRW(java.io.File file, int n) throws IOException {
        if (n == 3) {
            return "";
        }
        if (this.getReadOnly()) {
            Platform.setFileWritable(file, false);
            return Res.getString(ResIDs.LOCK_READ_ONLY_SET_MSG);
        }
        if (this.getReadWrite()) {
            Platform.setFileWritable(file, true);
            return Res.getString(ResIDs.LOCK_READ_WRITE_SET_MSG);
        }
        return "";
    }

    void processNoFiles() throws IOException {
    }

    Lock() {
    }
}

