/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.util.Assert;
import java.io.IOException;

class Description
extends CommonCommand {
    String description() {
        return Res.getString(ResIDs.SET_DESCRIPTION_DESCRIPTION);
    }

    String name() {
        return "dsc";
    }

    boolean treatNoFilesAsAll() {
        return true;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return true;
    }

    boolean ignoreUserFileList() {
        return false;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(true, false);
        commonSpec.addOption(new Option("Desc", true));
        commonSpec.removeViewConfigOptions();
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    private String getDescription() {
        return this.getStringOption("Desc");
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        Assert.internalError("Description.processLocalFile()");
    }

    void processOneFile(Folder folder, File file) throws IOException {
        file.setDescription(this.getDescription());
        file.update();
        this.message(Res.formatKey(ResIDs.SET_DESCRIPTION_SET_MSG, new Object[]{file.getName()}));
    }

    void processNoFiles() throws IOException {
        Assert.internalError("Description.processNoFile()");
    }

    Description() {
    }
}

