/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Label;
import com.starbase.starteam.PromotionState;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.starteam.commandline.TimeOption;
import com.starbase.util.Assert;
import com.starbase.util.OLEDate;
import java.io.IOException;
import java.util.Date;

class CreateLabel
extends CommonCommand {
    String description() {
        return Res.getString(ResIDs.CREATE_LABEL_DESCRIPTION);
    }

    String name() {
        return "label";
    }

    boolean treatNoFilesAsAll() {
        return false;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return false;
    }

    boolean ignoreUserFileList() {
        return true;
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(false, false);
        Object object = new Object();
        Object object2 = new Object();
        commonSpec.addOption(new Option("NewLabel", true));
        commonSpec.addOption(new TimeOption("LabelDate", false, object2));
        commonSpec.addOption(new Option("LabelPromotion", false, object2));
        commonSpec.addOption(new Option("VersionLabel", false, object2));
        commonSpec.addOption(new Option("LabelDesc", false));
        commonSpec.addOption(new Option("LabelWorkFlow", false, object));
        commonSpec.addOption(new Option("LabelRevision", false, object));
        commonSpec.addOption(new Option("LabelFrozen", false));
        commonSpec.removeOption("Recurse");
        commonSpec.removeOption("Rootpath");
        commonSpec.removeOption("Folderpath");
        commonSpec.removeOption("CaseSensitiveFolders");
        commonSpec.removeOption("StatusFilter");
        commonSpec.removeViewConfigOptions();
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    private String getLabelName() {
        return this.getStringOption("NewLabel");
    }

    private String getDescription() {
        String string = this.getStringOption("LabelDesc");
        return string != null ? string : "";
    }

    private boolean makeWorkFlowLabel() {
        return this.getIsOptionOn("LabelWorkFlow");
    }

    private boolean makeRevisionLabel() {
        return this.getIsOptionOn("LabelRevision");
    }

    private boolean isFrozen() {
        return this.getIsOptionOn("LabelFrozen");
    }

    private OLEDate getLabelTime() {
        if (this.getIsOptionOn("LabelDate")) {
            Date date = this.getTimeOption("LabelDate");
            if (date == null) {
                return new OLEDate(0.0);
            }
            return new OLEDate(date.getTime());
        }
        return new OLEDate(0.0);
    }

    private Label getPromotionLabel(String string) throws IOException {
        PromotionState[] promotionStateArray = this.getView().getPromotionModel().getPromotionStates();
        int n = -1;
        int n2 = 0;
        while (n2 < promotionStateArray.length) {
            if (promotionStateArray[n2].getName().equalsIgnoreCase(string)) {
                n = promotionStateArray[n2].getLabelID();
                break;
            }
            ++n2;
        }
        if (n == -1) {
            throw new IOException(Res.formatKey(ResIDs.CREATE_LABEL_PROMOTION_STATE_MISSING_ERROR_MSG, new Object[]{string}));
        }
        Label label = null;
        Label[] labelArray = this.getView().fetchAllLabels();
        int n3 = 0;
        while (n3 < labelArray.length) {
            if (labelArray[n3].getID() == n) {
                label = labelArray[n3];
                break;
            }
            ++n3;
        }
        if (label == null) {
            throw new IOException(Res.getString(ResIDs.CREATE_LABEL_PROMOTION_STATE_LABEL_MISSING_ERROR_MSG));
        }
        return label;
    }

    private Label getLabel(String string) throws IOException {
        Label label = null;
        Label[] labelArray = this.getView().fetchAllLabels();
        int n = 0;
        while (n < labelArray.length) {
            if (labelArray[n].getName().equalsIgnoreCase(string)) {
                label = labelArray[n];
                break;
            }
            ++n;
        }
        if (label == null) {
            throw new IOException(Res.formatKey(ResIDs.CREATE_LABEL_LABEL_MISSING_ERROR_MSG, new Object[]{string}));
        }
        return label;
    }

    private Label getSourceLabel() throws IOException {
        if (this.getIsOptionOn("VersionLabel")) {
            return this.getLabel(this.getStringOption("VersionLabel"));
        }
        if (this.getIsOptionOn("LabelPromotion")) {
            return this.getPromotionLabel(this.getStringOption("LabelPromotion"));
        }
        return null;
    }

    void processLocalFile(Folder folder, String string) throws IOException {
        Assert.internalError("CreateLabel.processLocalFile()");
    }

    void processOneFile(Folder folder, File file) throws IOException {
        Assert.internalError("CreateLabel.processOneFile()");
    }

    void processNoFiles() throws IOException {
        Label label = null;
        String string = this.getLabelName();
        String string2 = this.getDescription();
        OLEDate oLEDate = this.getLabelTime();
        Label label2 = this.getSourceLabel();
        if (this.makeRevisionLabel()) {
            if (label2 != null) {
                if (!label2.isRevisionLabel()) {
                    throw new IOException(Res.formatKey(ResIDs.CREATE_LABEL_SOURCE_LABEL_NOT_REVISION_ERROR_MSG, new Object[]{label2.getName()}));
                }
                label = this.getView().cloneRevisionLabel(label2, string, string2, this.isFrozen());
            } else {
                label = this.getView().createRevisionLabel(string, string2, this.isFrozen());
            }
        } else if (label2 != null) {
            if (!label2.isViewLabel()) {
                throw new IOException(Res.formatKey(ResIDs.CREATE_LABEL_SOURCE_LABEL_NOT_VIEW_ERROR_MSG, new Object[]{label2.getName()}));
            }
            label = this.getView().cloneViewLabel(label2, string, string2, this.makeWorkFlowLabel(), this.isFrozen());
        } else {
            label = this.getView().createViewLabel(string, string2, oLEDate, this.makeWorkFlowLabel(), this.isFrozen());
        }
        label.update();
        String string3 = "";
        string3 = oLEDate.getDoubleValue() == 0.0 ? Res.getString(ResIDs.CREATE_LABEL_CURRENT_SERVER_TIME) : oLEDate.localString(3, 1);
        this.message(Res.formatKey(ResIDs.CREATE_LABEL_CREATED_MSG, new Object[]{string}));
        this.message(Res.formatKey(ResIDs.CREATE_LABEL_AS_OF_DATE_MSG, new Object[]{string3}));
        this.message(Res.formatKey(ResIDs.CREATE_LABEL_DESCRIPTION_MSG, new Object[]{string2}));
    }

    CreateLabel() {
    }
}

