/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.commandline;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Label;
import com.starbase.starteam.Status;
import com.starbase.starteam.User;
import com.starbase.starteam.commandline.AutoEOLOption;
import com.starbase.starteam.commandline.CommonCommand;
import com.starbase.starteam.commandline.CommonSpec;
import com.starbase.starteam.commandline.Option;
import com.starbase.starteam.commandline.ProcessItem;
import com.starbase.starteam.commandline.Res;
import com.starbase.starteam.commandline.ResIDs;
import com.starbase.starteam.commandline.SimpleStringOption;
import com.starbase.util.Platform;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;

class CheckIn
extends CommonCommand {
    private static final String EMPTY_STRING = "";
    private String m_reason = "";
    private Label[] m_cachedLabels = null;
    private Vector m_checkedinFiles = null;
    private boolean m_markProcessFixed = true;
    private Item m_processItem = null;

    String description() {
        return Res.getString(ResIDs.CHECK_IN_DESCRIPTION);
    }

    String name() {
        return "ci";
    }

    boolean treatNoFilesAsAll() {
        return true;
    }

    boolean iterateOnLocalFiles() {
        return false;
    }

    boolean iterateOnServerFiles() {
        return true;
    }

    boolean ignoreUserFileList() {
        return false;
    }

    private String getReason() {
        return this.m_reason;
    }

    private boolean getForceCheckin() {
        return this.getIsOptionOn("ForceIn");
    }

    private boolean getPromptForCheckin() {
        return this.getIsOptionOn("PromptForCIAction");
    }

    private boolean getFNCI() {
        return this.getIsOptionOn("NeedsCheckin");
    }

    private boolean getReadOnly() {
        return this.getIsOptionOn("ReadOnly");
    }

    private boolean getReadWrite() {
        return this.getIsOptionOn("ReadWrite");
    }

    int run(String[] stringArray) throws IOException {
        CommonSpec commonSpec = new CommonSpec(true, false);
        Object object = new Object();
        Object object2 = new Object();
        commonSpec.addOption(new Option("ELock", false, object));
        commonSpec.addOption(new Option("UNLock", false, object));
        commonSpec.addOption(new Option("NELLock", false, object));
        commonSpec.addOption(new Option("ReadOnly", false, object2, object));
        commonSpec.addOption(new Option("ReadWrite", false, object2, object));
        commonSpec.addOption(new Option("VersionLabel", 0, Integer.MAX_VALUE));
        commonSpec.addOption(new Option("DontMoveLabel", false));
        commonSpec.addOption(new SimpleStringOption("NeedsCheckin", false));
        Object object3 = new Object();
        commonSpec.addOption(new Option("ForceIn", false, object3));
        commonSpec.addOption(new Option("PromptForCIAction", false, object3));
        Object object4 = new Object();
        commonSpec.addOption(new Option("Reason", false, object4));
        commonSpec.addOption(new Option("ReasonFile", false, object4));
        commonSpec.addOption(new AutoEOLOption("AutoEOL"));
        Object object5 = new Object();
        commonSpec.addOption(new Option("ProcessChangeRequest", false, object5));
        commonSpec.addOption(new Option("ProcessRequirement", false, object5));
        commonSpec.addOption(new Option("ProcessTask", false, object5));
        commonSpec.addOption(new Option("ProcessActiveItem", false, object5));
        commonSpec.addOption(new Option("ProcessMarkItem", false, null, object5));
        commonSpec.removeViewConfigOptions();
        this.setSpec(commonSpec);
        return this.runCommand(stringArray);
    }

    private int getRequestedLockStatus() {
        if (this.getIsOptionOn("ELock")) {
            return 1;
        }
        if (this.getIsOptionOn("UNLock")) {
            return 0;
        }
        if (this.getIsOptionOn("NELLock")) {
            return 2;
        }
        return 3;
    }

    private boolean getAutoEOL() {
        if (this.getIsOptionOn("AutoEOL")) {
            return this.getBooleanOption("AutoEOL");
        }
        return false;
    }

    private boolean getKeepLabelsInPlace() {
        return this.getIsOptionOn("DontMoveLabel");
    }

    private String[] getLabelNames() {
        return this.getStringOptionList("VersionLabel");
    }

    private boolean isProcessOn() {
        return this.getIsOptionOn("ProcessChangeRequest") || this.getIsOptionOn("ProcessRequirement") || this.getIsOptionOn("ProcessTask") || this.getIsOptionOn("ProcessActiveItem");
    }

    private Item getProcessItem() throws IOException {
        Item item = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.getIsOptionOn("ProcessActiveItem")) {
            item = ProcessItem.getProcessItem(this.getView());
            if (item == null) {
                throw new IOException(Res.getString(ResIDs.CHECK_IN_ACTIVE_PROCESS_NOT_SET));
            }
        } else if (this.getIsOptionOn("ProcessChangeRequest")) {
            string = this.getStringOption("ProcessChangeRequest");
            string3 = this.getView().getServer().getTypeNames().CHANGEREQUEST;
            string2 = this.getView().getServer().getPropertyNames().CR_CHANGE_NUMBER;
        } else if (this.getIsOptionOn("ProcessRequirement")) {
            string = this.getStringOption("ProcessRequirement");
            string3 = this.getView().getServer().getTypeNames().REQUIREMENT;
            string2 = "RequirementNumber";
        } else if (this.getIsOptionOn("ProcessTask")) {
            string = this.getStringOption("ProcessTask");
            string3 = this.getView().getServer().getTypeNames().TASK;
            string2 = this.getView().getServer().getPropertyNames().TASK_NUMBER;
        }
        if (string != null) {
            int n = string.lastIndexOf("/");
            String string4 = null;
            int n2 = -1;
            if (n >= 0) {
                string4 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            Folder folder = null;
            if (stringTokenizer.hasMoreTokens()) {
                String string5;
                Folder folder2 = this.getView().getRootFolder();
                if (this.folderNameMatch(folder2, string5 = stringTokenizer.nextToken())) {
                    folder = this.findFolder(folder2, stringTokenizer);
                } else {
                    throw new IOException(Res.formatKey(ResIDs.CHECK_IN_FOLDER_NOT_FOUND_ERROR_MSG, new Object[]{string5, this.getView().getName()}));
                }
            }
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                throw new IOException(Res.getString(ResIDs.CHECK_IN_BAD_PROCESS_ITEM_ERROR_MSG));
            }
            item = this.getItem(folder, string3, string2, n2);
        }
        return item;
    }

    private Item getItem(Folder folder, String string, String string2, int n) {
        if (folder == null) {
            return null;
        }
        folder.populateNow(string, new String[]{string2}, 0);
        Item[] itemArray = folder.getItems(string);
        Object var6_6 = null;
        if (itemArray != null) {
            int n2 = 0;
            while (n2 < itemArray.length) {
                Integer n3 = (Integer)itemArray[n2].get(string2);
                if (n == n3) {
                    return itemArray[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    protected void preOperation() throws IOException {
        String[] stringArray;
        String string;
        if (ProcessItem.requiresProcessRules(this.getView().getProject()) && !this.isProcessOn()) {
            throw new IOException(Res.getString(ResIDs.CHECK_IN_PROCESS_ITEM_NOT_SPECIFIED_ERROR_MSG));
        }
        if (this.isProcessOn()) {
            this.m_checkedinFiles = new Vector();
            this.m_processItem = this.getProcessItem();
            if (this.m_processItem == null) {
                throw new IOException(Res.getString(ResIDs.CHECK_IN_PROCESS_ITEM_NOT_FOUND_ERROR_MSG));
            }
            if (!ProcessItem.getValidProcessItemState(this.m_processItem)) {
                throw new IOException(Res.getString(ResIDs.CHECK_IN_BAD_PROCESS_ITEM_STATE_ERROR_MSG));
            }
        }
        if ((string = this.getStringOption("Reason")) != null) {
            this.m_reason = string;
        } else {
            stringArray = this.getStringOption("ReasonFile");
            if (stringArray != null) {
                this.m_reason = this.getReasonFromFile((String)stringArray);
            }
        }
        stringArray = this.getLabelNames();
        if (stringArray != null) {
            this.m_cachedLabels = new Label[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                Label label = this.findLabel(stringArray[n]);
                if (label == null) {
                    throw new IOException(Res.formatKey(ResIDs.CHECK_IN_LABEL_MISSING_ERROR_MSG, new Object[]{stringArray[n]}));
                }
                this.m_cachedLabels[n] = label;
                ++n;
            }
        }
    }

    protected void postOperation() throws IOException {
        if (this.getIsOptionOn("ProcessMarkItem") && this.m_markProcessFixed) {
            ProcessItem.markProcessItemFixed(this.m_processItem);
            this.m_processItem.discard();
            this.message(Res.formatKey(ResIDs.CHECK_IN_PROCESS_ITEM_UPDATED, new Object[]{ProcessItem.getProcessItemName(this.m_processItem)}));
        }
        if (this.isProcessOn()) {
            int n = 0;
            while (n < this.m_checkedinFiles.size()) {
                File file = (File)this.m_checkedinFiles.elementAt(n);
                ProcessItem.linkProcessItem(file, this.m_processItem);
                this.message(Res.formatKey(ResIDs.CHECK_IN_PROCESS_ITEM_LINKED_MSG, new Object[]{file.getName(), ProcessItem.getProcessItemName(this.m_processItem)}));
                ++n;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getReasonFromFile(String string) throws IOException {
        String string2;
        java.io.File file = new java.io.File(string);
        if (!file.exists()) {
            throw new IOException(Res.formatKey(ResIDs.CHECK_IN_REASON_FILE_MISSING_ERROR_MSG, new Object[]{string}));
        }
        if (file.isDirectory()) {
            throw new IOException(Res.formatKey(ResIDs.CHECK_IN_REASON_FILE_IS_DIR_ERROR_MSG, new Object[]{string}));
        }
        if (!file.canRead()) {
            throw new IOException(Res.formatKey(ResIDs.CHECK_IN_REASON_FILE_UNREADABLE_ERROR_MSG, new Object[]{string}));
        }
        StringBuffer stringBuffer = new StringBuffer((int)file.length());
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(fileInputStream));
            int n = ((Reader)inputStreamReader).read();
            while (n != -1) {
                stringBuffer.append((char)n);
                n = ((Reader)inputStreamReader).read();
            }
            string2 = stringBuffer.toString();
            Object var6_8 = null;
            if (fileInputStream == null) return string2;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        return string2;
    }

    void processLocalFile(Folder folder, String string) throws IOException {
    }

    void processOneFile(Folder folder, File file) throws IOException {
        block10: {
            String string;
            block8: {
                block9: {
                    String string2 = file.getFullName();
                    java.io.File file2 = new java.io.File(string2);
                    if (!file2.exists()) {
                        throw new IOException(Res.formatKey(ResIDs.CHECK_IN_FILE_NOT_FOUND_ERROR_MSG, new Object[]{string2}));
                    }
                    int n = this.getRequestedLockStatus();
                    String string3 = this.getReason();
                    string = Res.getString(ResIDs.CHECK_IN_SKIPPED);
                    int n2 = this.getServer().getSession().getUserID();
                    int[] nArray = new int[1];
                    int n3 = file.getStatusNow();
                    if (!this.confirmStatusForCheckin(n3, folder, file, this.getForceCheckin(), this.getPromptForCheckin(), false, this.getFNCI())) break block8;
                    boolean bl = this.verifyLock(n2, folder, file, n, nArray);
                    if (!bl) break block9;
                    if (this.confirmStatusForCheckin(n3, folder, file, this.getForceCheckin(), this.getPromptForCheckin(), true, this.getFNCI())) {
                        boolean bl2;
                        block7: {
                            boolean bl3 = this.getForceCheckin();
                            if (this.getPromptForCheckin()) {
                                bl3 = true;
                            }
                            bl2 = false;
                            try {
                                file.checkin(string3, n, bl3, this.getAutoEOL(), true);
                                bl2 = true;
                                this.applyLabels(file);
                                string = Res.getString(ResIDs.CHECK_IN_CHECKED_IN);
                                this.fixLocalRW(file2, n);
                                if (!this.isProcessOn()) break block7;
                                this.m_checkedinFiles.addElement(file);
                            }
                            catch (Throwable throwable) {
                                Object var15_17 = null;
                                if (!bl2) {
                                    this.m_markProcessFixed = false;
                                }
                                throw throwable;
                            }
                        }
                        Object var15_16 = null;
                        if (!bl2) {
                            this.m_markProcessFixed = false;
                        }
                    }
                    this.revertLock(n2, folder, file, nArray[0]);
                    this.message(Res.formatKey(ResIDs.CHECK_IN_COMMAND_MSG, new Object[]{file.getName(), string}));
                    break block10;
                }
                this.m_markProcessFixed = false;
                User user = file.getServer().getUser(file.getLocker());
                String string4 = user == null ? Res.getString(ResIDs.CHECK_IN_UNKNOWN) : user.getName();
                this.confirm(Res.formatKey(ResIDs.CHECK_IN_FILE_LOCKED_BY_USER_ERROR_MSG, new Object[]{string4}));
                break block10;
            }
            this.m_markProcessFixed = false;
            this.message(Res.formatKey(ResIDs.CHECK_IN_COMMAND_MSG, new Object[]{file.getName(), string}));
        }
    }

    private boolean isAttached(Label label, Label[] labelArray) {
        int n = labelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Label label2 = labelArray[n2];
            if (label.getID() == label2.getID()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void applyLabels(File file) throws IOException {
        Label[] labelArray = null;
        if (this.getKeepLabelsInPlace()) {
            labelArray = file.getAllLabels();
        }
        if (this.m_cachedLabels != null) {
            int n = 0;
            while (n < this.m_cachedLabels.length) {
                Label label = this.m_cachedLabels[n];
                if (this.getKeepLabelsInPlace() && this.isAttached(label, labelArray)) {
                    label = null;
                }
                if (label != null) {
                    label.moveItem(file, file.getObjectID(), file.getModifiedTime());
                    label.update();
                }
                ++n;
            }
        }
    }

    void processNoFiles() throws IOException {
    }

    private String wontCheckinMsg(int n) {
        switch (n) {
            case 1: {
                return Res.formatKey(ResIDs.CHECK_IN_FILE_STATUS_IS_MERGE_ERROR_MSG, new Object[]{Option.getName("ForceOut")});
            }
            case 5: {
                return Res.formatKey(ResIDs.CHECK_IN_FILE_STATUS_IS_OUT_OF_DATE_ERROR_MSG, new Object[]{Option.getName("ForceOut")});
            }
            case 6: {
                return Res.formatKey(ResIDs.CHECK_IN_STATUS_IS_UNKNOWN_ERROR_MSG, new Object[]{Option.getName("ForceOut")});
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return null;
    }

    private boolean confirmStatusForCheckin(int n, Folder folder, File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        switch (n) {
            case 3: {
                return true;
            }
            case 1: 
            case 5: 
            case 6: {
                if (bl4) {
                    return false;
                }
                if (bl) {
                    return true;
                }
                if (bl2) {
                    if (bl3) {
                        return true;
                    }
                    return this.prompt(Res.formatKey(ResIDs.CHECK_IN_STATUS_PROMPT_MSG, new Object[]{file.getName(), Status.name(n)}));
                }
                this.confirm(this.wontCheckinMsg(n));
                return false;
            }
            case 0: {
                if (bl4) {
                    return false;
                }
                return bl;
            }
        }
        return false;
    }

    private String fixLocalRW(java.io.File file, int n) throws IOException {
        if (n == 3) {
            return EMPTY_STRING;
        }
        if (this.getReadOnly()) {
            Platform.setFileWritable(file, false);
            return Res.getString(ResIDs.CHECK_IN_READ_ONLY_SET_MSG);
        }
        if (this.getReadWrite()) {
            Platform.setFileWritable(file, true);
            return Res.getString(ResIDs.CHECK_IN_READ_WRITE_SET_MSG);
        }
        return EMPTY_STRING;
    }

    private void revertLock(int n, Folder folder, File file, int n2) throws IOException {
        if (n2 != -1) {
            file.putLock(n2, false);
        }
    }

    private boolean verifyLock(int n, Folder folder, File file, int n2, int[] nArray) throws IOException {
        nArray[0] = -1;
        return true;
    }

    CheckIn() {
    }
}

