/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SDKRuntimeException;
import com.starbase.starteam.ServerInfo;
import com.starbase.starteam.XMLServerList;
import com.starbase.util.Assert;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

abstract class XMLServerListParser
extends DefaultHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerInfo[] load(File file) throws IOException {
        ServerInfo[] serverInfoArray;
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                Handler handler = new Handler();
                SAXParserFactory sAXParserFactory = null;
                SAXParser sAXParser = null;
                sAXParserFactory = SAXParserFactory.newInstance();
                sAXParser = sAXParserFactory.newSAXParser();
                sAXParser.parse((InputStream)bufferedInputStream, (DefaultHandler)handler);
                serverInfoArray = handler.getServers();
                Object var4_10 = null;
                if (bufferedInputStream == null) return serverInfoArray;
            }
            catch (SAXException sAXException) {
                throw new SDKRuntimeException(Res.formatKey(ResIDs.BAD_SERVER_LIST_FILE_FMT, new Object[]{file.getPath()}));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Assert.internalError("XMLServerListParser.load()", parserConfigurationException);
                ServerInfo[] serverInfoArray2 = null;
                Object var4_11 = null;
                if (bufferedInputStream == null) return serverInfoArray2;
                ((InputStream)bufferedInputStream).close();
                return serverInfoArray2;
            }
        }
        catch (Throwable throwable) {
            Object var4_12 = null;
            if (bufferedInputStream == null) throw throwable;
            ((InputStream)bufferedInputStream).close();
            throw throwable;
        }
        ((InputStream)bufferedInputStream).close();
        return serverInfoArray;
    }

    private static class Handler
    extends DefaultHandler {
        private Vector m_serverlist = new Vector();
        private int depth = 0;
        public int total = 0;

        public ServerInfo[] getServers() {
            Object[] objectArray = new ServerInfo[this.m_serverlist.size()];
            this.m_serverlist.copyInto(objectArray);
            return objectArray;
        }

        private void expected(String string, String string2) {
            throw new RuntimeException(Res.formatKey(ResIDs.STARTEAM_XML_EXPECTED_BEGINNING_TAG_FMT, new Object[]{string, string2}));
        }

        private void missingAttribute(String string) {
            throw new RuntimeException(Res.formatKey(ResIDs.MISSING_REQUIRED_ATTRIBUTE_FMT, new Object[]{string}));
        }

        private void addServerInfo(Attributes attributes) {
            String string = this.getRequiredAttribute("description", attributes);
            String string2 = this.getRequiredAttribute("host", attributes);
            String string3 = this.getRequiredAttribute("endpoint", attributes);
            String string4 = attributes.getValue("encryption");
            String string5 = attributes.getValue("compression");
            String string6 = this.getRequiredAttribute("protocol", attributes);
            this.m_serverlist.addElement(XMLServerList.newServerInfo(string, string2, string6, string3, string4, string5));
        }

        private String getRequiredAttribute(String string, Attributes attributes) {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                this.missingAttribute(string);
            }
            return string2;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (this.depth == 1) {
                if (string3.equals("server")) {
                    this.addServerInfo(attributes);
                } else {
                    this.expected("server", string3);
                }
            } else if (this.depth == 0) {
                if (string3.equals("serverlist")) {
                    String string4 = attributes.getValue("version");
                    if (string4 == null || !string4.equals("1.0")) {
                        throw new RuntimeException(Res.formatKey(ResIDs.UNSUPPORTED_SERVERLIST_VERSION_FMT, new Object[]{string4}));
                    }
                } else {
                    this.expected("serverlist", string3);
                }
            } else {
                throw new RuntimeException(Res.formatKey(ResIDs.SUB_ELEMENT_NOT_ALLOWED_FMT, new Object[]{string3}));
            }
            ++this.depth;
        }

        public void endElement(String string, String string2, String string3) {
            --this.depth;
        }
    }
}

