/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.IServerList;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.ServerInfo;
import com.starbase.starteam.XMLServerListParser;
import com.starbase.starteam.vts.comm.EncryptionAlgorithm;
import com.starbase.util.Assert;
import com.starbase.util.XMLUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

class XMLServerList
extends XMLServerListParser
implements IServerList {
    static final String ELT_ROOT = "serverlist";
    static final String ELT_SERVER = "server";
    static final String ATT_VERSION = "version";
    static final String CURRENT_VERSION = "1.0";
    static final String ATT_DESCRIPTION = "description";
    static final String ATT_ENCRYPTION = "encryption";
    static final String ATT_COMPRESSION = "compression";
    static final String ATT_HOST = "host";
    static final String ATT_ENDPOINT = "endpoint";
    static final String ATT_PROTOCOL = "protocol";
    private static final String EOL = "\r\n";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String VAL_YES = "yes";
    private static final String VAL_NO = "no";
    private static final String VAL_NO_ENCRYPTION = "none";
    private static final String VAL_RC4 = "RC4";
    private static final String VAL_RC2_ECB = "RC2_ECB";
    private static final String VAL_RC2_CBC = "RC2_CBC";
    private static final String VAL_RC2_CFB = "RC2_CFB";

    private static EncryptionAlgorithm toEncryptionValue(String string) {
        if (string == null) {
            return EncryptionAlgorithm.NULL;
        }
        if (string.equals(VAL_NO_ENCRYPTION)) {
            return EncryptionAlgorithm.NULL;
        }
        if (string.equals(VAL_RC4)) {
            return EncryptionAlgorithm.RC4;
        }
        if (string.equals(VAL_RC2_ECB)) {
            return EncryptionAlgorithm.RC2_ECB;
        }
        if (string.equals(VAL_RC2_CBC)) {
            return EncryptionAlgorithm.RC2_CBC;
        }
        if (string.equals(VAL_RC2_CFB)) {
            return EncryptionAlgorithm.RC2_CFB;
        }
        throw new RuntimeException(Res.formatKey(ResIDs.INVALID_ENCRYPTION_FMT, new Object[]{string}));
    }

    private static String fromEncryptionValue(EncryptionAlgorithm encryptionAlgorithm) {
        if (encryptionAlgorithm == null) {
            return VAL_NO_ENCRYPTION;
        }
        if (encryptionAlgorithm.equals(EncryptionAlgorithm.NULL)) {
            return VAL_NO_ENCRYPTION;
        }
        if (encryptionAlgorithm.equals(EncryptionAlgorithm.RC4)) {
            return VAL_RC4;
        }
        if (encryptionAlgorithm.equals(EncryptionAlgorithm.RC2_CFB)) {
            return VAL_RC2_CFB;
        }
        if (encryptionAlgorithm.equals(EncryptionAlgorithm.RC2_CBC)) {
            return VAL_RC2_CBC;
        }
        if (encryptionAlgorithm.equals(EncryptionAlgorithm.RC2_ECB)) {
            return VAL_RC2_ECB;
        }
        Assert.internalError("XMLServerList.fromEncryptionValue, alg=" + encryptionAlgorithm);
        return null;
    }

    public synchronized ServerInfo[] load(File file) throws IOException {
        return super.load(file);
    }

    static ServerInfo newServerInfo(String string, String string2, String string3, String string4, String string5, String string6) {
        EncryptionAlgorithm encryptionAlgorithm = XMLServerList.toEncryptionValue(string5);
        boolean bl = VAL_YES.equals(string6);
        int n = Integer.parseInt(string3);
        return new ServerInfo(string, n, string2, string4, bl, encryptionAlgorithm);
    }

    public void save(ServerInfo[] serverInfoArray, File file) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            bufferedWriter.write(XML_HEADER);
            bufferedWriter.write(EOL);
            bufferedWriter.write("<serverlist version=\"1.0\">");
            bufferedWriter.write(EOL);
            if (serverInfoArray != null) {
                int n = 0;
                while (n < serverInfoArray.length) {
                    ServerInfo serverInfo = serverInfoArray[n];
                    if (serverInfo != null) {
                        bufferedWriter.write("  <server ");
                        bufferedWriter.write(EOL);
                        XMLServerList.writeAttribute(ATT_DESCRIPTION, serverInfo.getDescription(), bufferedWriter);
                        XMLServerList.writeAttribute(ATT_HOST, serverInfo.getHost(), bufferedWriter);
                        XMLServerList.writeAttribute(ATT_ENDPOINT, serverInfo.getEndpoint(), bufferedWriter);
                        XMLServerList.writeAttribute(ATT_COMPRESSION, serverInfo.isCompression() ? VAL_YES : VAL_NO, bufferedWriter);
                        XMLServerList.writeAttribute(ATT_ENCRYPTION, XMLServerList.fromEncryptionValue(serverInfo.getEncryption()), bufferedWriter);
                        XMLServerList.writeAttribute(ATT_PROTOCOL, Integer.toString(serverInfo.getConnectionType()), bufferedWriter);
                        bufferedWriter.write("  />");
                        bufferedWriter.write(EOL);
                    }
                    ++n;
                }
            }
            bufferedWriter.write("</serverlist>");
            bufferedWriter.write(EOL);
        }
        finally {
            Object var5_6 = null;
            bufferedWriter.close();
        }
    }

    private static void writeAttribute(String string, String string2, Writer writer) throws IOException {
        if (string2 != null) {
            writer.write("    ");
            writer.write(string);
            writer.write("=\"");
            XMLUtils.writeEscapedAttributeValue(string2, writer);
            writer.write("\"");
            writer.write(EOL);
        }
    }
}

