/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.IConfigOptions;
import com.starbase.starteam.XMLConfigParser;
import com.starbase.util.XMLUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;

class XMLConfigOptions
extends XMLConfigParser
implements IConfigOptions {
    static final String ROOT = "StarTeamClientOptions";
    static final String VERSION = "version";
    static final String CURRENT_VERSION = "1.0";
    static final String OPTION = "option";
    static final String CATEGORY = "category";
    static final String NAME = "name";
    static final String VALUE = "value";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String EOL = "\r\n";
    private Hashtable m_rootMap = new Hashtable();

    public void setOption(String string, String string2, String string3) {
        if (string3 == null) {
            Hashtable hashtable = (Hashtable)this.m_rootMap.get(string);
            if (hashtable != null) {
                hashtable.remove(string2);
                if (hashtable.size() == 0) {
                    this.m_rootMap.remove(string);
                }
            }
        } else {
            Hashtable<String, String> hashtable = (Hashtable<String, String>)this.m_rootMap.get(string);
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>();
                this.m_rootMap.put(string, hashtable);
            }
            hashtable.put(string2, string3);
        }
    }

    public String getOption(String string, String string2) {
        Hashtable hashtable = (Hashtable)this.m_rootMap.get(string);
        if (hashtable != null) {
            return (String)hashtable.get(string2);
        }
        return null;
    }

    public void handleOption(String string, String string2, String string3) {
        this.setOption(string, string2, string3);
    }

    public void save(File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "UTF8"));
        bufferedWriter.write(XML_HEADER);
        bufferedWriter.write(EOL);
        bufferedWriter.write("<StarTeamClientOptions version=\"1.0\">");
        bufferedWriter.write(EOL);
        Enumeration enumeration = this.m_rootMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            bufferedWriter.write("<category name=\"");
            XMLUtils.writeEscapedAttributeValue(string, bufferedWriter);
            bufferedWriter.write("\">");
            bufferedWriter.write(EOL);
            Hashtable hashtable = (Hashtable)this.m_rootMap.get(string);
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                String string3 = (String)hashtable.get(string2);
                if (string2 == null || string3 == null) continue;
                bufferedWriter.write("<option name=\"");
                XMLUtils.writeEscapedAttributeValue(string2, bufferedWriter);
                bufferedWriter.write("\" value=\"");
                XMLUtils.writeEscapedAttributeValue(string3, bufferedWriter);
                bufferedWriter.write("\"/>");
                bufferedWriter.write(EOL);
            }
            bufferedWriter.write("</category>");
            bufferedWriter.write(EOL);
            bufferedWriter.write(EOL);
        }
        bufferedWriter.write("</StarTeamClientOptions>");
        bufferedWriter.close();
    }

    public void load(File file) throws IOException {
        this.m_rootMap.clear();
        super.load(file);
    }

    XMLConfigOptions() {
    }
}

