/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.Assert;
import com.starbase.util.OLEDate;
import java.io.IOException;

public class ViewConfiguration {
    static final int CURRENT = 0;
    static final int LABEL = 1;
    static final int TIME = 2;
    static final int PROMOTION = 3;
    private int m_type = 0;
    private double m_value = 0.0;

    public static ViewConfiguration createTip() {
        return new ViewConfiguration(0, 0.0);
    }

    public static ViewConfiguration createFromLabel(int n) {
        return new ViewConfiguration(1, n);
    }

    public static ViewConfiguration createFromTime(OLEDate oLEDate) {
        return new ViewConfiguration(2, oLEDate.getDoubleValue());
    }

    public static ViewConfiguration createFromPromotionState(int n) {
        return new ViewConfiguration(3, n);
    }

    int getType() {
        return this.m_type;
    }

    public int getLabelID() {
        if (!this.isLabelBased()) {
            throw new IllegalStateException(Res.getString(ResIDs.VIEW_CONFIGURATION_NOT_BY_LABEL));
        }
        return (int)this.m_value;
    }

    public int getPromotionStateID() {
        if (!this.isPromotionStateBased()) {
            throw new IllegalStateException(Res.getString(ResIDs.VIEW_CONFIGURATION_NOT_BY_PROMOTION));
        }
        return (int)this.m_value;
    }

    public OLEDate getTime() {
        if (!this.isTimeBased()) {
            throw new IllegalStateException(Res.getString(ResIDs.VIEW_CONFIGURATION_NOT_BY_TIME));
        }
        return new OLEDate(this.m_value);
    }

    public boolean isTip() {
        return this.m_type == 0;
    }

    public boolean isLabelBased() {
        return this.m_type == 1;
    }

    public boolean isTimeBased() {
        return this.m_type == 2;
    }

    public boolean isPromotionStateBased() {
        return this.m_type == 3;
    }

    public String toString() {
        if (this.m_type == 0) {
            return "Current";
        }
        if (this.m_type == 1) {
            return "LabelID: " + Integer.toString(this.getLabelID());
        }
        if (this.m_type == 3) {
            return "PromotionStateID: " + Integer.toString(this.getPromotionStateID());
        }
        return new OLEDate(this.getTime()).toString();
    }

    void readGuts(Command command) throws IOException {
        this.m_type = command.readInt();
        if (command.getRevisionLevel() >= 67) {
            switch (this.m_type) {
                case 0: {
                    break;
                }
                case 1: {
                    this.m_value = command.readInt();
                    break;
                }
                case 3: {
                    this.m_value = command.readInt();
                    break;
                }
                case 2: {
                    this.m_value = command.readTime();
                    break;
                }
                default: {
                    Assert.internalError("ViewConfiguration.readGuts(), type=" + this.m_type);
                    break;
                }
            }
        } else {
            this.m_value = command.readDouble();
            switch (this.m_type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    Assert.internalError("ViewConfiguration.readGuts(), type2=" + this.m_type);
                }
            }
        }
    }

    void writeGuts(Command command) throws IOException {
        command.writeInt(this.m_type);
        if (command.getRevisionLevel() >= 67) {
            switch (this.m_type) {
                case 0: {
                    break;
                }
                case 1: {
                    command.writeInt(this.getLabelID());
                    break;
                }
                case 3: {
                    command.writeInt(this.getPromotionStateID());
                    break;
                }
                case 2: {
                    command.writeTime(this.getTime().getDoubleValue());
                    break;
                }
                default: {
                    Assert.internalError("ViewConfiguration.writeGuts(), type=" + this.m_type);
                    break;
                }
            }
        } else {
            command.writeDouble(this.m_value);
        }
    }

    private ViewConfiguration(int n, double d) {
        this.m_type = n;
        this.m_value = d;
    }
}

