/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CacheRef;
import com.starbase.starteam.Cacheable;
import com.starbase.starteam.CmdGetUsersAndGroups;
import com.starbase.starteam.CmdLoadAllUsers;
import com.starbase.starteam.MPXEventQueue;
import com.starbase.starteam.MPXObjectEvent;
import com.starbase.starteam.MPXUserEvent_Marshaler;
import com.starbase.starteam.MPXUserEvent_Source;
import com.starbase.starteam.Server;
import com.starbase.starteam.Server_CacheManager;
import com.starbase.starteam.SimpleGlobalCache;
import com.starbase.starteam.User;
import com.starbase.starteam.User_Data;
import com.starbase.util.Assert;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class User_Cache
extends SimpleGlobalCache
implements MPXUserEvent_Source {
    private String m_USER_FULL_NAME = null;
    private String m_DELETED_USER_ID = null;
    Vector m_MPXUserEventMarshalers = new Vector();

    public synchronized void handleMPXUserEvent(MPXObjectEvent mPXObjectEvent) {
        String string = mPXObjectEvent.getEventVerb();
        User_Data user_Data = this.getUserData(mPXObjectEvent);
        if (string.equals("New")) {
            this.OnUserAdded(mPXObjectEvent, user_Data);
        } else if (string.equals("Modify")) {
            this.OnUserChanged(mPXObjectEvent, user_Data);
        } else if (string.equals("Delete")) {
            this.OnUserDeleted(mPXObjectEvent, user_Data);
        } else {
            this.setAllDirty();
        }
        MPXEventQueue[] mPXEventQueueArray = this.getEventQueues();
        int n = 0;
        while (n < mPXEventQueueArray.length) {
            MPXEventQueue mPXEventQueue = mPXEventQueueArray[n];
            User_Cache user_Cache = this;
            if (user_Cache == null) {
                throw null;
            }
            mPXEventQueue.postEvent(new Runnable(user_Cache, mPXEventQueue, mPXObjectEvent, user_Data){
                private final /* synthetic */ User_Cache this$0;
                private final /* synthetic */ MPXEventQueue val$Q;
                private final /* synthetic */ MPXObjectEvent val$event;
                private final /* synthetic */ User_Data val$data;

                public void run() {
                    User_Cache.access$0(this.this$0, this.val$Q, this.val$event, this.val$data);
                }
                {
                    this.val$Q = mPXEventQueue;
                    this.val$event = mPXObjectEvent;
                    this.val$data = user_Data;
                    this.this$0 = user_Cache;
                    this.constructor$0(user_Cache);
                }

                private final void constructor$0(User_Cache user_Cache) {
                }
            });
            ++n;
        }
    }

    private User_Data getUserData(MPXObjectEvent mPXObjectEvent) {
        int n = mPXObjectEvent.getObjectID();
        String string = (String)mPXObjectEvent.getValue(this.m_USER_FULL_NAME);
        boolean bl = (Integer)mPXObjectEvent.getValue(this.m_DELETED_USER_ID) != -1;
        return new User_Data(n, string, bl);
    }

    private void OnUserAdded(MPXObjectEvent mPXObjectEvent, User_Data user_Data) {
        this.set(user_Data);
    }

    private void OnUserChanged(MPXObjectEvent mPXObjectEvent, User_Data user_Data) {
        User_Data user_Data2 = (User_Data)this.getCached(user_Data.getID());
        if (user_Data2 == null || !user_Data.isEqualTo(user_Data2)) {
            this.set(user_Data);
        }
    }

    private void OnUserDeleted(MPXObjectEvent mPXObjectEvent, User_Data user_Data) {
        User_Data user_Data2 = (User_Data)this.getCached(user_Data.getID());
        if (user_Data2 == null || !user_Data.isEqualTo(user_Data2)) {
            this.set(user_Data);
        }
    }

    private MPXEventQueue[] getEventQueues() {
        return ((Server_CacheManager)this.getParent()).getEventQueues();
    }

    private void invokeMPXUserEventMarshalers(MPXEventQueue mPXEventQueue, MPXObjectEvent mPXObjectEvent, User_Data user_Data) {
        Vector vector = this.m_MPXUserEventMarshalers;
        synchronized (vector) {
            Enumeration enumeration = this.m_MPXUserEventMarshalers.elements();
            while (enumeration.hasMoreElements()) {
                MPXUserEvent_Marshaler mPXUserEvent_Marshaler = (MPXUserEvent_Marshaler)enumeration.nextElement();
                if (mPXUserEvent_Marshaler.getEventQueue() != mPXEventQueue) continue;
                mPXUserEvent_Marshaler.handleMPXUserEvent(mPXObjectEvent, user_Data);
            }
        }
    }

    public void addMPXUserEventMarshaler(MPXUserEvent_Marshaler mPXUserEvent_Marshaler) {
        Vector vector = this.m_MPXUserEventMarshalers;
        synchronized (vector) {
            this.m_MPXUserEventMarshalers.addElement(mPXUserEvent_Marshaler);
        }
    }

    public void removeMPXUserEventMarshaler(MPXUserEvent_Marshaler mPXUserEvent_Marshaler) {
        Vector vector = this.m_MPXUserEventMarshalers;
        synchronized (vector) {
            this.m_MPXUserEventMarshalers.removeElement(mPXUserEvent_Marshaler);
        }
    }

    protected Cacheable[] fetchAll(Object object) {
        if (object instanceof Server) {
            Server server = (Server)object;
            Cacheable[] cacheableArray = this.fetchUsers(server);
            if (cacheableArray.length == 0) {
                Assert.internalError("User_Cache.fetchAll(), length=0");
            }
            return cacheableArray;
        }
        Assert.internalError("User_Cache.fetchAll(), class=" + object.getClass().getName());
        return null;
    }

    private Cacheable[] fetchUsers(Server server) {
        if (server.supports((short)100, "1.14")) {
            return this.fetchUsersNewWay(server);
        }
        return this.fetchUsersOldWay(server);
    }

    private Cacheable[] fetchUsersNewWay(Server server) {
        CmdGetUsersAndGroups cmdGetUsersAndGroups = new CmdGetUsersAndGroups(server, 1, true);
        cmdGetUsersAndGroups.execute();
        int[] nArray = cmdGetUsersAndGroups.getIDs();
        String[] stringArray = cmdGetUsersAndGroups.getNames();
        Cacheable[] cacheableArray = new User_Data[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            User_Data user_Data = new User_Data(nArray[n], stringArray[n], !cmdGetUsersAndGroups.isCurrent(n));
            cacheableArray[n] = user_Data;
            ++n;
        }
        return cacheableArray;
    }

    private Cacheable[] fetchUsersOldWay(Server server) {
        String string;
        Integer n;
        CmdLoadAllUsers cmdLoadAllUsers = new CmdLoadAllUsers(server, server.getClassID(server.getTypeNames().USER));
        cmdLoadAllUsers.execute();
        Hashtable hashtable = cmdLoadAllUsers.getCurrentUsers();
        Hashtable hashtable2 = cmdLoadAllUsers.getDeletedUsers();
        Cacheable[] cacheableArray = new User_Data[hashtable.size() + hashtable2.size()];
        int n2 = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            string = (String)hashtable.get(n);
            cacheableArray[n2++] = new User_Data(n, string, false);
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            string = (String)hashtable2.get(n);
            cacheableArray[n2++] = new User_Data(n, string, true);
        }
        return cacheableArray;
    }

    protected CacheRef newCacheRef(Object object, Cacheable cacheable) {
        return new User((Server)object, (User_Data)cacheable);
    }

    static /* synthetic */ void access$0(User_Cache user_Cache, MPXEventQueue mPXEventQueue, MPXObjectEvent mPXObjectEvent, User_Data user_Data) {
        user_Cache.invokeMPXUserEventMarshalers(mPXEventQueue, mPXObjectEvent, user_Data);
    }

    User_Cache(Server_CacheManager server_CacheManager, int n) {
        super(server_CacheManager, n);
        this.m_USER_FULL_NAME = server_CacheManager.getPropertyNames().USER_FULL_NAME;
        this.m_DELETED_USER_ID = server_CacheManager.getPropertyNames().DELETED_USER_ID;
    }
}

