/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Cacheable;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.UTF8;
import java.io.IOException;

class UserAccount_Data
extends Cacheable {
    private static final String EMPTY = "";
    protected static byte[] NULL_PASSWORD = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int m_id = -1;
    private String m_fullName = "";
    private String m_emailAddress = "";
    private String m_postalAddress = "";
    private String m_faxNumber = "";
    private String m_pagerNumber = "";
    private String m_phoneNumber = "";
    private String m_vmailNumber = "";
    private String m_logOnName = "";
    private byte[] m_password = UserAccount_Data.manglePassword("");
    private int m_accountStatus = 0;
    private int m_accessPolicyDaysAllowed = 0;
    private short[] m_start1 = new short[]{0, 0, 0, 0, 0, 0, 0};
    private short[] m_end1 = new short[]{0, 0, 0, 0, 0, 0, 0};
    private short[] m_start2 = new short[]{0, 0, 0, 0, 0, 0, 0};
    private short[] m_end2 = new short[]{0, 0, 0, 0, 0, 0, 0};
    private int m_accessPolicyTimeZoneShift = 0;
    private int[] m_groupIDs = new int[0];
    private int m_logOnCount = 0;
    private String[] m_workstations = new String[0];
    private boolean m_bValidateThroughDirectoryService = false;
    private String m_distinguishedName = "";
    private boolean m_bHasFixedLicense = false;

    public Object copy() {
        UserAccount_Data userAccount_Data = (UserAccount_Data)super.copy();
        userAccount_Data.m_start1 = new short[this.m_start1.length];
        int n = 0;
        while (n < this.m_start1.length) {
            userAccount_Data.m_start1[n] = this.m_start1[n];
            ++n;
        }
        userAccount_Data.m_end1 = new short[this.m_end1.length];
        n = 0;
        while (n < this.m_end1.length) {
            userAccount_Data.m_end1[n] = this.m_end1[n];
            ++n;
        }
        userAccount_Data.m_start2 = new short[this.m_start2.length];
        n = 0;
        while (n < this.m_start2.length) {
            userAccount_Data.m_start2[n] = this.m_start2[n];
            ++n;
        }
        userAccount_Data.m_end2 = new short[this.m_end2.length];
        n = 0;
        while (n < this.m_end2.length) {
            userAccount_Data.m_end2[n] = this.m_end2[n];
            ++n;
        }
        userAccount_Data.m_groupIDs = new int[this.m_groupIDs.length];
        n = 0;
        while (n < this.m_groupIDs.length) {
            userAccount_Data.m_groupIDs[n] = this.m_groupIDs[n];
            ++n;
        }
        userAccount_Data.m_workstations = new String[this.m_workstations.length];
        n = 0;
        while (n < this.m_workstations.length) {
            userAccount_Data.m_workstations[n] = this.m_workstations[n];
            ++n;
        }
        return userAccount_Data;
    }

    int getID() {
        return this.m_id;
    }

    void setID(int n) {
        this.m_id = n;
    }

    String getName() {
        return this.m_fullName;
    }

    void setName(String string) {
        this.m_fullName = string;
    }

    String getEmailAddress() {
        return this.m_emailAddress;
    }

    void setEmailAddress(String string) {
        this.m_emailAddress = string;
    }

    String getPostalAddress() {
        return this.m_postalAddress;
    }

    void setPostalAddress(String string) {
        this.m_postalAddress = string;
    }

    String getFaxNumber() {
        return this.m_faxNumber;
    }

    void setFaxNumber(String string) {
        this.m_faxNumber = string;
    }

    String getPagerNumber() {
        return this.m_pagerNumber;
    }

    void setPagerNumber(String string) {
        this.m_pagerNumber = string;
    }

    String getPhoneNumber() {
        return this.m_phoneNumber;
    }

    void setPhoneNumber(String string) {
        this.m_phoneNumber = string;
    }

    String getVoiceMailNumber() {
        return this.m_vmailNumber;
    }

    void setVoiceMailNumber(String string) {
        this.m_vmailNumber = string;
    }

    String getLogOnName() {
        return this.m_logOnName;
    }

    void setLogOnName(String string) {
        this.m_logOnName = string;
    }

    void setPassword(String string) {
        this.m_password = UserAccount_Data.manglePassword(string);
    }

    protected byte[] getPassword() {
        return this.m_password;
    }

    int getAccountStatus() {
        return this.m_accountStatus;
    }

    void setAccountStatus(int n) {
        this.validAccountStatus(n);
        this.m_accountStatus = n;
    }

    int getAccessPolicy() {
        return this.m_accessPolicyDaysAllowed;
    }

    void setAccessPolicy(int n) {
        this.validPolicy(n);
        this.m_accessPolicyDaysAllowed = n;
    }

    int getPolicyTimeZoneShift() {
        return this.m_accessPolicyTimeZoneShift;
    }

    void setPolicyTimeZoneShift(int n) {
        this.m_accessPolicyTimeZoneShift = n;
    }

    int getLogOnCount() {
        return this.m_logOnCount;
    }

    String[] getWorkstations() {
        return this.m_workstations;
    }

    boolean getValidateThroughDirectoryService() {
        return this.m_bValidateThroughDirectoryService;
    }

    void setValidateThroughDirectoryService(boolean bl) {
        this.m_bValidateThroughDirectoryService = bl;
    }

    String getDistinguishedName() {
        return this.m_distinguishedName;
    }

    void setDistinguishedName(String string) {
        this.m_distinguishedName = string;
    }

    boolean getHasFixedLicense() {
        return this.m_bHasFixedLicense;
    }

    void setHasFixedLicense(boolean bl) {
        this.m_bHasFixedLicense = bl;
    }

    int getAccessStartTime1(int n) {
        this.validDay(n);
        return this.m_start1[n];
    }

    int getAccessStartTime2(int n) {
        this.validDay(n);
        return this.m_start2[n];
    }

    int getAccessEndTime1(int n) {
        this.validDay(n);
        return this.m_end1[n];
    }

    int getAccessEndTime2(int n) {
        this.validDay(n);
        return this.m_end2[n];
    }

    void setAccessTimes(int n, int n2, int n3, int n4, int n5) {
        this.validDay(n);
        short s = this.validTime(n2);
        short s2 = this.validTime(n4);
        short s3 = this.validTime(n3);
        short s4 = this.validTime(n5);
        this.m_start1[n] = s;
        this.m_start2[n] = s2;
        this.m_end1[n] = s3;
        this.m_end2[n] = s4;
    }

    private void validAccountStatus(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return;
            }
        }
        String string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{"STATUS_NORMAL", "STATUS_LOCKED_OUT"});
        string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{string, "STATUS_SUSPENDED"});
        string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{string, "STATUS_PASSWORD_CHANGE_REQUIRED"});
        string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{string, "STATUS_PASSWORD_CHANGE_NOTIFIED"});
        throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_ACCOUNT_STATUS_FMT, new Object[]{new Integer(n), string}));
    }

    private void validPolicy(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        String string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{"POLICY_ALWAYS", "POLICY_STANDARD"});
        string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{string, "POLICY_CUSTOM"});
        throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_ACCESS_POLICY_FMT, new Object[]{new Integer(n), string}));
    }

    private void validDay(int n) {
        if (n < 0 || n > 6) {
            Object[] objectArray = new Object[]{new Integer(n), new Integer(0), "DAY_SUNDAY", new Integer(6), "DAY_SATURDAY"};
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_DAY_OF_WEEK_FMT, objectArray));
        }
    }

    private short validTime(int n) {
        int n2 = 0;
        int n3 = 1439;
        int n4 = -1;
        if (n != n4 && (n < n2 || n > n3)) {
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)};
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_MINUTES_FROM_MIDNIGHT_FMT, objectArray));
        }
        return (short)n;
    }

    boolean isNew() {
        return this.getID() == -1;
    }

    public String toString() {
        return this.getName();
    }

    static byte[] manglePassword(String string) {
        int n = 128;
        byte[] byArray = null;
        byArray = UTF8.StringToUtf8(string);
        if (byArray.length >= n) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_PASSWORD_LENGTH_FMT, new Object[]{new Integer(n - 1)}));
        }
        byte[] byArray2 = new byte[n];
        int n2 = 255;
        int n3 = 0;
        while (n3 < n) {
            byArray2[n3] = (byte)n2;
            ++n3;
        }
        n3 = Math.min(n, byArray.length);
        int n4 = 0;
        while (n4 < n3) {
            byArray2[n4] = byArray[n4];
            ++n4;
        }
        n4 = 0;
        while (n4 < n) {
            int n5 = byArray2[n4] ^ byArray.length;
            byArray2[n4] = (byte)(n5 & 0xFF);
            ++n4;
        }
        return byArray2;
    }

    static String mangledPasswordAsString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append((char)(byArray[n] & 0xFF));
            ++n;
        }
        return stringBuffer.toString();
    }

    static byte[] mangledPasswordAsBytes(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(string.charAt(n2) & 0xFF);
            ++n2;
        }
        return byArray;
    }

    int[] getGroupIDs() {
        return this.m_groupIDs;
    }

    boolean hasGroup(int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.m_groupIDs.length) {
            if (this.m_groupIDs[n2] == n) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    void setGroupIDs(int[] nArray) {
        this.m_groupIDs = nArray;
    }

    void addGroupID(int n) {
        int n2 = this.m_groupIDs.length;
        int[] nArray = new int[n2 + 1];
        System.arraycopy(this.m_groupIDs, 0, nArray, 0, n2);
        nArray[n2] = n;
        this.m_groupIDs = nArray;
    }

    String debugDump() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append(super.toString() + string);
        stringBuffer.append(" Name: " + this.getName() + string);
        stringBuffer.append(" EmailAddress: " + this.getEmailAddress() + string);
        stringBuffer.append(" PostalAddress: " + this.getPostalAddress() + string);
        stringBuffer.append(" FaxNumber: " + this.getFaxNumber() + string);
        stringBuffer.append(" PagerNumber: " + this.getPagerNumber() + string);
        stringBuffer.append(" PhoneNumber: " + this.getPhoneNumber() + string);
        stringBuffer.append(" VoiceMailNumber: " + this.getVoiceMailNumber() + string);
        stringBuffer.append(" LogOnName: " + this.getLogOnName() + string);
        stringBuffer.append(" LogOnCount: " + this.getLogOnCount() + string);
        stringBuffer.append(" AccountStatus: " + this.getAccountStatus() + string);
        stringBuffer.append(" AccessPolicy: " + this.getAccessPolicy() + string);
        stringBuffer.append(" PolicyTimeZoneShift: " + this.getPolicyTimeZoneShift() + string);
        stringBuffer.append("   Sun: " + this.range(0) + string);
        stringBuffer.append("   Mon: " + this.range(1) + string);
        stringBuffer.append("   Tue: " + this.range(2) + string);
        stringBuffer.append("   Wed: " + this.range(3) + string);
        stringBuffer.append("   Thu: " + this.range(4) + string);
        stringBuffer.append("   Fri: " + this.range(5) + string);
        stringBuffer.append("   Sat: " + this.range(6) + string);
        stringBuffer.append(" Workstations: " + string);
        int n = 0;
        while (n < this.m_workstations.length) {
            stringBuffer.append("   [" + n + "]: " + this.m_workstations[n] + string);
            ++n;
        }
        stringBuffer.append("HasFixedLicense: " + this.m_bHasFixedLicense + string);
        return stringBuffer.toString();
    }

    private String range(int n) {
        return this.getAccessStartTime1(n) + " .. " + this.getAccessEndTime1(n) + "; " + this.getAccessStartTime2(n) + " .. " + this.getAccessEndTime2(n);
    }

    void readUserInfo(Command command) throws IOException {
        this.readSelfUserInfo(command);
        this.m_accountStatus = command.readInt();
        this.m_accessPolicyDaysAllowed = command.readInt();
        int n = 0;
        while (n < 7) {
            this.m_start1[n] = command.readShort();
            this.m_end1[n] = command.readShort();
            this.m_start2[n] = command.readShort();
            this.m_end2[n] = command.readShort();
            ++n;
        }
        this.m_accessPolicyTimeZoneShift = command.readInt();
        n = command.readInt();
        this.m_groupIDs = new int[n];
        int n2 = 0;
        while (n2 < this.m_groupIDs.length) {
            this.m_groupIDs[n2] = command.readInt();
            ++n2;
        }
        this.m_logOnCount = command.readInt();
        n = command.readInt();
        this.m_workstations = new String[n];
        n2 = 0;
        while (n2 < this.m_workstations.length) {
            this.m_workstations[n2] = command.readString();
            ++n2;
        }
        if (command.getRevisionLevel() >= 84) {
            boolean bl = this.m_bHasFixedLicense = command.readInt() != 0;
        }
        if (command.supports((short)100, "1.11")) {
            this.m_bValidateThroughDirectoryService = command.readBoolean();
            this.m_distinguishedName = command.readString();
        }
    }

    void readSelfUserInfo(Command command) throws IOException {
        this.setID(command.readInt());
        this.setName(command.readString());
        this.setEmailAddress(command.readString());
        this.setPostalAddress(command.readString());
        this.setFaxNumber(command.readString());
        this.setPagerNumber(command.readString());
        this.setPhoneNumber(command.readString());
        this.setVoiceMailNumber(command.readString());
        this.setLogOnName(command.readString());
        if (command.getRevisionLevel() >= 67) {
            this.m_password = command.readVariantBytes();
        } else {
            String string = command.readString();
            this.m_password = UserAccount_Data.mangledPasswordAsBytes(string);
        }
    }

    void writeSelfUserInfo(Command command) throws IOException {
        command.writeInt(this.getID());
        command.writeString(this.getName());
        command.writeString(this.getEmailAddress());
        command.writeString(this.getPostalAddress());
        command.writeString(this.getFaxNumber());
        command.writeString(this.getPagerNumber());
        command.writeString(this.getPhoneNumber());
        command.writeString(this.getVoiceMailNumber());
        command.writeString(this.getLogOnName());
        if (command.getRevisionLevel() >= 67) {
            command.writeVariantBytes(this.getPassword());
        } else {
            command.writeString(UserAccount_Data.mangledPasswordAsString(this.getPassword()));
        }
    }

    void writeUserInfo(Command command) throws IOException {
        this.writeSelfUserInfo(command);
        command.writeInt(this.m_accountStatus);
        command.writeInt(this.m_accessPolicyDaysAllowed);
        int n = 0;
        while (n < 7) {
            command.writeShort(this.m_start1[n]);
            command.writeShort(this.m_end1[n]);
            command.writeShort(this.m_start2[n]);
            command.writeShort(this.m_end2[n]);
            ++n;
        }
        command.writeInt(this.m_accessPolicyTimeZoneShift);
        command.writeInt(this.m_groupIDs.length);
        n = 0;
        while (n < this.m_groupIDs.length) {
            command.writeInt(this.m_groupIDs[n]);
            ++n;
        }
        command.writeInt(this.m_logOnCount);
        command.writeInt(this.m_workstations.length);
        n = 0;
        while (n < this.m_workstations.length) {
            command.writeString(this.m_workstations[n]);
            ++n;
        }
        if (command.getRevisionLevel() >= 84) {
            command.writeInt(this.m_bHasFixedLicense ? 1 : 0);
        }
        if (command.supports((short)100, "1.11")) {
            command.writeBoolean(this.m_bValidateThroughDirectoryService);
            command.writeString(this.m_distinguishedName);
        }
    }

    public boolean isEqualTo(Cacheable cacheable) {
        if (cacheable != null && cacheable instanceof UserAccount_Data) {
            UserAccount_Data userAccount_Data = (UserAccount_Data)cacheable;
            if (this.getID() == userAccount_Data.getID() && this.getName().equals(userAccount_Data.getName()) && this.getEmailAddress().equals(userAccount_Data.getEmailAddress()) && this.getPostalAddress().equals(userAccount_Data.getPostalAddress()) && this.getFaxNumber().equals(userAccount_Data.getFaxNumber()) && this.getPagerNumber().equals(userAccount_Data.getPagerNumber()) && this.getPhoneNumber().equals(userAccount_Data.getPhoneNumber()) && this.getVoiceMailNumber().equals(userAccount_Data.getVoiceMailNumber()) && this.getLogOnName().equals(userAccount_Data.getLogOnName()) && this.getAccountStatus() == userAccount_Data.getAccountStatus() && this.getAccessPolicy() == userAccount_Data.getAccessPolicy() && this.getPolicyTimeZoneShift() == userAccount_Data.getPolicyTimeZoneShift() && this.getLogOnCount() == userAccount_Data.getLogOnCount() && this.getHasFixedLicense() == userAccount_Data.getHasFixedLicense() && this.getValidateThroughDirectoryService() == userAccount_Data.getValidateThroughDirectoryService() && this.getDistinguishedName() == userAccount_Data.getDistinguishedName()) {
                int[] nArray = userAccount_Data.getGroupIDs();
                if (this.m_groupIDs.length != nArray.length) {
                    return false;
                }
                String[] stringArray = userAccount_Data.getWorkstations();
                if (this.m_workstations.length != stringArray.length) {
                    return false;
                }
                int n = 0;
                while (n < 7) {
                    if (this.getAccessStartTime1(n) != userAccount_Data.getAccessStartTime1(n) || this.getAccessStartTime2(n) != userAccount_Data.getAccessStartTime2(n) || this.getAccessEndTime1(n) != userAccount_Data.getAccessEndTime1(n) || this.getAccessEndTime2(n) != userAccount_Data.getAccessEndTime2(n)) {
                        return false;
                    }
                    ++n;
                }
                n = 0;
                while (n < this.m_groupIDs.length) {
                    if (this.m_groupIDs[n] != nArray[n]) {
                        return false;
                    }
                    ++n;
                }
                n = 0;
                while (n < this.m_workstations.length) {
                    if (!this.m_workstations[n].equals(stringArray[n])) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    protected void markPasswordClear() {
        this.m_password = NULL_PASSWORD;
    }

    protected boolean isPasswordNull() {
        if (this.m_password == NULL_PASSWORD) {
            return true;
        }
        if (this.m_password.length != NULL_PASSWORD.length) {
            return false;
        }
        int n = 0;
        while (n < NULL_PASSWORD.length) {
            if (this.m_password[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    UserAccount_Data() {
    }
}

