/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CacheRef;
import com.starbase.starteam.CmdAddUser;
import com.starbase.starteam.CmdModifySpecificUser;
import com.starbase.starteam.CmdRemoveUser;
import com.starbase.starteam.CmdUserAdminOp;
import com.starbase.starteam.GroupAccount;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.Server;
import com.starbase.starteam.UserAccount_Data;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.Assert;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UserAccount
extends CacheRef {
    public static final int STATUS_NORMAL = 0;
    public static final int STATUS_LOCKED_OUT = 1;
    public static final int STATUS_SUSPENDED = 2;
    public static final int STATUS_PASSWORD_CHANGE_REQUIRED = 3;
    public static final int STATUS_PASSWORD_CHANGE_NOTIFIED = 4;
    public static final int POLICY_ALWAYS = 0;
    public static final int POLICY_STANDARD = 1;
    public static final int POLICY_CUSTOM = 2;
    public static final int DAY_SUNDAY = 0;
    public static final int DAY_MONDAY = 1;
    public static final int DAY_TUESDAY = 2;
    public static final int DAY_WEDNESDAY = 3;
    public static final int DAY_THURSDAY = 4;
    public static final int DAY_FRIDAY = 5;
    public static final int DAY_SATURDAY = 6;
    private static final int SCOPE_SELF = 1;
    private static final int SCOPE_PARENT_GROUPS = 2;
    private static final int SCOPE_ALL = 65535;
    private Server m_server;
    private Vector m_groupList = new Vector();
    private UserAccount_Data m_newData = null;

    private UserAccount_Data getData() {
        return this.m_newData == null ? (UserAccount_Data)this.getCachedObject() : this.m_newData;
    }

    private UserAccount_Data getNewData() {
        if (this.m_newData == null) {
            this.m_newData = (UserAccount_Data)this.getData().copy();
        }
        return this.m_newData;
    }

    private boolean isDirty() {
        if (this.isNew()) {
            return true;
        }
        if (this.m_newData == null) {
            return false;
        }
        if (!this.m_newData.isPasswordNull()) {
            return true;
        }
        return !this.getNewData().isEqualTo(this.getCachedObject());
    }

    public UserAccount copy() {
        UserAccount userAccount = new UserAccount(this.m_server, (UserAccount_Data)this.getData().copy());
        userAccount.m_groupList = this.m_groupList;
        return userAccount;
    }

    public int getID() {
        return this.getData().getID();
    }

    void setID(int n) {
        this.getNewData().setID(n);
    }

    public String getName() {
        return this.getData().getName();
    }

    public void setName(String string) {
        this.getNewData().setName(string);
    }

    public String getEmailAddress() {
        return this.getData().getEmailAddress();
    }

    public void setEmailAddress(String string) {
        this.getNewData().setEmailAddress(string);
    }

    public String getPostalAddress() {
        return this.getData().getPostalAddress();
    }

    public void setPostalAddress(String string) {
        this.getNewData().setPostalAddress(string);
    }

    public String getFaxNumber() {
        return this.getData().getFaxNumber();
    }

    public void setFaxNumber(String string) {
        this.getNewData().setFaxNumber(string);
    }

    public String getPagerNumber() {
        return this.getData().getPagerNumber();
    }

    public void setPagerNumber(String string) {
        this.getNewData().setPagerNumber(string);
    }

    public String getPhoneNumber() {
        return this.getData().getPhoneNumber();
    }

    public void setPhoneNumber(String string) {
        this.getNewData().setPhoneNumber(string);
    }

    public String getVoiceMailNumber() {
        return this.getData().getVoiceMailNumber();
    }

    public void setVoiceMailNumber(String string) {
        this.getNewData().setVoiceMailNumber(string);
    }

    public String getLogOnName() {
        return this.getData().getLogOnName();
    }

    public void setLogOnName(String string) {
        this.getNewData().setLogOnName(string);
    }

    public void setPassword(String string) {
        this.getNewData().setPassword(string);
    }

    protected byte[] getPassword() {
        return this.getData().getPassword();
    }

    public int getAccountStatus() {
        return this.getData().getAccountStatus();
    }

    public void setAccountStatus(int n) {
        this.getNewData().setAccountStatus(n);
    }

    public int getAccessPolicy() {
        return this.getData().getAccessPolicy();
    }

    public void setAccessPolicy(int n) {
        this.getNewData().setAccessPolicy(n);
    }

    public int getPolicyTimeZoneShift() {
        return this.getData().getPolicyTimeZoneShift();
    }

    public void setPolicyTimeZoneShift(int n) {
        this.getNewData().setPolicyTimeZoneShift(n);
    }

    public int getLogOnCount() {
        return this.getData().getLogOnCount();
    }

    public String[] getWorkstations() {
        return this.getData().getWorkstations();
    }

    public boolean getValidateThroughDirectoryService() {
        return this.getData().getValidateThroughDirectoryService();
    }

    public void setValidateThroughDirectoryService(boolean bl) {
        this.getNewData().setValidateThroughDirectoryService(bl);
    }

    public String getDistinguishedName() {
        return this.getData().getDistinguishedName();
    }

    public void setDistinguishedName(String string) {
        this.getNewData().setDistinguishedName(string);
    }

    public boolean getHasFixedLicense() {
        if (this.m_server.getRevisionLevel() >= 84) {
            return this.getData().getHasFixedLicense();
        }
        return true;
    }

    public void setHasFixedLicense(boolean bl) {
        if (!bl) {
            this.m_server.getSupportedFeatures().verifyHasConcurrentLicensing();
        }
        this.getNewData().setHasFixedLicense(bl);
    }

    public int getAccessStartTime1(int n) {
        return this.getData().getAccessStartTime1(n);
    }

    public int getAccessStartTime2(int n) {
        return this.getData().getAccessStartTime2(n);
    }

    public int getAccessEndTime1(int n) {
        return this.getData().getAccessEndTime1(n);
    }

    public int getAccessEndTime2(int n) {
        return this.getData().getAccessEndTime2(n);
    }

    public void setAccessTimes(int n, int n2, int n3, int n4, int n5) {
        this.getNewData().setAccessTimes(n, n2, n3, n4, n5);
    }

    public boolean isNew() {
        return this.getData().isNew();
    }

    public String toString() {
        return this.getName();
    }

    void fixGroupList(Hashtable hashtable) {
        boolean bl = false;
        this.m_groupList = new Vector();
        int[] nArray = this.getData().getGroupIDs();
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            GroupAccount groupAccount = (GroupAccount)hashtable.get(new Integer(n2));
            if (groupAccount != null) {
                this.m_groupList.addElement(groupAccount);
                groupAccount.addUserAccount(this);
            } else {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            this.resyncGroupIDs();
        }
    }

    void resyncGroupIDs() {
        int[] nArray = new int[this.m_groupList.size()];
        int n = 0;
        while (n < this.m_groupList.size()) {
            nArray[n] = ((GroupAccount)this.m_groupList.elementAt(n)).getID();
            ++n;
        }
        this.getNewData().setGroupIDs(nArray);
    }

    public void addToGroupAccount(GroupAccount groupAccount) {
        if (groupAccount == null) {
            Assert.nullArgument("GroupAccount");
        }
        if (this.m_server != groupAccount.getServer()) {
            throw new IllegalArgumentException(Res.getString(ResIDs.USER_AND_GROUP_NOT_SAME_SERVER));
        }
        int n = groupAccount.getID();
        if (n == -1) {
            throw new IllegalArgumentException(Res.getString(ResIDs.GROUP_IS_NEW));
        }
        if (!this.getData().hasGroup(n)) {
            this.m_groupList.addElement(groupAccount);
            groupAccount.addUserAccount(this);
            this.getNewData().addGroupID(n);
        }
    }

    public void removeFromGroupAccount(GroupAccount groupAccount) {
        if (groupAccount == null) {
            Assert.nullArgument("GroupAccount");
        }
        if (this.m_server != groupAccount.getServer()) {
            throw new IllegalArgumentException(Res.getString(ResIDs.USER_AND_GROUP_NOT_SAME_SERVER));
        }
        int n = groupAccount.getID();
        if (n == -1) {
            throw new IllegalArgumentException(Res.getString(ResIDs.GROUP_IS_NEW));
        }
        if (this.getData().hasGroup(n)) {
            Vector<GroupAccount> vector = new Vector<GroupAccount>();
            int n2 = this.m_groupList.size();
            int n3 = 0;
            while (n3 < n2) {
                GroupAccount groupAccount2 = (GroupAccount)this.m_groupList.elementAt(n3);
                if (groupAccount2.getID() != n) {
                    vector.addElement(groupAccount2);
                } else {
                    groupAccount2.removeUserAccount(this);
                }
                ++n3;
            }
            this.m_groupList = vector;
            this.resyncGroupIDs();
        }
    }

    public GroupAccount[] getGroupAccounts() {
        Object[] objectArray = new GroupAccount[this.m_groupList.size()];
        this.m_groupList.copyInto(objectArray);
        return objectArray;
    }

    String debugDump() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append(this.getData().debugDump());
        GroupAccount[] groupAccountArray = this.getGroupAccounts();
        stringBuffer.append("Groups: " + groupAccountArray.length + string);
        int n = 0;
        while (n < groupAccountArray.length) {
            stringBuffer.append("  " + groupAccountArray[n].getName() + string);
            ++n;
        }
        return stringBuffer.toString();
    }

    void readUserInfo(Command command) throws IOException {
        this.getData().readUserInfo(command);
    }

    void writeUserInfo(Command command) throws IOException {
        this.getData().writeUserInfo(command);
    }

    public void update() {
        if (!this.isDirty()) {
            if (this.m_newData != null) {
                this.m_newData = null;
            }
            return;
        }
        if (this.isNew()) {
            if (this.getValidateThroughDirectoryService()) {
                this.getData().markPasswordClear();
            }
            CmdAddUser cmdAddUser = new CmdAddUser(this.m_server, this);
            cmdAddUser.execute();
            Enumeration enumeration = this.m_groupList.elements();
            while (enumeration.hasMoreElements()) {
                GroupAccount groupAccount = (GroupAccount)enumeration.nextElement();
                groupAccount.removeUserAccountByID(-1);
                groupAccount.addUserAccount(this);
            }
        } else {
            CmdModifySpecificUser cmdModifySpecificUser = new CmdModifySpecificUser(this.m_server, this);
            cmdModifySpecificUser.execute();
        }
        this.getData().markPasswordClear();
        this.setCachedObject(this.getData());
        this.m_newData = null;
    }

    public void remove() {
        if (!this.isNew()) {
            CmdRemoveUser cmdRemoveUser = new CmdRemoveUser(this.m_server, this.getID());
            cmdRemoveUser.execute();
            while (this.m_groupList.size() > 0) {
                this.removeFromGroupAccount((GroupAccount)this.m_groupList.elementAt(0));
            }
        } else {
            throw new IllegalStateException(Res.getString(ResIDs.USER_IS_NEW));
        }
    }

    public void unlock() {
        if (this.isNew()) {
            throw new IllegalStateException(Res.getString(ResIDs.USER_IS_NEW));
        }
        int n = 1;
        CmdUserAdminOp cmdUserAdminOp = new CmdUserAdminOp(this.m_server, this.getID(), n);
        cmdUserAdminOp.execute();
    }

    public void reactivate() {
        if (this.isNew()) {
            throw new IllegalStateException(Res.getString(ResIDs.USER_IS_NEW));
        }
        int n = 2;
        CmdUserAdminOp cmdUserAdminOp = new CmdUserAdminOp(this.m_server, this.getID(), n);
        cmdUserAdminOp.execute();
    }

    public void suspend() {
        if (this.isNew()) {
            throw new IllegalStateException(Res.getString(ResIDs.USER_IS_NEW));
        }
        int n = 3;
        CmdUserAdminOp cmdUserAdminOp = new CmdUserAdminOp(this.m_server, this.getID(), n);
        cmdUserAdminOp.execute();
    }

    public void forcePasswordChange() {
        if (this.isNew()) {
            throw new IllegalStateException(Res.getString(ResIDs.USER_IS_NEW));
        }
        int n = 4;
        CmdUserAdminOp cmdUserAdminOp = new CmdUserAdminOp(this.m_server, this.getID(), n);
        cmdUserAdminOp.execute();
    }

    public void forceLogoff() {
        if (this.isNew()) {
            throw new IllegalStateException(Res.getString(ResIDs.USER_IS_NEW));
        }
        int n = 11;
        CmdUserAdminOp cmdUserAdminOp = new CmdUserAdminOp(this.m_server, this.getID(), n);
        cmdUserAdminOp.execute();
    }

    public boolean isEqualTo(UserAccount userAccount) {
        return this.isEqualTo(userAccount, 1);
    }

    private boolean isEqualTo(UserAccount userAccount, int n) {
        if (userAccount == null) {
            return false;
        }
        if ((n & 1) != 0 && !this.getData().isEqualTo(userAccount.getData())) {
            return false;
        }
        if ((n & 2) != 0) {
            GroupAccount[] groupAccountArray;
            GroupAccount[] groupAccountArray2 = this.getGroupAccounts();
            if (groupAccountArray2.length != (groupAccountArray = userAccount.getGroupAccounts()).length) {
                return false;
            }
            int n2 = 0;
            while (n2 < groupAccountArray2.length) {
                if (groupAccountArray2[n2].getID() != groupAccountArray[n2].getID()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    UserAccount(Server server, UserAccount_Data userAccount_Data) {
        super(userAccount_Data);
        this.m_server = server;
    }

    public UserAccount(Server server) {
        super(new UserAccount_Data());
        this.m_server = server;
        this.setPassword("");
    }
}

