/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.vts.comm.Command;
import java.io.IOException;

public class SystemPolicy {
    private static final int PROTECT_LOG = 1;
    private static final int PROTECT_CONFIGURATION = 2;
    private static final int PROTECT_SECURITY = 4;
    private static final int PROTECT_REMOTE_ADMIN = 8;
    private static final int PROTECT_SKIP_OWNERSHIP_CHECK = 16;
    private static final int PROTECT_SKIP_PRIVILEGES_CHECK = 32;
    private static final int PROTECT_STRONG_PASSWORD_RULES = 256;
    private static final int ALERT_BY_PAGER = 1;
    private static final int ALERT_BY_EMAIL = 2;
    private static final int ALERT_BY_VOICEMAIL = 4;
    private static final int AUDIT_LOGIN_LOGOFF = 1;
    private static final int AUDIT_SYS_POLICY_CHANGE = 2;
    private static final int AUDIT_ACL_CHANGE = 4;
    private static final int AUDIT_USER_GROUP_MGMT = 8;
    private static final int AUDIT_OBJECT_ACCESS = 16;
    public static final int ALLOW_BLANK_PASSWORDS = 0;
    public static final int PASSWORDS_NEVER_EXPIRE = Integer.MAX_VALUE;
    public static final int FAILED_LOGIN_NO_LIMIT = Integer.MAX_VALUE;
    public static final int LOCKOUT_FOREVER = Integer.MAX_VALUE;
    public static final int SECURITYLOG_AUTOPURGE_NEVER = 0;
    public static final int SECURITYLOG_AUTOPURGE_DEFAULT = 180;
    private int m_revisionLevel = 0;
    private int m_dwProtectFlags = 0;
    private int m_nMinPasswordLength = 0;
    private int m_nPasswordValidityLength = 0;
    private int m_nFailedLoginLimit = 0;
    private int m_nFailedLoginLockout = 0;
    private int m_dwAlertFlags = 0;
    private int m_dwAuditSuccess = 0;
    private int m_dwAuditFailure = 0;
    private int m_nSecLogAutoPurgeDays = 0;

    public boolean getSkipOwnershipCheck() {
        return (this.m_dwProtectFlags & 0x10) != 0;
    }

    public void setSkipOwnershipCheck(boolean bl) {
        this.m_dwProtectFlags = bl ? (this.m_dwProtectFlags |= 0x10) : (this.m_dwProtectFlags &= 0xFFFFFFEF);
    }

    public boolean getSkipGroupPrivilegesCheck() {
        return (this.m_dwProtectFlags & 0x20) != 0;
    }

    public void setSkipGroupPrivilegesCheck(boolean bl) {
        this.m_dwProtectFlags = bl ? (this.m_dwProtectFlags |= 0x20) : (this.m_dwProtectFlags &= 0xFFFFFFDF);
    }

    public boolean isStrongPasswordRulesSupported() {
        return this.m_revisionLevel >= 83;
    }

    public boolean getStrongPasswordRulesEnforced() {
        return (this.m_dwProtectFlags & 0x100) != 0;
    }

    public void setStrongPasswordRulesEnforced(boolean bl) {
        this.m_dwProtectFlags = bl ? (this.m_dwProtectFlags |= 0x100) : (this.m_dwProtectFlags &= 0xFFFFFEFF);
    }

    public int getMinimumPasswordLength() {
        return this.m_nMinPasswordLength;
    }

    public void setMinimumPasswordLength(int n) {
        this.m_nMinPasswordLength = n;
    }

    public int getPasswordExpirationPeriod() {
        return this.m_nPasswordValidityLength;
    }

    public void setPasswordExpirationPeriod(int n) {
        this.m_nPasswordValidityLength = n;
    }

    public int getFailedLoginLimit() {
        return this.m_nFailedLoginLimit;
    }

    public void setFailedLoginLimit(int n) {
        this.m_nFailedLoginLimit = n;
    }

    public int getFailedLoginLockout() {
        return this.m_nFailedLoginLockout;
    }

    public void setFailedLoginLockout(int n) {
        this.m_nFailedLoginLockout = n;
    }

    public boolean getNotifyByEmail() {
        return (this.m_dwAlertFlags & 2) != 0;
    }

    public void setNotifyByEmail(boolean bl) {
        this.m_dwAlertFlags = bl ? (this.m_dwAlertFlags |= 2) : (this.m_dwAlertFlags &= 0xFFFFFFFD);
    }

    public int getSecurityLogAutoPurgeDays() {
        return this.m_nSecLogAutoPurgeDays;
    }

    public void setSecurityLogAutoPurgeDays(int n) {
        this.m_nSecLogAutoPurgeDays = n;
    }

    static SystemPolicy read(Command command) throws IOException {
        SystemPolicy systemPolicy = new SystemPolicy();
        systemPolicy.readGuts(command);
        return systemPolicy;
    }

    void readGuts(Command command) throws IOException {
        this.m_revisionLevel = command.getRevisionLevel();
        this.m_dwProtectFlags = command.readInt();
        this.m_nMinPasswordLength = command.readInt();
        this.m_nPasswordValidityLength = command.readInt();
        this.m_nFailedLoginLimit = command.readInt();
        this.m_nFailedLoginLockout = command.readInt();
        this.m_dwAlertFlags = command.readInt();
        this.m_dwAuditSuccess = command.readInt();
        this.m_dwAuditFailure = command.readInt();
        if (this.m_revisionLevel >= 60) {
            this.m_nSecLogAutoPurgeDays = command.readInt();
        }
    }

    void writeGuts(Command command) throws IOException {
        command.writeInt(this.m_dwProtectFlags);
        command.writeInt(this.m_nMinPasswordLength);
        command.writeInt(this.m_nPasswordValidityLength);
        command.writeInt(this.m_nFailedLoginLimit);
        command.writeInt(this.m_nFailedLoginLockout);
        command.writeInt(this.m_dwAlertFlags);
        command.writeInt(this.m_dwAuditSuccess);
        command.writeInt(this.m_dwAuditFailure);
        if (command.getRevisionLevel() >= 60) {
            command.writeInt(this.m_nSecLogAutoPurgeDays);
        }
    }

    SystemPolicy() {
    }
}

