/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.File;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Project;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SDKRuntimeException;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerInfo;
import com.starbase.starteam.ServerList;
import com.starbase.starteam.StarTeamURL;
import com.starbase.starteam.View;
import com.starbase.starteam.vts.comm.EncryptionAlgorithm;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class StarTeamFinder {
    public static Server openServer(String string) {
        StarTeamURL starTeamURL = new StarTeamURL(string);
        Server server = null;
        String string2 = starTeamURL.getPort();
        if (string2 != null) {
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SDKRuntimeException(Res.formatKey(ResIDs.INVALID_PORT_FMT, new Object[]{string2}), numberFormatException);
            }
            server = new Server(starTeamURL.getHostName(), n, EncryptionAlgorithm.NULL, false, starTeamURL.getProtocol());
        } else {
            String string3 = starTeamURL.getHostName();
            ServerInfo serverInfo = null;
            try {
                ServerList serverList = new ServerList();
                serverList.loadFrom(ServerList.getDefaultFile());
                serverInfo = serverList.find(string3);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (serverInfo != null) {
                server = new Server(serverInfo);
            } else {
                throw new SDKRuntimeException(Res.formatKey(ResIDs.INVALID_SERVER_NAME_FMT, new Object[]{string3}));
            }
        }
        server.logOn(starTeamURL.getUserName(), starTeamURL.getPassword());
        return server;
    }

    public static Project openProject(String string) {
        Server server = StarTeamFinder.openServer(string);
        StarTeamURL starTeamURL = new StarTeamURL(string);
        Project[] projectArray = server.getProjects();
        Project project = null;
        int n = 0;
        while (n < projectArray.length) {
            Project project2 = projectArray[n];
            if (project2.getName().equalsIgnoreCase(starTeamURL.getProjectName())) {
                project = project2;
                break;
            }
            ++n;
        }
        if (project == null) {
            server.disconnect();
        }
        return project;
    }

    public static View openViewWithOverride(String string, String string2) {
        Project project = StarTeamFinder.openProject(string);
        if (project == null) {
            return null;
        }
        StarTeamURL starTeamURL = new StarTeamURL(string);
        StringTokenizer stringTokenizer = starTeamURL.getFolders();
        View view = null;
        if (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            View view2 = null;
            View[] viewArray = project.getViews();
            int n = 0;
            while (n < viewArray.length) {
                View view3 = viewArray[n];
                if (view3.getName().equalsIgnoreCase(string3)) {
                    view2 = view3;
                    break;
                }
                ++n;
            }
            view = view2;
        } else {
            view = project.getDefaultView();
        }
        if (view == null) {
            project.getServer().disconnect();
        } else if (string2 != null) {
            view.getRootFolder().setAlternatePathFragment(string2);
        }
        return view;
    }

    public static View openView(String string) {
        return StarTeamFinder.openViewWithOverride(string, null);
    }

    public static Folder openFolderWithOverride(String string, String string2) {
        View view = StarTeamFinder.openViewWithOverride(string, string2);
        if (view == null) {
            return null;
        }
        StarTeamURL starTeamURL = new StarTeamURL(string);
        StringTokenizer stringTokenizer = starTeamURL.getFolders();
        stringTokenizer.nextToken();
        Folder folder = StarTeamFinder.find(view.getRootFolder(), stringTokenizer);
        if (folder == null) {
            view.getServer().disconnect();
        }
        return folder;
    }

    public static Folder openFolder(String string) {
        return StarTeamFinder.openFolderWithOverride(string, null);
    }

    public static Folder findFolder(Folder folder, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/\\");
        return StarTeamFinder.find(folder, stringTokenizer);
    }

    public static Folder findSubFolder(Folder folder, String string) {
        Folder[] folderArray = folder.getSubFolders();
        int n = 0;
        while (n < folderArray.length) {
            if (string.equalsIgnoreCase(folderArray[n].getName())) {
                return folderArray[n];
            }
            ++n;
        }
        return null;
    }

    public static File findFile(Folder folder, String string, boolean bl) {
        File file = null;
        Enumeration enumeration = folder.enumerateItems(folder.getTypeNames().FILE);
        String string2 = string;
        if (!bl) {
            string2 = string2.toLowerCase();
        }
        while (enumeration.hasMoreElements()) {
            File file2 = (File)enumeration.nextElement();
            String string3 = file2.getName();
            if (!bl) {
                string3 = string3.toLowerCase();
            }
            if (!string3.equals(string2)) continue;
            file = file2;
            break;
        }
        return file;
    }

    private static Folder find(Folder folder, StringTokenizer stringTokenizer) {
        if (stringTokenizer.hasMoreElements()) {
            String string = stringTokenizer.nextToken();
            Folder[] folderArray = folder.getSubFolders();
            int n = 0;
            while (n < folderArray.length) {
                Folder folder2 = folderArray[n];
                if (folder2.getName().equalsIgnoreCase(string)) {
                    return StarTeamFinder.find(folder2, stringTokenizer);
                }
                ++n;
            }
            return null;
        }
        return folder;
    }

    private StarTeamFinder() {
    }
}

