/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.ForeignPasswordException;
import com.starbase.starteam.ItemNotFoundException;
import com.starbase.starteam.LogonException;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerUnavailableException;
import com.starbase.starteam.names.ExceptionUtils;
import com.starbase.util.OLEDate;
import com.starbase.util.Platform;
import java.util.Enumeration;
import java.util.Hashtable;

public class ServerException
extends RuntimeException {
    private transient String m_className = null;
    private transient String m_errorSource = null;
    private transient int m_errorCode = -1;
    private transient String m_errorMessage = null;
    private transient String m_englishMessage = null;
    private transient boolean m_logged = false;
    private transient double m_loggedTime = 0.0;
    private transient int m_logEntry = -1;
    private transient Hashtable m_auxdata = new Hashtable();

    public static ServerException forError(Server server, String string, String string2, int n, String string3, boolean bl, double d, int n2, Hashtable hashtable) {
        ServerException serverException = LogonException.get(server, string, string2, n, string3, bl, d, n2, hashtable);
        if (serverException != null) {
            return serverException;
        }
        serverException = ServerUnavailableException.get(server, string, string2, n, string3, bl, d, n2, hashtable);
        if (serverException != null) {
            return serverException;
        }
        serverException = ItemNotFoundException.get(server, string, string2, n, string3, bl, d, n2, hashtable);
        if (serverException != null) {
            return serverException;
        }
        serverException = ForeignPasswordException.get(server, string, string2, n, string3, bl, d, n2, hashtable);
        if (serverException != null) {
            return serverException;
        }
        return new ServerException(string, string2, n, string3, bl, d, n2, hashtable);
    }

    protected static boolean isServerExceptionClass(String string) {
        return ServerException.isExceptionClass(string, "CStServerException");
    }

    protected static boolean isSecurityExceptionClass(String string) {
        return ServerException.isExceptionClass(string, "CStSecurityException");
    }

    protected static boolean isProjectManagerExceptionClass(String string) {
        return ServerException.isExceptionClass(string, "CStProjectManagerException");
    }

    protected static boolean isExceptionClass(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        String string3 = "CSt";
        if (string.startsWith(string3)) {
            string = string.substring(string3.length());
        }
        if (string2.startsWith(string3)) {
            string2 = string2.substring(string3.length());
        }
        return string.equals(string2);
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getErrorSource() {
        return this.m_errorSource;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public String getNonLocalizedMessage() {
        return this.m_englishMessage;
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    public boolean isLogged() {
        return this.m_logged;
    }

    public OLEDate getTimeLogged() {
        return new OLEDate(this.m_loggedTime);
    }

    public int getLogEntry() {
        return this.m_logEntry;
    }

    public String[] getAuxKeys() {
        int n = this.m_auxdata.size();
        String[] stringArray = new String[n];
        Enumeration enumeration = this.m_auxdata.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public Object getAuxData(String string) {
        return this.m_auxdata.get(string);
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getErrorMessage());
        String string = Platform.getEOL();
        if (this.isLogged()) {
            stringBuffer.append(string);
            stringBuffer.append("ClassName: " + this.getClassName() + string);
            stringBuffer.append("ErrorSource: " + this.getErrorSource() + string);
            stringBuffer.append("ErrorCode: " + this.getErrorCode() + string);
            stringBuffer.append("Logged: " + this.isLogged() + string);
            if (this.isLogged()) {
                stringBuffer.append("LogEntry: " + this.getLogEntry() + string);
                stringBuffer.append("TimeLogged: " + this.getTimeLogged().toString() + string);
            }
            if (this.m_auxdata.size() != 0) {
                stringBuffer.append("AuxData: " + string);
                Enumeration enumeration = this.m_auxdata.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    stringBuffer.append(string2 + ": ");
                    stringBuffer.append(this.getAuxData(string2).toString());
                    stringBuffer.append(string);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getMessage();
    }

    public void setErrorMessage(String string) {
        this.m_errorMessage = string;
    }

    ServerException(String string, String string2, int n, String string3, boolean bl, double d, int n2, Hashtable hashtable) {
        this.m_className = string;
        this.m_errorSource = string2;
        this.m_errorCode = n;
        this.m_errorMessage = string3;
        this.m_logged = bl;
        this.m_loggedTime = d;
        this.m_logEntry = n2;
        this.m_auxdata = hashtable;
        Object v = this.m_auxdata.get("__LOCALIZED_MESSAGE__");
        if (v != null) {
            this.m_errorMessage = v.toString();
            this.m_englishMessage = string3;
        } else {
            String string4 = ExceptionUtils.getServerExceptionMessage(string, n);
            this.m_errorMessage = string4 == null ? string3 : string4;
            this.m_englishMessage = string3;
        }
    }
}

