/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CacheManager;
import com.starbase.starteam.ReferenceFactoryCache;
import java.util.Vector;

abstract class SecureResourceCache
extends ReferenceFactoryCache {
    private long m_timestampIDs = 0L;

    protected long getIDsLastModified() {
        return this.m_timestampIDs;
    }

    protected long setIDsModified() {
        this.m_timestampIDs = this.getParent().getTimestamp();
        return this.m_timestampIDs;
    }

    protected synchronized void setAllDirty() {
        super.setAllDirty();
        this.setIDsModified();
    }

    protected synchronized boolean isRefreshAllRequired(Vector vector, long l) {
        return super.isRefreshAllRequired(vector, l) || l < this.getIDsLastModified();
    }

    protected synchronized long refreshAll(Object object, Vector vector, long l) {
        if (this.isRefreshAllRequired(vector, l)) {
            if (l == 0L || l < this.getIDsLastModified() || !this.isMPXAvailable()) {
                this.refreshAllImpl(object, vector, l);
            } else {
                this.refresh(object, vector);
            }
        }
        return this.getParent().getTimestamp();
    }

    protected abstract void refreshAllImpl(Object var1, Vector var2, long var3);

    protected SecureResourceCache(CacheManager cacheManager, int n) {
        super(cacheManager, n);
        this.m_bDiscardUnreferencedObjects = true;
    }

    protected SecureResourceCache(CacheManager cacheManager) {
        super(cacheManager);
        this.m_bDiscardUnreferencedObjects = true;
    }
}

