/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CmdPutLink;
import com.starbase.starteam.CmdPutLink2;
import com.starbase.starteam.CmdUpdateLinkPins;
import com.starbase.starteam.CmdUpdateLinkProperties;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Link;
import com.starbase.starteam.Project;
import com.starbase.starteam.PromotionModel;
import com.starbase.starteam.PutMethods;
import com.starbase.starteam.RevisionID;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerComponentInfo;
import com.starbase.starteam.Task;
import com.starbase.starteam.View;
import com.starbase.util.Assert;
import com.starbase.util.GUID;
import java.util.Enumeration;
import java.util.Vector;

class PutMethods {
    private static final PutMethod ITEM = new 1();
    private static final PutMethod FOLDER = new 2();
    private static final PutMethod LINK = new 3();
    private static final PutMethod PROMOTIONMODEL = new 4();
    private static final PutMethod PROJECT = new 5();
    private static final PutMethod TASK = new 6();
    private static final PutMethod VIEW = new 7();

    static void createNewLink(Link link, boolean bl, boolean bl2) {
        Server server = link.m_childItem.getServer();
        if (bl) {
            CmdPutLink2 cmdPutLink2 = new CmdPutLink2(link, bl2);
            cmdPutLink2.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(link.m_childItem.getView()).getID(), server.getComponentID(ServerComponentInfo.PROJECT));
        } else {
            String string = link.getComment();
            GUID gUID = new GUID();
            gUID.create();
            String string2 = gUID.byteString();
            link.setComment(string2);
            CmdPutLink cmdPutLink = new CmdPutLink(link);
            cmdPutLink.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(link.m_childItem.getView()).getID(), server.getComponentID(ServerComponentInfo.PROJECT));
            Link[] linkArray = link.getServer().findLinks(link.m_parentItem);
            int n = 0;
            while (n < linkArray.length) {
                if (linkArray[n].getComment().equals(string2)) {
                    link.setID(linkArray[n].getID());
                    link.setComment(string);
                    PutMethods.updateLink(link);
                    break;
                }
                ++n;
            }
        }
    }

    private static void updateLink(Link link) {
        if (link.m_bUpdateComment) {
            PutMethods.updateLinkComment(link);
        }
        if (link.m_bUpdateParentPin || link.m_bUpdateChildPin) {
            PutMethods.updateLinkPins(link);
        }
        Link[] linkArray = link.getServer().findLinks(link.m_parentItem);
        int n = 0;
        while (n < linkArray.length) {
            if (linkArray[n].getID() == link.getID()) {
                link.setParentEndpoint(linkArray[n].getParentEndpoint());
                link.setChildEndpoint(linkArray[n].getChildEndpoint());
                link.setComment(linkArray[n].getComment());
                link.m_createdUserID = linkArray[n].m_createdUserID;
                link.m_createdTime = linkArray[n].m_createdTime;
                link.m_bUpdateComment = false;
                break;
            }
            ++n;
        }
    }

    private static void updateLinkComment(Link link) {
        CmdUpdateLinkProperties cmdUpdateLinkProperties = new CmdUpdateLinkProperties(link, link.getParentEndpoint().getItemID(), link.getChildEndpoint().getItemID(), link.getComment());
        cmdUpdateLinkProperties.execute(link.getServer().useConnection(), link.getServer().getSession().getID(), link.getServer().getViewSession(link.getView()).getID(), link.getServer().getComponentID(ServerComponentInfo.PROJECT));
        link.m_bUpdateComment = false;
    }

    private static void updateLinkPins(Link link) {
        RevisionID revisionID = new RevisionID(link.getParentEndpoint().getObjectID(), link.getParentEndpoint().getRevisionNumber());
        RevisionID revisionID2 = new RevisionID(link.getChildEndpoint().getObjectID(), link.getChildEndpoint().getRevisionNumber());
        CmdUpdateLinkPins cmdUpdateLinkPins = new CmdUpdateLinkPins(link, revisionID, link.m_bUpdateParentPin, revisionID2, link.m_bUpdateChildPin);
        cmdUpdateLinkPins.execute(link.getServer().useConnection(), link.getServer().getSession().getID(), link.getServer().getViewSession(link.getView()).getID(), link.getServer().getComponentID(ServerComponentInfo.PROJECT));
        link.m_bUpdateParentPin = false;
        link.m_bUpdateChildPin = false;
    }

    protected static void put(Server server, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PutMethods.put(server, enumeration.nextElement());
        }
    }

    private static void put(Server server, Object object) {
        PutMethod putMethod = PutMethods.methodFor(object);
        putMethod.execute(server, object);
    }

    private static PutMethod methodFor(Object object) {
        if (object == null) {
            Assert.internalError("PutMethods.methodFor(), object=null");
        }
        PutMethod putMethod = null;
        if (object instanceof Folder) {
            putMethod = FOLDER;
        } else if (object instanceof Link) {
            putMethod = LINK;
        } else if (object instanceof Project) {
            putMethod = PROJECT;
        } else if (object instanceof Task) {
            putMethod = TASK;
        } else if (object instanceof View) {
            putMethod = VIEW;
        } else if (object instanceof Item) {
            putMethod = ITEM;
        } else if (object instanceof PromotionModel) {
            putMethod = PROMOTIONMODEL;
        }
        if (putMethod == null) {
            Assert.internalError("PutMethods.methodFor(), method=null");
        }
        return putMethod;
    }

    static /* synthetic */ void access$0(Link link) {
        PutMethods.updateLink(link);
    }

    PutMethods() {
    }

    private static interface PutMethod {
        public void execute(Server var1, Object var2);
    }
}

