/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.AclEntry;
import com.starbase.starteam.ISecurableContainer;
import com.starbase.starteam.ISecurableObject;
import com.starbase.starteam.PromotionModel;
import com.starbase.starteam.SecurityAccess;
import com.starbase.starteam.SimpleTypedResource;
import com.starbase.starteam.View;
import com.starbase.util.OLEDate;

public class PromotionState
extends SimpleTypedResource
implements ISecurableObject {
    private static final String EMPTY_STRING = "";
    private PromotionModel m_model = null;

    public PromotionModel getPromotionModel() {
        return this.m_model;
    }

    public int getObjectID() {
        return this.getInt(this.getPropertyNames().OBJECT_ID);
    }

    public int getID() {
        return this.getObjectID();
    }

    public String getName() {
        return this.getString(this.getPropertyNames().PROMOTIONSTATE_NAME);
    }

    public void setName(String string) {
        this.put(this.getPropertyNames().PROMOTIONSTATE_NAME, string);
    }

    public String getDescription() {
        return this.getString(this.getPropertyNames().PROMOTIONSTATE_DESCRIPTION);
    }

    public void setDescription(String string) {
        this.put(this.getPropertyNames().PROMOTIONSTATE_DESCRIPTION, string);
    }

    public int getLabelID() {
        return this.getInt(this.getPropertyNames().PROMOTIONSTATE_LABEL_ID);
    }

    public void setLabelID(int n) {
        this.put(this.getPropertyNames().PROMOTIONSTATE_LABEL_ID, new Integer(n));
    }

    public OLEDate getCreatedOn() {
        return this.getOLEDate(this.getPropertyNames().CREATED_TIME);
    }

    public int getCreatedBy() {
        return this.getInt(this.getPropertyNames().CREATED_USER_ID);
    }

    public OLEDate getDeletedOn() {
        return this.getOLEDate(this.getPropertyNames().DELETED_TIME);
    }

    public int getDeletedBy() {
        return this.getInt(this.getPropertyNames().DELETED_USER_ID);
    }

    public AclEntry[] getACL() {
        if (this.m_model != null) {
            View view = this.m_model.getView();
            return SecurityAccess.getObjectACL(view.getServer(), view, this.getObjectID(), this.getType().getClassID());
        }
        return null;
    }

    public void setACL(AclEntry[] aclEntryArray) {
        if (this.m_model != null) {
            View view = this.m_model.getView();
            SecurityAccess.setObjectACL(view.getServer(), view, this.getObjectID(), this.getType().getClassID(), aclEntryArray);
        }
    }

    public int getOwner() {
        return SecurityAccess.getObjectOwner(this.getType().getServer(), this.m_model.getView(), this.getType().getClassID(), this.getObjectID());
    }

    public void acquireOwnership() {
        SecurityAccess.acquireObjectOwnership(this.getType().getServer(), this.m_model.getView(), this.getType().getClassID(), this.getObjectID());
    }

    public ISecurableContainer getParentContainer() {
        return this.m_model.getView();
    }

    public boolean hasPermission(int n) {
        return SecurityAccess.objectAccessTest(this.getType().getServer(), this.m_model.getView(), this.getType().getClassID(), this.getObjectID(), n);
    }

    public PromotionState(PromotionModel promotionModel) {
        super(promotionModel.getView().getServer().typeForName(promotionModel.getView().getServer().getTypeNames().PROMOTIONSTATE));
        this.m_model = promotionModel;
        this.put(promotionModel.getView().getServer().getPropertyNames().OBJECT_ID, new Integer(-1));
        this.setName(EMPTY_STRING);
        this.setDescription(EMPTY_STRING);
        this.setLabelID(-1);
    }
}

