/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.AclEntry;
import com.starbase.starteam.Folder;
import com.starbase.starteam.ISecurableContainer;
import com.starbase.starteam.ISecurableObject;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.ProjectEvent_Marshaler;
import com.starbase.starteam.ProjectListener;
import com.starbase.starteam.Project_Cache;
import com.starbase.starteam.Project_Cmd_Create;
import com.starbase.starteam.Project_Cmd_Delete;
import com.starbase.starteam.Project_Cmd_GetViews;
import com.starbase.starteam.Project_Cmd_SetProperties;
import com.starbase.starteam.Property;
import com.starbase.starteam.SecurityAccess;
import com.starbase.starteam.Server;
import com.starbase.starteam.SimpleTypedResource;
import com.starbase.starteam.Type;
import com.starbase.starteam.TypedResource_Data;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import com.starbase.starteam.ViewEvent_Marshaler;
import com.starbase.starteam.ViewListener;
import com.starbase.starteam.View_CacheRefCollection;
import com.starbase.util.Assert;
import com.starbase.util.OLEDate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Project
extends SimpleTypedResource
implements ISecurableObject,
ISecurableContainer {
    private static final String EMPTY_STRING = "";
    static final int SCOPE_SELF = 1;
    static final int SCOPE_ALLPROPERTIES = 2;
    static final int SCOPE_DEFAULT = 3;
    private ViewEvent_Marshaler m_viewEventMarshaler = null;
    private Server m_server;
    private boolean m_bPopulated = false;
    private boolean m_bDiscarded = false;
    private View m_accessibleView = null;
    private int m_viewSessionID = -1;
    private String m_description = "";
    private boolean m_bUseMail = false;
    private boolean m_isNew = false;
    private boolean m_isDeleted = false;
    private int m_nCompaction = 0;
    private int m_nEncryption = 0;
    private String m_rootDirectory = "";
    private int m_nProjectType = 0;
    private String m_configSource1 = "";
    private String m_configSource2 = "";
    private Folder m_folderTree;
    private Hashtable m_unsavedNewProjectProperties = new Hashtable();
    private boolean m_bRetrievingProperties = false;
    private View_CacheRefCollection m_views = null;

    public void populate() {
        if (!this.m_bPopulated) {
            this.retrieveProperties();
        }
    }

    public boolean isRefreshRequired() {
        if (this.isNew()) {
            return false;
        }
        if (!this.m_bPopulated) {
            return true;
        }
        Vector<Project> vector = new Vector<Project>();
        vector.addElement(this);
        return this.getCache().isRefreshRequired(vector);
    }

    public void refresh() {
        if (this.isRefreshRequired()) {
            this.refreshCache();
        }
    }

    public Project copy() {
        return this.copy(3);
    }

    Project copy(int n) {
        if ((n & 2) != 0) {
            this.populate();
        }
        Project project = new Project(this.m_server, null);
        super.copyInto(project);
        project.m_bPopulated = this.m_bPopulated;
        project.m_bDiscarded = this.m_bDiscarded;
        project.m_accessibleView = this.m_accessibleView;
        project.m_viewSessionID = this.m_viewSessionID;
        project.m_description = this.m_description;
        project.m_bUseMail = this.m_bUseMail;
        project.m_isNew = this.m_isNew;
        project.m_nCompaction = this.m_nCompaction;
        project.m_nEncryption = this.m_nEncryption;
        project.m_rootDirectory = this.m_rootDirectory;
        project.m_nProjectType = this.m_nProjectType;
        project.m_configSource1 = this.m_configSource1;
        project.m_configSource2 = this.m_configSource2;
        project.m_folderTree = this.m_folderTree;
        project.m_views = this.m_views;
        if (this.m_unsavedNewProjectProperties != null) {
            project.m_unsavedNewProjectProperties = new Hashtable();
            Enumeration enumeration = this.m_unsavedNewProjectProperties.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = this.m_unsavedNewProjectProperties.get(k);
                project.m_unsavedNewProjectProperties.put(k, v);
            }
        }
        return project;
    }

    public boolean isEqualTo(Project project) {
        if (project == null) {
            return false;
        }
        this.populate();
        project.populate();
        return this.getData().isEqualTo(project.getData());
    }

    public Object get(String string) throws NoSuchPropertyException {
        if (!this.hasValue(string) || this.m_bDiscarded) {
            this.retrieveProperties();
        }
        return super.get(string);
    }

    public Object put(String string, Object object) throws NoSuchPropertyException, ClassCastException {
        if (this.m_isNew && !this.isSetOnProjectCreate(string)) {
            this.m_unsavedNewProjectProperties.put(string, object);
        }
        return super.put(string, object);
    }

    public Object putByPropertyID(int n, Object object) throws NoSuchPropertyException, ClassCastException {
        Property property = this.getType().propertyForPID(n);
        if (property == null) {
            throw new NoSuchPropertyException(this.getType().getName(), n);
        }
        return this.put(property.getName(), object);
    }

    public boolean hasPermission(int n) {
        return SecurityAccess.objectAccessTest(this.getServer(), this.getAccessibleView(), this.getType().getClassID(), this.getID(), n);
    }

    public boolean hasPermission(int n, String string) {
        return SecurityAccess.containerAccessTest(this.getServer(), this.getAccessibleView(), 2, -1, string, n);
    }

    public AclEntry[] getContainerLevelACL(String string) {
        return SecurityAccess.getContainerLevelACL(this.getServer(), this.getAccessibleView(), 2, -1, string);
    }

    public void setContainerLevelACL(AclEntry[] aclEntryArray, String string) {
        SecurityAccess.setContainerLevelACL(this.getServer(), this.getAccessibleView(), 2, -1, string, aclEntryArray);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof Project) {
            Project project = (Project)object;
            bl = this.getServer().equals(project.getServer()) && this.getName() == project.getName();
        }
        return bl;
    }

    public int hashCode() {
        return this.getServer().hashCode() + this.getName().hashCode();
    }

    public void discard() {
        int n = this.getID();
        String string = this.getName();
        this.m_bPopulated = false;
        this.m_bDiscarded = true;
        this.m_newData = null;
        this.getCache().discard(n);
        this.setCachedObject(null);
        this.setID(n);
        this.setNameNoPopulate(string);
        this.m_unsavedNewProjectProperties.clear();
    }

    public void update() {
        if (this.isNew()) {
            this.createProject();
            if (!this.m_unsavedNewProjectProperties.isEmpty()) {
                Enumeration enumeration = this.m_unsavedNewProjectProperties.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.put(string, this.m_unsavedNewProjectProperties.get(string));
                }
                this.updateProject();
                this.m_unsavedNewProjectProperties.clear();
            }
        } else {
            this.updateProject();
        }
        this.setCachedObject(this.getData());
        this.m_newData = null;
        this.m_folderTree = null;
        this.m_isNew = false;
    }

    public void remove() {
        Project_Cmd_Delete project_Cmd_Delete = new Project_Cmd_Delete();
        Server server = this.getServer();
        project_Cmd_Delete.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(this.getAccessibleView()).getID(), 0);
        this.markDeleted();
        this.m_folderTree = null;
        this.getCache().setIDsModified();
    }

    void markDeleted() {
        this.m_isDeleted = true;
    }

    public boolean isDeleted() {
        return this.m_isDeleted;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        String string = System.getProperty("line.separator");
        stringBuffer.append("Project name: ");
        stringBuffer.append(this.getName());
        stringBuffer.append(", ID: ");
        stringBuffer.append(this.getID());
        stringBuffer.append(", keyword expansion=");
        stringBuffer.append(this.isExpandKeywords());
        stringBuffer.append(string + "description: ");
        stringBuffer.append(this.getDescription());
        return stringBuffer.toString();
    }

    public boolean isNew() {
        return this.m_isNew;
    }

    public View getDefaultView() {
        View[] viewArray = this.getViews();
        if (viewArray.length <= 0) {
            Assert.internalError("Project.getDefaultView(), views.length=" + viewArray.length);
        }
        return viewArray[0];
    }

    public int getID() {
        return (Integer)this.get(this.getPropertyNames().OBJECT_ID);
    }

    public String getDescription() {
        return this.getString(this.getPropertyNames().PROJECT_DESCRIPTION);
    }

    public void setDescription(String string) {
        this.put(this.getPropertyNames().PROJECT_DESCRIPTION, string);
    }

    public boolean isExpandKeywords() {
        return this.getInt(this.getPropertyNames().PROJECT_USE_KEYWORDS) == 1;
    }

    public void setExpandKeywords(boolean bl) {
        this.put(this.getPropertyNames().PROJECT_USE_KEYWORDS, new Integer(bl ? 1 : 0));
    }

    public boolean isRequireLockForCheckin() {
        return this.getInt(this.getPropertyNames().PROJECT_REQUIRE_LOCK_FOR_CHECKIN) == 1;
    }

    public void setRequireLockForCheckin(boolean bl) {
        this.put(this.getPropertyNames().PROJECT_REQUIRE_LOCK_FOR_CHECKIN, new Integer(bl ? 1 : 0));
    }

    public boolean isForceCheckinReason() {
        return this.getInt(this.getPropertyNames().PROJECT_FORCE_CHECKIN_REASON) == 1;
    }

    public void setForceCheckinReason(boolean bl) {
        this.put(this.getPropertyNames().PROJECT_FORCE_CHECKIN_REASON, new Integer(bl ? 1 : 0));
    }

    public String getConfigSource1() {
        return this.getString(this.getPropertyNames().PROJECT_CONFIGSOURCE1);
    }

    public String getConfigSource2() {
        return this.getString(this.getPropertyNames().PROJECT_CONFIGSOURCE2);
    }

    public OLEDate getCreatedTime() {
        return this.getOLEDate(this.getPropertyNames().CREATED_TIME);
    }

    public int getCreatedBy() {
        return this.getInt(this.getPropertyNames().CREATED_USER_ID);
    }

    public Server getServer() {
        return this.m_server;
    }

    public String getKeywordExpansionFileExtensions() {
        return this.getString(this.getPropertyNames().PROJECT_KEYWORD_EXTENSIONS);
    }

    public void setKeywordExpansionFileExtensions(String string) {
        this.put(this.getPropertyNames().PROJECT_KEYWORD_EXTENSIONS, string);
    }

    public int getProjectType() {
        return this.getInt(this.getPropertyNames().PROJECT_TYPE);
    }

    public boolean isMailUsed() {
        return this.getInt(this.getPropertyNames().PROJECT_MAIL) == 1;
    }

    public String getName() {
        return this.getString(this.getPropertyNames().PROJECT_NAME);
    }

    public void setName(String string) {
        this.put(this.getPropertyNames().PROJECT_NAME, string);
    }

    public View[] getViews() {
        View_CacheRefCollection view_CacheRefCollection = this.getViewCollection();
        view_CacheRefCollection.refreshViews();
        Vector vector = view_CacheRefCollection.getRefs();
        View[] viewArray = new View[vector.size()];
        int n = 0;
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            View view = (View)object.nextElement();
            viewArray[n++] = view.copy(1);
        }
        n = 0;
        while (n < viewArray.length) {
            object = viewArray[n];
            if (((View)object).getIdForAccessCheck() != -1) {
                this.m_accessibleView = object;
                break;
            }
            ++n;
        }
        return viewArray;
    }

    public View[] getAccessibleViews() {
        View_CacheRefCollection view_CacheRefCollection = this.getViewCollection();
        view_CacheRefCollection.refreshViews();
        Vector vector = view_CacheRefCollection.getRefs();
        Vector<View> vector2 = new Vector<View>();
        View[] viewArray = vector.elements();
        while (viewArray.hasMoreElements()) {
            View view = (View)viewArray.nextElement();
            if (view.getIdForAccessCheck() == -1) continue;
            vector2.addElement(view);
        }
        viewArray = new View[vector2.size()];
        int n = 0;
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            View view = (View)enumeration.nextElement();
            viewArray[n++] = view.copy(1);
        }
        return viewArray;
    }

    public AclEntry[] getACL() {
        return SecurityAccess.getContainerACL(this.getServer(), this.getAccessibleView(), 2, -1);
    }

    public void setACL(AclEntry[] aclEntryArray) {
        SecurityAccess.setContainerACL(this.getServer(), this.getAccessibleView(), 2, -1, aclEntryArray);
    }

    public void addProjectListener(ProjectListener projectListener) {
        this.getProjectEventMarshaler().addListener(projectListener, this);
    }

    public void removeProjectListener(ProjectListener projectListener) {
        this.getProjectEventMarshaler().removeListener(projectListener, this);
    }

    ProjectEvent_Marshaler getProjectEventMarshaler() {
        return this.getServer().getProjectEventMarshaler();
    }

    public void addViewListener(ViewListener viewListener) {
        this.getViewEventMarshaler().addListener(viewListener, null);
    }

    public void removeViewListener(ViewListener viewListener) {
        this.getViewEventMarshaler().removeListener(viewListener, null);
    }

    ViewEvent_Marshaler getViewEventMarshaler() {
        if (this.m_viewEventMarshaler == null) {
            Project project = this;
            synchronized (project) {
                if (this.m_viewEventMarshaler == null) {
                    this.m_viewEventMarshaler = new ViewEvent_Marshaler(this);
                }
            }
        }
        return this.m_viewEventMarshaler;
    }

    View getAccessibleView() {
        if (this.m_accessibleView == null) {
            this.findAccessibleView();
        }
        return this.m_accessibleView;
    }

    int getViewSessionID() {
        if (this.m_viewSessionID == -1) {
            this.findAccessibleView();
        }
        return this.m_viewSessionID;
    }

    void setViewSessionID(int n) {
        this.m_viewSessionID = n;
    }

    private View_CacheRefCollection getViewCollection() {
        if (this.m_views == null) {
            this.m_views = new View_CacheRefCollection(this);
        }
        return this.m_views;
    }

    private void findAccessibleView() {
        View view = null;
        View_CacheRefCollection view_CacheRefCollection = new View_CacheRefCollection(this);
        Project_Cmd_GetViews.execute(this.m_server, this, view_CacheRefCollection, false);
        Enumeration enumeration = view_CacheRefCollection.getRefs().elements();
        while (enumeration.hasMoreElements()) {
            view = (View)enumeration.nextElement();
            if (view.getIdForAccessCheck() == -1) continue;
            this.m_accessibleView = view;
            this.setViewSessionID(this.m_server.getViewSession(view).getID());
            break;
        }
    }

    private boolean isSetOnProjectCreate(String string) {
        return string.equalsIgnoreCase(this.getPropertyNames().PROJECT_NAME) || string.equalsIgnoreCase(this.getPropertyNames().PROJECT_DESCRIPTION) || string.equalsIgnoreCase(this.getPropertyNames().PROJECT_COMPACTION) || string.equalsIgnoreCase(this.getPropertyNames().PROJECT_ENCRYPTION) || string.equalsIgnoreCase(this.getPropertyNames().PROJECT_MAIL) || string.equalsIgnoreCase(this.getPropertyNames().PROJECT_TYPE) || string.equalsIgnoreCase(this.getPropertyNames().PROJECT_CONFIGSOURCE1) || string.equalsIgnoreCase(this.getPropertyNames().PROJECT_CONFIGSOURCE2);
    }

    private void updateProject() {
        this.getCacheData().setDirty(true);
        this.getNewData().setDirty(true);
        Project_Cmd_SetProperties.execute(this.m_server, this, this.getAccessibleView());
        this.completeUpdate();
    }

    private void createProject() {
        Project_Cmd_Create project_Cmd_Create = new Project_Cmd_Create(this.m_server.getSession().getID(), this.getName(), -1, ViewConfiguration.createTip(), this.getDescription(), this.m_nCompaction, this.m_nEncryption, this.isMailUsed(), this.m_rootDirectory, this.m_nProjectType, this.m_configSource1, this.m_configSource2, this.m_folderTree);
        project_Cmd_Create.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), -1, 0);
        this.completeUpdate();
        this.setID(project_Cmd_Create.getProjectID());
        this.getServer().cacheNewProject(this);
        this.m_isNew = false;
        this.getViews();
        this.fixupFoldersAndView();
    }

    private void completeUpdate() {
        this.setCachedObject(this.getNewData());
        this.m_newData = null;
    }

    private void fixupFoldersAndView() {
        View view = this.getDefaultView();
        Folder folder = null;
        folder = view.getRootFolder();
        this.copyVMIDs(folder, this.m_folderTree);
        view.setRootFolder(this.m_folderTree);
        this.setViewInFolders(view, this.m_folderTree);
        view.getRootFolder().setDefaultPathFragment(this.m_rootDirectory);
    }

    private void setViewInFolders(View view, Folder folder) {
        folder.setView(view);
        Folder[] folderArray = folder.getSubFolders();
        int n = 0;
        while (n < folderArray.length) {
            this.setViewInFolders(view, folderArray[n]);
            ++n;
        }
    }

    private void copyVMIDs(Folder folder, Folder folder2) {
        folder2.setItemID(folder.getItemID());
        Folder[] folderArray = folder.getSubFolders();
        Folder[] folderArray2 = folder2.getSubFolders();
        if (folderArray.length == 0) {
            if (folderArray2.length != 0) {
                Assert.internalError("Project.copyVMIDs(), toKids.length=" + folderArray2.length);
            }
            return;
        }
        Hashtable<String, Folder> hashtable = new Hashtable<String, Folder>(100, 0.1f);
        Folder folder3 = null;
        Folder folder4 = null;
        int n = 0;
        while (n < folderArray2.length) {
            folder3 = folderArray2[n];
            hashtable.put(folder3.getName(), folder3);
            ++n;
        }
        n = 0;
        while (n < folderArray.length) {
            folder4 = folderArray[n];
            folder3 = (Folder)hashtable.get(folder4.getName());
            if (folder3 == null) {
                Assert.internalError("Project.copyVMIDs(), toChild=null");
            }
            this.copyVMIDs(folder4, folder3);
            ++n;
        }
    }

    private void refreshCache() {
        Vector<Project> vector = new Vector<Project>();
        vector.addElement(this);
        this.getCache().refresh(this.m_server, vector);
        this.m_bPopulated = true;
    }

    private synchronized void retrieveProperties() {
        if (!this.m_bRetrievingProperties) {
            block3: {
                try {
                    this.m_bRetrievingProperties = true;
                    if (this.getID() == -1 || this.m_isNew) break block3;
                    this.refreshCache();
                    this.m_bDiscarded = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.m_bRetrievingProperties = false;
                    throw throwable;
                }
            }
            Object var2_1 = null;
            this.m_bRetrievingProperties = false;
        }
    }

    private void setID(int n) {
        this.getCacheData().putByName(this.getPropertyNames().OBJECT_ID, new Integer(n));
        if (n != -1) {
            this.m_isNew = false;
        }
    }

    private void setNameNoPopulate(String string) {
        this.getCacheData().putByName(this.getPropertyNames().PROJECT_NAME, string);
    }

    private void setMailUsed(boolean bl) {
        this.put(this.getPropertyNames().PROJECT_MAIL, new Integer(bl ? 1 : 0));
    }

    private Project_Cache getCache() {
        return this.m_server.getServerCacheManager().getProjectCache(this.m_server);
    }

    public int getOwner() {
        return SecurityAccess.getObjectOwner(this.m_server, this.getAccessibleView(), this.getType().getClassID(), this.getID());
    }

    public void acquireOwnership() {
        SecurityAccess.acquireObjectOwnership(this.m_server, this.getAccessibleView(), this.getType().getClassID(), this.getID());
    }

    public ISecurableContainer getParentContainer() {
        return null;
    }

    private static Type getType(Server server) {
        return server.typeForName(server.getTypeNames().PROJECT);
    }

    private static TypedResource_Data newData(Server server) {
        return new TypedResource_Data(Project.getType(server).getData());
    }

    public Project(Server server, String string, String string2, int n, int n2, boolean bl, String string3, int n3, String string4, String string5, Folder folder) {
        super(Project.getType(server), Project.newData(server));
        this.m_server = server;
        this.setName(string);
        this.setDescription(string2);
        this.setExpandKeywords(false);
        this.setKeywordExpansionFileExtensions(EMPTY_STRING);
        this.setMailUsed(false);
        this.m_description = string2;
        this.m_nCompaction = n;
        this.m_nEncryption = n2;
        this.m_bUseMail = bl;
        this.m_rootDirectory = string3;
        this.m_nProjectType = n3;
        this.m_configSource1 = string4;
        this.m_configSource2 = string5;
        this.m_folderTree = folder;
        this.m_isNew = true;
    }

    public Project(Server server, String string, String string2) {
        super(Project.getType(server), Project.newData(server));
        this.m_server = server;
        this.setName(string);
        this.setDescription(EMPTY_STRING);
        this.setExpandKeywords(false);
        this.setKeywordExpansionFileExtensions(EMPTY_STRING);
        this.setMailUsed(false);
        this.m_rootDirectory = string2;
        this.m_folderTree = new Folder(server);
        this.m_folderTree.setName(string);
        this.m_isNew = true;
    }

    Project(Server server, TypedResource_Data typedResource_Data) {
        super(Project.getType(server), typedResource_Data);
        this.m_server = server;
    }

    Project(Server server, String string, int n) {
        super(Project.getType(server), Project.newData(server));
        this.setID(n);
        this.setNameNoPopulate(string);
        this.m_server = server;
    }
}

