/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CmdModifyUser;
import com.starbase.starteam.Server;
import com.starbase.starteam.UserAccountMarshaller;
import com.starbase.starteam.UserAccount_Data;
import com.starbase.starteam.vts.comm.Command;
import java.io.IOException;

public class MyUserAccount {
    private Server m_server;
    private int m_id;
    private String m_fullName;
    private String m_email;
    private String m_address;
    private String m_fax;
    private String m_pager;
    private String m_phone;
    private String m_voiceMail;
    private String m_logonName;
    private byte[] m_password;
    private int m_minPasswordLength = 0;

    public int getID() {
        return this.m_id;
    }

    public String getName() {
        return this.m_fullName;
    }

    public void setName(String string) {
        this.m_fullName = string;
    }

    public String getEmailAddress() {
        return this.m_email;
    }

    public void setEmailAddress(String string) {
        this.m_email = string;
    }

    public String getPostalAddress() {
        return this.m_address;
    }

    public void setPostalAddress(String string) {
        this.m_address = string;
    }

    public String getFaxNumber() {
        return this.m_fax;
    }

    public void setFaxNumber(String string) {
        this.m_fax = string;
    }

    public String getPagerNumber() {
        return this.m_pager;
    }

    public void setPagerNumber(String string) {
        this.m_pager = string;
    }

    public String getPhoneNumber() {
        return this.m_phone;
    }

    public void setPhoneNumber(String string) {
        this.m_phone = string;
    }

    public String getVoiceMailNumber() {
        return this.m_voiceMail;
    }

    public void setVoiceMailNumber(String string) {
        this.m_voiceMail = string;
    }

    public String getLogOnName() {
        return this.m_logonName;
    }

    public void setPassword(String string) {
        this.m_password = UserAccount_Data.manglePassword(string);
    }

    public int getMinimumPasswordLength() {
        return this.m_minPasswordLength;
    }

    public boolean getPasswordChangeRequired() {
        return this.m_server.getLoginInfo().getNeedsPasswordChange();
    }

    public int getPasswordDaysRemaining() {
        return this.m_server.getLoginInfo().getPasswordValidDays();
    }

    public void update() {
        CmdModifyUser cmdModifyUser = new CmdModifyUser(new UserAccountMarshaller(this.m_server), this);
        cmdModifyUser.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
    }

    void readSelfUserInfo(Command command) throws IOException {
        this.m_id = command.readInt();
        this.m_fullName = command.readString();
        this.m_email = command.readString();
        this.m_address = command.readString();
        this.m_fax = command.readString();
        this.m_pager = command.readString();
        this.m_phone = command.readString();
        this.m_voiceMail = command.readString();
        this.m_logonName = command.readString();
        if (this.m_server.getRevisionLevel() >= 67) {
            this.m_password = command.readVariantBytes();
        } else {
            String string = command.readString();
            this.m_password = UserAccount_Data.mangledPasswordAsBytes(string);
        }
        this.m_minPasswordLength = command.readInt();
    }

    void writeSelfUserInfo(Command command) throws IOException {
        command.writeInt(this.m_id);
        command.writeString(this.m_fullName);
        command.writeString(this.m_email);
        command.writeString(this.m_address);
        command.writeString(this.m_fax);
        command.writeString(this.m_pager);
        command.writeString(this.m_phone);
        command.writeString(this.m_voiceMail);
        command.writeString(this.m_logonName);
        if (this.m_server.getRevisionLevel() >= 67) {
            command.writeVariantBytes(this.m_password);
        } else {
            command.writeString(UserAccount_Data.mangledPasswordAsString(this.m_password));
        }
    }

    public MyUserAccount copy() {
        MyUserAccount myUserAccount = new MyUserAccount(this.m_server);
        myUserAccount.m_id = this.m_id;
        myUserAccount.m_fullName = this.m_fullName;
        myUserAccount.m_email = this.m_email;
        myUserAccount.m_address = this.m_address;
        myUserAccount.m_fax = this.m_fax;
        myUserAccount.m_pager = this.m_pager;
        myUserAccount.m_phone = this.m_phone;
        myUserAccount.m_voiceMail = this.m_voiceMail;
        myUserAccount.m_logonName = this.m_logonName;
        myUserAccount.m_password = this.m_password;
        myUserAccount.m_minPasswordLength = this.m_minPasswordLength;
        return myUserAccount;
    }

    public boolean isEqualTo(MyUserAccount myUserAccount) {
        if (myUserAccount == null) {
            return false;
        }
        if (!(myUserAccount.m_id == this.m_id && myUserAccount.m_fullName.equals(this.m_fullName) && myUserAccount.m_email.equals(this.m_email) && myUserAccount.m_address.equals(this.m_address) && myUserAccount.m_fax.equals(this.m_fax) && myUserAccount.m_pager.equals(this.m_pager) && myUserAccount.m_phone.equals(this.m_phone) && myUserAccount.m_voiceMail.equals(this.m_voiceMail) && myUserAccount.m_logonName.equals(this.m_logonName) && myUserAccount.m_minPasswordLength == this.m_minPasswordLength)) {
            return false;
        }
        if (myUserAccount.m_password == null != (this.m_password == null)) {
            return false;
        }
        if (this.m_password != null) {
            if (myUserAccount.m_password.length != this.m_password.length) {
                return false;
            }
            int n = 0;
            while (n < this.m_password.length) {
                if (myUserAccount.m_password[n] != this.m_password[n]) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ID: 0x" + Integer.toHexString(this.m_id) + string);
        stringBuffer.append("LogonName: " + this.m_logonName + string);
        stringBuffer.append("FullName: " + this.m_fullName + string);
        stringBuffer.append("e-mail: " + this.m_email + string);
        stringBuffer.append("Address: " + this.m_address + string);
        stringBuffer.append("Fax: " + this.m_fax + string);
        stringBuffer.append("Pager: " + this.m_pager + string);
        stringBuffer.append("Phone: " + this.m_phone + string);
        stringBuffer.append("VoiceMail: " + this.m_voiceMail + string);
        stringBuffer.append("MinPasswordLen: " + this.m_minPasswordLength + string);
        return stringBuffer.toString();
    }

    MyUserAccount(Server server) {
        this.m_server = server;
    }
}

