/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.borland.starteam.xml.XMLElement;
import com.starbase.starteam.MPXEvent;
import com.starbase.starteam.MPXException;
import com.starbase.starteam.ViewConfiguration;
import com.starbase.util.OLEDate;

class MPXViewConfigEvent
extends MPXEvent {
    private int m_nViewID = MPXEvent.getRequiredInteger(this.m_eventData, "ViewID");
    private ViewConfiguration m_config = null;

    public int getViewID() {
        return this.m_nViewID;
    }

    public ViewConfiguration getViewConfiguration() {
        return this.m_config;
    }

    private ViewConfiguration parseViewConfig(XMLElement xMLElement) throws MPXException {
        ViewConfiguration viewConfiguration = null;
        if (xMLElement != null) {
            String string = MPXEvent.getRequiredStringAttribute(xMLElement, "ConfigType");
            if (string.equals("Current")) {
                viewConfiguration = ViewConfiguration.createTip();
            } else if (string.equals("Time")) {
                OLEDate oLEDate = MPXEvent.getOLEDateValue(xMLElement);
                viewConfiguration = ViewConfiguration.createFromTime(oLEDate);
            } else if (string.equals("Label")) {
                int n = MPXEvent.getIntValue(xMLElement);
                viewConfiguration = ViewConfiguration.createFromLabel(n);
            } else if (string.equals("Promotion")) {
                int n = MPXEvent.getIntValue(xMLElement);
                viewConfiguration = ViewConfiguration.createFromPromotionState(n);
            }
        } else {
            viewConfiguration = ViewConfiguration.createTip();
        }
        return viewConfiguration;
    }

    public String toString() {
        return super.toString() + " (" + this.getViewID() + ", " + this.getViewConfiguration().toString() + ")";
    }

    MPXViewConfigEvent(byte[] byArray) throws MPXException {
        super(byArray);
        XMLElement xMLElement = MPXEvent.getRequiredElement(this.m_eventData, "ViewConfig");
        this.m_config = this.parseViewConfig(xMLElement);
        this.dump();
    }
}

