/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.MPXEvent;
import com.starbase.starteam.MPXEventDispatcher;
import com.starbase.starteam.MPXObjectEvent;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Server_CacheManager;
import com.starbase.starteam.TypeNames;
import java.util.Enumeration;
import java.util.Vector;

class MPXNewProjectEventFilter
implements MPXEventDispatcher {
    private Server_CacheManager m_mgr = null;
    private final String TYPENAME_PROJECT;
    private final String TYPENAME_VIEW;
    private final String PROPNAME_PROJECTID;
    private final String PROPNAME_VIEWID;
    private MPXEventDispatcher m_prev = null;
    private Vector m_sequences = new Vector();

    public void dispatchMPXEvent(MPXEvent mPXEvent) {
        if (mPXEvent instanceof MPXObjectEvent) {
            MPXObjectEvent mPXObjectEvent = (MPXObjectEvent)mPXEvent;
            String string = this.m_mgr.toTypeName(mPXObjectEvent.getClassID());
            if (this.TYPENAME_PROJECT.equals(string)) {
                this.handleMPXProjectEvent(mPXObjectEvent);
            } else if (this.TYPENAME_VIEW.equals(string)) {
                this.handleMPXViewEvent(mPXObjectEvent);
            } else {
                this.m_prev.dispatchMPXEvent(mPXEvent);
            }
        } else {
            this.m_prev.dispatchMPXEvent(mPXEvent);
        }
    }

    private void handleMPXProjectEvent(MPXObjectEvent mPXObjectEvent) {
        String string = mPXObjectEvent.getEventVerb();
        if (string.equals("New")) {
            EventSequence eventSequence = this.newEventSequence();
            eventSequence.m_createProjectEvent = mPXObjectEvent;
            this.checkSequence(eventSequence);
        } else if (string.equals("Modify")) {
            int n = mPXObjectEvent.getObjectID();
            EventSequence eventSequence = this.findEventSequence(n);
            if (eventSequence != null) {
                eventSequence.m_createProjectEvent.setProperties(mPXObjectEvent);
                this.checkSequence(eventSequence);
            } else {
                this.m_prev.dispatchMPXEvent(mPXObjectEvent);
            }
        } else {
            this.m_prev.dispatchMPXEvent(mPXObjectEvent);
        }
    }

    private void handleMPXViewEvent(MPXObjectEvent mPXObjectEvent) {
        String string = mPXObjectEvent.getEventVerb();
        if (string.equals("New")) {
            int n = (Integer)mPXObjectEvent.getValue(this.PROPNAME_PROJECTID);
            EventSequence eventSequence = this.findEventSequence(n);
            if (eventSequence != null) {
                eventSequence.m_createViewEvent = mPXObjectEvent;
                this.checkSequence(eventSequence);
            } else {
                this.m_prev.dispatchMPXEvent(mPXObjectEvent);
            }
        } else {
            this.m_prev.dispatchMPXEvent(mPXObjectEvent);
        }
    }

    private EventSequence newEventSequence() {
        MPXNewProjectEventFilter mPXNewProjectEventFilter = this;
        if (mPXNewProjectEventFilter == null) {
            throw null;
        }
        EventSequence eventSequence = mPXNewProjectEventFilter.new EventSequence();
        Vector vector = this.m_sequences;
        synchronized (vector) {
            this.m_sequences.addElement(eventSequence);
        }
        return eventSequence;
    }

    private EventSequence findEventSequence(int n) {
        Vector vector = this.m_sequences;
        synchronized (vector) {
            Enumeration enumeration = this.m_sequences.elements();
            while (enumeration.hasMoreElements()) {
                EventSequence eventSequence = (EventSequence)enumeration.nextElement();
                if (eventSequence.m_createProjectEvent == null || eventSequence.m_createProjectEvent.getObjectID() != n) continue;
                EventSequence eventSequence2 = eventSequence;
                Object var3_7 = null;
                return eventSequence2;
            }
            EventSequence eventSequence = null;
            Object var3_8 = null;
            return eventSequence;
        }
    }

    private void checkSequence(EventSequence eventSequence) {
        int n;
        if (eventSequence.m_createProjectEvent != null && eventSequence.m_createViewEvent != null && (n = ((Integer)eventSequence.m_createProjectEvent.getValue(this.PROPNAME_VIEWID)).intValue()) != -1) {
            this.m_prev.dispatchMPXEvent(eventSequence.m_createProjectEvent);
            this.m_prev.dispatchMPXEvent(eventSequence.m_createViewEvent);
            this.removeEventSequence(eventSequence);
        }
    }

    private void removeEventSequence(EventSequence eventSequence) {
        Vector vector = this.m_sequences;
        synchronized (vector) {
            this.m_sequences.removeElement(eventSequence);
        }
    }

    public MPXNewProjectEventFilter(Server_CacheManager server_CacheManager, MPXEventDispatcher mPXEventDispatcher) {
        this.m_prev = mPXEventDispatcher;
        this.m_mgr = server_CacheManager;
        TypeNames typeNames = server_CacheManager.getTypeNames();
        PropertyNames propertyNames = server_CacheManager.getPropertyNames();
        this.TYPENAME_PROJECT = "Project";
        this.TYPENAME_VIEW = "View";
        this.PROPNAME_PROJECTID = propertyNames.VIEW_PROJECT_ID;
        this.PROPNAME_VIEWID = propertyNames.PROJECT_DEFAULT_VIEW_ID;
    }

    private class EventSequence {
        MPXObjectEvent m_createProjectEvent = null;
        MPXObjectEvent m_createViewEvent = null;

        EventSequence() {
        }
    }
}

