/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SDKRuntimeException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

abstract class MPXClientSettingsParser {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(File file) throws FileNotFoundException, IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                Handler handler = new Handler(this);
                SAXParserFactory sAXParserFactory = null;
                SAXParser sAXParser = null;
                sAXParserFactory = SAXParserFactory.newInstance();
                sAXParser = sAXParserFactory.newSAXParser();
                sAXParser.parse((InputStream)bufferedInputStream, (DefaultHandler)handler);
            }
            catch (SAXException sAXException) {
                throw new SDKRuntimeException(Res.getString(ResIDs.STARTEAM_XML_INVALID_FORMAT_FMT), sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SDKRuntimeException(Res.getString(ResIDs.STARTEAM_XML_UNEXPECTED_ERROR_PARSING), parserConfigurationException);
            }
            Object var4_8 = null;
            if (bufferedInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            if (bufferedInputStream == null) throw throwable;
            ((InputStream)bufferedInputStream).close();
            throw throwable;
        }
        ((InputStream)bufferedInputStream).close();
    }

    protected abstract void loadProfile(String var1, String var2);

    protected MPXClientSettingsParser() {
    }

    private static class Handler
    extends DefaultHandler {
        MPXClientSettingsParser m_parser = null;
        private int depth = 0;
        private StringBuffer m_buffer = null;
        private String m_description = null;
        private String m_profileName = null;
        private boolean m_bDescription = false;
        private boolean m_bProfileName = false;

        private void expected(String string, String string2) {
            throw new RuntimeException(Res.formatKey(ResIDs.STARTEAM_XML_EXPECTED_BEGINNING_TAG_FMT, new Object[]{string, string2}));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (this.depth == 4) {
                if (this.m_description == null) {
                    if (!string3.equals("ServerDescription")) {
                        this.expected("ServerDescription", string3);
                    }
                    this.m_buffer = new StringBuffer();
                    this.m_bDescription = true;
                } else {
                    if (this.m_profileName != null) throw new RuntimeException(Res.formatKey(ResIDs.STARTEAM_XML_UNEXPECTED_ENDING_TAG_FMT, new Object[]{"ServerProfile", string3}));
                    if (!string3.equals("MPXProfileName")) {
                        this.expected("MPXProfileName", string3);
                    }
                    this.m_buffer = new StringBuffer();
                    this.m_bProfileName = true;
                }
            } else if (this.depth == 3) {
                if (!string3.equals("ServerProfile")) {
                    this.expected("ServerProfile", string3);
                }
            } else if (this.depth == 2) {
                if (!string3.equals("ServerProfiles")) {
                    this.expected("ServerProfiles", string3);
                }
            } else if (this.depth == 1) {
                if (!string3.equals("StarTeamMPXClient") && !string3.equals("StarbaseMPXClient")) {
                    this.expected("StarTeamMPXClient", string3);
                }
            } else {
                if (this.depth != 0) throw new RuntimeException(Res.formatKey(ResIDs.SUB_ELEMENT_NOT_ALLOWED_FMT, new Object[]{string3}));
                if (!string3.equals("StarTeam")) {
                    this.expected("StarTeam", string3);
                }
            }
            ++this.depth;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.m_buffer != null) {
                this.m_buffer.append(cArray, n, n2);
            }
        }

        public void endElement(String string, String string2, String string3) {
            --this.depth;
            if (this.depth == 4 && this.m_buffer != null) {
                String string4 = this.m_buffer.toString().trim();
                if (this.m_bDescription) {
                    this.m_description = string4;
                } else if (this.m_bProfileName) {
                    this.m_profileName = string4;
                }
                this.m_buffer = null;
                this.m_bDescription = false;
                this.m_bProfileName = false;
            } else if (this.depth == 3) {
                if (this.m_description == null) {
                    throw new RuntimeException(Res.formatKey(ResIDs.STARTEAM_XML_MISSING_TAG_FMT, new Object[]{"ServerDescription", "ServerProfile"}));
                }
                if (this.m_profileName == null) {
                    throw new RuntimeException(Res.formatKey(ResIDs.STARTEAM_XML_MISSING_TAG_FMT, new Object[]{"MPXProfileName", "ServerProfile"}));
                }
                this.m_parser.loadProfile(this.m_description, this.m_profileName);
                this.m_description = null;
                this.m_profileName = null;
            }
        }

        public Handler(MPXClientSettingsParser mPXClientSettingsParser) {
            this.m_parser = mPXClientSettingsParser;
        }
    }
}

