/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.ConfigFiles;
import com.starbase.starteam.MPXClientSettingsParser;
import com.starbase.starteam.MPXProfileInfo;
import com.starbase.starteam.ServerInfo;
import com.starbase.util.XMLUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Vector;

class MPXClientSettings
extends MPXClientSettingsParser {
    private static final String EOL = "\r\n";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    static final String ELT_ROOT = "StarTeam";
    static final String ELT_MPXROOT = "StarTeamMPXClient";
    static final String ELT_PROFILE_LIST = "ServerProfiles";
    static final String ELT_PROFILE = "ServerProfile";
    static final String ELT_SERVER_NAME = "ServerDescription";
    static final String ELT_PROFILE_NAME = "MPXProfileName";
    static final String ELT_MPXROOT_OLD = "StarbaseMPXClient";
    Vector m_profiles = new Vector();
    File m_myFile = null;

    public void load() throws IOException {
        File file = ConfigFiles.getStarTeamXML();
        this.loadFrom(file);
    }

    public void loadFrom(File file) throws IOException {
        if (file.exists()) {
            this.parse(file);
        }
        this.m_myFile = file;
    }

    protected void loadProfile(String string, String string2) {
        MPXProfileInfo mPXProfileInfo = null;
        int n = string.lastIndexOf(":");
        if (n >= 0) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1, string.length());
            mPXProfileInfo = new MPXProfileInfo(string3, string4);
        } else {
            String string5 = string;
            mPXProfileInfo = new MPXProfileInfo(string5);
        }
        mPXProfileInfo.setProfileName(string2);
        this.m_profiles.addElement(mPXProfileInfo);
    }

    protected MPXProfileInfo getProfile(String string, String string2) {
        if (string != null && string2 != null) {
            Enumeration enumeration = this.m_profiles.elements();
            while (enumeration.hasMoreElements()) {
                MPXProfileInfo mPXProfileInfo = (MPXProfileInfo)enumeration.nextElement();
                if (!string.equals(mPXProfileInfo.getHost()) || !string2.equals(mPXProfileInfo.getEndpoint())) continue;
                return mPXProfileInfo;
            }
        }
        return null;
    }

    protected MPXProfileInfo getProfile(String string) {
        if (string != null) {
            Enumeration enumeration = this.m_profiles.elements();
            while (enumeration.hasMoreElements()) {
                MPXProfileInfo mPXProfileInfo = (MPXProfileInfo)enumeration.nextElement();
                if (!string.equals(mPXProfileInfo.getServerDescription())) continue;
                return mPXProfileInfo;
            }
        }
        return null;
    }

    protected MPXProfileInfo getProfile(ServerInfo serverInfo) {
        if (serverInfo != null) {
            MPXProfileInfo mPXProfileInfo = this.getProfile(serverInfo.getHost(), serverInfo.getEndpoint());
            if (mPXProfileInfo == null) {
                mPXProfileInfo = this.getProfile(serverInfo.getDescription());
            }
            return mPXProfileInfo;
        }
        return null;
    }

    public String getProfileName(ServerInfo serverInfo) {
        if (serverInfo != null) {
            MPXProfileInfo mPXProfileInfo = this.getProfile(serverInfo.getHost(), serverInfo.getEndpoint());
            if (mPXProfileInfo == null) {
                mPXProfileInfo = this.getProfile(serverInfo.getDescription());
            }
            if (mPXProfileInfo != null) {
                return mPXProfileInfo.getProfileName();
            }
        }
        return "";
    }

    protected void setProfileName(String string, String string2, String string3) {
        if (string != null && string2 != null) {
            MPXProfileInfo mPXProfileInfo = this.getProfile(string, string2);
            if (mPXProfileInfo == null) {
                mPXProfileInfo = new MPXProfileInfo(string, string2);
                this.m_profiles.addElement(mPXProfileInfo);
            }
            mPXProfileInfo.setProfileName(string3);
        }
    }

    protected void setProfileName(String string, String string2) {
        if (string != null) {
            MPXProfileInfo mPXProfileInfo = this.getProfile(string);
            if (mPXProfileInfo == null) {
                mPXProfileInfo = new MPXProfileInfo(string);
                this.m_profiles.addElement(mPXProfileInfo);
            }
            mPXProfileInfo.setProfileName(string2);
        }
    }

    public void setProfileName(ServerInfo serverInfo, String string) {
        if (serverInfo != null) {
            MPXProfileInfo mPXProfileInfo = this.getProfile(serverInfo.getHost(), serverInfo.getEndpoint());
            if (mPXProfileInfo == null) {
                mPXProfileInfo = new MPXProfileInfo(serverInfo.getHost(), serverInfo.getEndpoint());
                this.m_profiles.addElement(mPXProfileInfo);
            }
            mPXProfileInfo.setProfileName(string);
            mPXProfileInfo = this.getProfile(serverInfo.getDescription());
            if (mPXProfileInfo != null) {
                mPXProfileInfo.setProfileName(string);
            }
        }
    }

    protected void removeProfile(String string, String string2) {
        MPXProfileInfo mPXProfileInfo;
        if (string != null && string2 != null && (mPXProfileInfo = this.getProfile(string, string2)) != null) {
            this.m_profiles.removeElement(mPXProfileInfo);
        }
    }

    protected void removeProfile(String string) {
        MPXProfileInfo mPXProfileInfo;
        if (string != null && (mPXProfileInfo = this.getProfile(string)) != null) {
            this.m_profiles.removeElement(mPXProfileInfo);
        }
    }

    public void removeProfile(ServerInfo serverInfo) {
        if (serverInfo != null) {
            this.removeProfile(serverInfo.getHost(), serverInfo.getEndpoint());
            this.removeProfile(serverInfo.getDescription());
        }
    }

    public void save() throws IOException {
        File file = this.m_myFile;
        if (this.m_myFile == null) {
            file = ConfigFiles.getStarTeamXML();
        }
        this.saveTo(file);
    }

    public void saveTo(File file) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
            bufferedWriter.write("<StarTeam>\r\n");
            bufferedWriter.write("    <StarTeamMPXClient>\r\n");
            bufferedWriter.write("        <ServerProfiles>\r\n");
            Enumeration enumeration = this.m_profiles.elements();
            while (enumeration.hasMoreElements()) {
                MPXProfileInfo mPXProfileInfo = (MPXProfileInfo)enumeration.nextElement();
                bufferedWriter.write("            <ServerProfile>\r\n");
                bufferedWriter.write("                <ServerDescription>");
                if (!mPXProfileInfo.isObsolete()) {
                    bufferedWriter.write(XMLUtils.escape(mPXProfileInfo.getHost() + ":" + mPXProfileInfo.getEndpoint()));
                } else {
                    bufferedWriter.write(XMLUtils.escape(mPXProfileInfo.getServerDescription()));
                }
                bufferedWriter.write("                </ServerDescription>\r\n");
                bufferedWriter.write("                <MPXProfileName>");
                bufferedWriter.write(XMLUtils.escape(mPXProfileInfo.getProfileName()));
                bufferedWriter.write("                </MPXProfileName>\r\n");
                bufferedWriter.write("            </ServerProfile>\r\n");
            }
            bufferedWriter.write("        </ServerProfiles>\r\n");
            bufferedWriter.write("    </StarTeamMPXClient>\r\n");
            bufferedWriter.write("</StarTeam>\r\n");
        }
        finally {
            Object var4_5 = null;
            bufferedWriter.close();
        }
        this.m_myFile = file;
    }
}

