/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.smartsockets.TipcCb;
import com.smartsockets.TipcErrorCb;
import com.smartsockets.TipcException;
import com.smartsockets.TipcMon;
import com.smartsockets.TipcMsg;
import com.smartsockets.TipcProcessCb;
import com.smartsockets.TipcSrv;
import com.starbase.starteam.ClientContext;
import com.starbase.starteam.CmdGetEventHandlerProps;
import com.starbase.starteam.EventHandlerProfile;
import com.starbase.starteam.MPXException;
import com.starbase.starteam.MPXMessageBroker;
import com.starbase.starteam.MPXServerControlEvent;
import com.starbase.starteam.PropertyValues;
import com.starbase.starteam.RC4;
import com.starbase.starteam.Server;
import com.starbase.util.Assert;
import com.starbase.util.GUID;
import com.starbase.util.MD5;
import java.util.Enumeration;
import java.util.Vector;

class MPXClient {
    private static final String CLIENT_SUBJECT_BASE = "/STEvent/";
    private static final String SERVER_SUBJECT_BASE = "/StarbaseServer_";
    protected static final int UNINITIALIZED = 0;
    protected static final int DISABLED = 1;
    protected static final int PAUSED = 2;
    protected static final int RUNNING = 3;
    private String m_strSubjectBase = null;
    private String m_strRootSubject = null;
    private String m_strServerSubject = null;
    private MPXMessageBroker m_broker = null;
    private boolean m_bIsOnLine = false;
    private int m_nCurrentState = 0;
    private Vector m_callbacks = new Vector();
    private Vector m_subjects = new Vector();
    private Vector m_callbackHandles = null;
    private TipcCb m_ServerControlCb = null;
    private TipcCb m_SubjectSubscribeCb = null;
    private TipcCb m_errorCb = null;
    private byte[] m_encryptionKey = null;

    public static String getSubjectForRepository(Server server) {
        GUID gUID = server.getRepositoryID();
        return CLIENT_SUBJECT_BASE + gUID.canonicalFormat() + "/";
    }

    public static String getSubjectForWorkstation(Server server) {
        ClientContext clientContext = server.getClientContext();
        GUID gUID = clientContext.getWorkStationID();
        return MPXClient.getSubjectForRepository(server) + gUID.canonicalFormat() + "/";
    }

    private static String getServerSubject(Server server) {
        GUID gUID = server.getRepositoryID();
        return SERVER_SUBJECT_BASE + gUID.canonicalFormat();
    }

    protected void finalize() throws Throwable {
        try {
            this.stop();
        }
        catch (MPXException mPXException) {
            // empty catch block
        }
        super.finalize();
    }

    protected void addMPXMessageCbs() {
    }

    protected void handleMPXServerControlEvent(MPXServerControlEvent mPXServerControlEvent) {
        switch (mPXServerControlEvent.getControlFunction()) {
            case 2: {
                try {
                    this.internalPause();
                }
                catch (MPXException mPXException) {
                    this.handleMPXException(mPXException);
                }
                this.setEncryptionKey(null);
                break;
            }
            case 1: {
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
    }

    protected boolean handleMPXException(MPXException mPXException) {
        return false;
    }

    public void start() throws MPXException {
        this.setRunningState(3);
    }

    public boolean isStarted() {
        return this.m_nCurrentState >= 2;
    }

    public boolean isRunning() {
        return this.m_bIsOnLine && this.m_nCurrentState == 3;
    }

    public void stop() throws MPXException {
        this.setRunningState(0);
    }

    public void ping() throws MPXException {
        MPXMessageBroker mPXMessageBroker = this.m_broker;
        if (mPXMessageBroker != null) {
            mPXMessageBroker.ping();
        } else {
            MPXException.throwNotConnectedException();
        }
        if (!this.m_bIsOnLine) {
            MPXException.throwEventTransmitterNotRespondingException();
        }
    }

    protected TipcSrv getServer() {
        return this.m_broker.getServer();
    }

    protected synchronized void setRunningState(int n) throws MPXException {
        MPXMessageBroker mPXMessageBroker;
        block11: {
            if (this.m_nCurrentState == n) {
                return;
            }
            if (this.m_nCurrentState <= 0) {
                Assert.internalError("MPXClient.setRunningState(), m_nCurrentState=" + this.m_nCurrentState);
            }
            if (this.m_broker == null) {
                Assert.internalError("MPXClient.setRunningState(), m_broker=null");
            }
            if (this.m_strRootSubject.length() <= 0) {
                Assert.internalError("MPXClient.setRunningState(), m_strRootSubject.length()=" + this.m_strRootSubject.length());
            }
            mPXMessageBroker = this.m_broker;
            mPXMessageBroker.setChanging(true);
            try {
                if (this.m_nCurrentState < n) {
                    if (this.m_nCurrentState == 1 && n >= 2) {
                        this.subscribe(true);
                        this.enablePausedStateCallbacks(true);
                        this.m_nCurrentState = 2;
                    }
                    if (this.m_nCurrentState == 2 && n >= 3) {
                        this.internalResume();
                    }
                    break block11;
                }
                if (this.m_nCurrentState == 3 && n <= 2) {
                    this.internalPause();
                }
                if (this.m_nCurrentState == 2 && n <= 1) {
                    this.enablePausedStateCallbacks(false);
                    this.subscribe(false);
                    this.m_nCurrentState = 1;
                }
                if (this.m_nCurrentState != 1 || n > 0) break block11;
                this.shutdown();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                mPXMessageBroker.setChanging(false);
                throw throwable;
            }
        }
        Object var4_3 = null;
        mPXMessageBroker.setChanging(false);
    }

    private synchronized void internalPause() throws MPXException {
        this.enableRunningStateCallbacks(false);
        this.m_nCurrentState = 2;
    }

    private synchronized void internalResume() throws MPXException {
        this.enableRunningStateCallbacks(true);
        this.m_nCurrentState = 3;
    }

    protected void subscribe(boolean bl) throws MPXException {
        try {
            TipcSrv tipcSrv = this.getServer();
            if (bl) {
                tipcSrv.setSubjectSubscribe(this.m_strRootSubject, true);
                TipcMon.setSubjectSubscribeWatch((TipcSrv)tipcSrv, (String)this.m_strServerSubject, (boolean)true);
            } else {
                TipcMon.setSubjectSubscribeWatch((TipcSrv)tipcSrv, (String)this.m_strServerSubject, (boolean)false);
                tipcSrv.setSubjectSubscribe(this.m_strRootSubject, false);
            }
            tipcSrv.flush();
        }
        catch (TipcException tipcException) {
            MPXClient.throwTipcException(tipcException);
        }
    }

    protected void enablePausedStateCallbacks(boolean bl) throws MPXException {
        if (bl) {
            this.enableErrorCb(true);
        }
        this.enableServerControlCb(bl);
        this.enableSubjectSubscribeStatusCb(bl);
        if (!bl) {
            this.enableErrorCb(false);
        }
    }

    protected void enableRunningStateCallbacks(boolean bl) throws MPXException {
        this.enableProcessCbs(bl);
    }

    protected synchronized void shutdown() throws MPXException {
        if (this.m_nCurrentState > 1) {
            this.setRunningState(0);
        } else if (this.m_nCurrentState == 1) {
            if (this.m_broker == null) {
                Assert.internalError("MPXClient.shutdown(), m_nCurrentState == DISABLED, m_broker == null");
            }
            this.m_bIsOnLine = false;
            this.m_broker.disconnect(this);
            this.m_broker = null;
            this.m_nCurrentState = 0;
        }
        if (this.m_nCurrentState != 0) {
            Assert.internalError("MPXClient.shutdown(),  m_nCurrentState=" + this.m_nCurrentState);
        }
        if (this.m_broker != null) {
            Assert.internalError("MPXClient.shutdown(), m_broker!=null");
        }
    }

    private static void throwTipcException(TipcException tipcException) throws MPXException {
        MPXException.throwMPXException(tipcException.getErrNum(), tipcException.getMessage());
    }

    protected void addMPXMessageCb(MPXBinaryMessageCb mPXBinaryMessageCb, String string) {
        MPXClient mPXClient = this;
        if (mPXClient == null) {
            throw null;
        }
        this.addProcessCb(new TipcProcessCb(mPXClient, mPXBinaryMessageCb){
            private final /* synthetic */ MPXClient this$0;
            private final /* synthetic */ MPXBinaryMessageCb val$handler;

            public void process(TipcMsg tipcMsg, Object object) {
                try {
                    byte[] byArray = this.this$0.getMessage(tipcMsg);
                    byte[] byArray2 = this.this$0.getEncryptionKey();
                    RC4.Key key = new RC4.Key(byArray2);
                    RC4.rc4(byArray, byArray.length, key);
                    this.val$handler.handle(byArray);
                }
                catch (MPXException mPXException) {
                    this.this$0.handleMPXException(mPXException);
                }
            }
            {
                this.val$handler = mPXBinaryMessageCb;
                this.this$0 = mPXClient;
                this.constructor$0(mPXClient);
            }

            private final void constructor$0(MPXClient mPXClient) {
            }
        }, string);
    }

    private void addProcessCb(TipcProcessCb tipcProcessCb, String string) {
        if (this.m_callbackHandles != null) {
            Assert.internalError("MPXClient.addProcessCb(), m_callbackHandles != null");
        }
        string = this.m_strSubjectBase + string + "/...";
        this.m_callbacks.addElement(tipcProcessCb);
        this.m_subjects.addElement(string);
    }

    protected void enableProcessCbs(boolean bl) throws MPXException {
        if (this.m_callbacks.size() != this.m_subjects.size()) {
            Assert.internalError("MPXClient.enableProcessCbs(), m_callbacks.size() != m_subjects.size(), m_callbacks.size()=" + this.m_callbacks.size() + ", m_subjects.size()=" + this.m_subjects.size());
        }
        if (bl) {
            if (this.m_callbackHandles == null) {
                TipcSrv tipcSrv = this.getServer();
                this.m_callbackHandles = new Vector();
                Enumeration enumeration = this.m_callbacks.elements();
                Enumeration enumeration2 = this.m_subjects.elements();
                while (enumeration.hasMoreElements()) {
                    TipcProcessCb tipcProcessCb = (TipcProcessCb)enumeration.nextElement();
                    String string = (String)enumeration2.nextElement();
                    this.m_callbackHandles.addElement(tipcSrv.addProcessCb(tipcProcessCb, string, null));
                }
                if (this.m_callbacks.size() != this.m_callbackHandles.size()) {
                    Assert.internalError("MPXClient.enableProcessCbs(), m_callbackHandles == null, m_callbacks.size()=" + this.m_callbacks.size() + ", m_callbackHandles.size()=" + this.m_callbackHandles.size());
                }
            }
        } else if (this.m_callbackHandles != null) {
            if (this.m_callbacks.size() != this.m_callbackHandles.size()) {
                Assert.internalError("MPXClient.enableProcessCbs(), m_callbackHandles != null, m_callbacks.size() != m_callbackHandles.size(), m_callbacks.size()=" + this.m_callbacks.size() + ", m_callbackHandles.size()=" + this.m_callbackHandles.size());
            }
            TipcSrv tipcSrv = this.getServer();
            Enumeration enumeration = this.m_callbackHandles.elements();
            while (enumeration.hasMoreElements()) {
                TipcCb tipcCb = (TipcCb)enumeration.nextElement();
                try {
                    tipcSrv.removeProcessCb(tipcCb);
                }
                catch (TipcException tipcException) {
                    MPXClient.throwTipcException(tipcException);
                }
            }
            this.m_callbackHandles = null;
        }
    }

    protected void enableServerControlCb(boolean bl) throws MPXException {
        if (bl) {
            if (this.m_ServerControlCb == null) {
                MPXClient mPXClient = this;
                if (mPXClient == null) {
                    throw null;
                }
                this.m_ServerControlCb = this.getServer().addProcessCb(new TipcProcessCb(mPXClient){
                    private final /* synthetic */ MPXClient this$0;

                    public void process(TipcMsg tipcMsg, Object object) {
                        try {
                            MPXServerControlEvent mPXServerControlEvent = new MPXServerControlEvent(this.this$0.getText(tipcMsg));
                            this.this$0.handleMPXServerControlEvent(mPXServerControlEvent);
                        }
                        catch (MPXException mPXException) {
                            this.this$0.handleMPXException(mPXException);
                        }
                    }
                    {
                        this.this$0 = mPXClient;
                        this.constructor$0(mPXClient);
                    }

                    private final void constructor$0(MPXClient mPXClient) {
                    }
                }, this.m_strSubjectBase + "ServerControl/...", null);
            }
        } else if (this.m_ServerControlCb != null) {
            try {
                this.getServer().removeProcessCb(this.m_ServerControlCb);
            }
            catch (TipcException tipcException) {
                MPXClient.throwTipcException(tipcException);
            }
            this.m_ServerControlCb = null;
        }
    }

    protected void enableSubjectSubscribeStatusCb(boolean bl) throws MPXException {
        if (bl) {
            if (this.m_SubjectSubscribeCb == null) {
                try {
                    MPXClient mPXClient = this;
                    if (mPXClient == null) {
                        throw null;
                    }
                    this.m_SubjectSubscribeCb = this.getServer().addProcessCb(new TipcProcessCb(mPXClient){
                        private final /* synthetic */ MPXClient this$0;

                        public void process(TipcMsg tipcMsg, Object object) {
                            try {
                                MPXClient.access$0(this.this$0, tipcMsg);
                            }
                            catch (MPXException mPXException) {
                                this.this$0.handleMPXException(mPXException);
                            }
                        }
                        {
                            this.this$0 = mPXClient;
                            this.constructor$0(mPXClient);
                        }

                        private final void constructor$0(MPXClient mPXClient) {
                        }
                    }, -409, null);
                }
                catch (TipcException tipcException) {
                    MPXClient.throwTipcException(tipcException);
                }
            }
        } else if (this.m_SubjectSubscribeCb != null) {
            try {
                this.getServer().removeProcessCb(this.m_SubjectSubscribeCb);
            }
            catch (TipcException tipcException) {
                MPXClient.throwTipcException(tipcException);
            }
            this.m_SubjectSubscribeCb = null;
        }
    }

    private void handleSubjectSubscribeMsg(TipcMsg tipcMsg) throws MPXException {
        try {
            String string = tipcMsg.nextStr();
            if (this.m_strServerSubject.equals(string)) {
                String[] stringArray = tipcMsg.nextStrArray();
                String string2 = tipcMsg.nextStr();
                String string3 = tipcMsg.nextStr();
                boolean bl = false;
                if (string.equals(string2)) {
                    bl = true;
                } else if (string.equals(string3)) {
                    bl = false;
                } else {
                    int n = 0;
                    while (n < stringArray.length) {
                        String string4 = stringArray[n];
                        if (string.equals(string4)) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (bl != this.m_bIsOnLine) {
                    if (bl) {
                        this.onTransmitterOnline();
                    } else {
                        this.onTransmitterOffline();
                    }
                }
            }
        }
        catch (TipcException tipcException) {
            MPXClient.throwTipcException(tipcException);
        }
    }

    private void onTransmitterOnline() {
        this.m_bIsOnLine = true;
        int n = 11;
        MPXServerControlEvent mPXServerControlEvent = new MPXServerControlEvent(n);
        this.handleMPXServerControlEvent(mPXServerControlEvent);
    }

    private void onTransmitterOffline() {
        this.m_bIsOnLine = false;
        int n = 12;
        MPXServerControlEvent mPXServerControlEvent = new MPXServerControlEvent(n);
        this.handleMPXServerControlEvent(mPXServerControlEvent);
    }

    protected void enableErrorCb(boolean bl) throws MPXException {
        if (bl) {
            if (this.m_errorCb == null) {
                MPXClient mPXClient = this;
                if (mPXClient == null) {
                    throw null;
                }
                this.m_errorCb = this.getServer().addErrorCb(new TipcErrorCb(mPXClient){
                    private final /* synthetic */ MPXClient this$0;

                    public void error(int n, String string, Object object) {
                        MPXClient.access$1(this.this$0, n, string, object);
                    }
                    {
                        this.this$0 = mPXClient;
                        this.constructor$0(mPXClient);
                    }

                    private final void constructor$0(MPXClient mPXClient) {
                    }
                }, (short)1, null);
            }
        } else if (this.m_errorCb != null) {
            try {
                this.getServer().removeErrorCb(this.m_errorCb);
            }
            catch (TipcException tipcException) {
                MPXClient.throwTipcException(tipcException);
            }
            this.m_errorCb = null;
        }
    }

    private void handleFatalConnectionError(int n, String string, Object object) {
        Object object2;
        this.onTransmitterOffline();
        TipcCb tipcCb = this.getServer().getDefaultErrorCb();
        if (tipcCb != null && (object2 = tipcCb.getCb()) instanceof TipcErrorCb) {
            ((TipcErrorCb)object2).error(n, string, object);
        }
    }

    protected byte[] getMessage(TipcMsg tipcMsg) throws MPXException {
        byte[] byArray = null;
        try {
            byArray = tipcMsg.nextBinary();
        }
        catch (TipcException tipcException) {
            MPXClient.throwTipcException(tipcException);
        }
        return byArray;
    }

    protected String getText(TipcMsg tipcMsg) throws MPXException {
        String string = null;
        try {
            string = tipcMsg.nextStr();
        }
        catch (TipcException tipcException) {
            MPXClient.throwTipcException(tipcException);
        }
        return string;
    }

    protected byte[] getEncryptionKey() {
        if (this.m_encryptionKey == null) {
            Assert.internalError("MPXClient.getEncryptionKey(), m_encryptionKey == null");
        }
        return this.m_encryptionKey;
    }

    protected void setEncryptionKey(Server server) {
        this.m_encryptionKey = (byte[])(server != null ? this.getMPXKey(server) : null);
    }

    private byte[] getMPXKey(Server server) {
        String[] stringArray = new String[]{"key"};
        PropertyValues propertyValues = this.getEventProperties(server, "StarbaseMPX Transmitter", stringArray);
        byte[] byArray = (byte[])propertyValues.get("key");
        MD5 mD5 = new MD5();
        mD5.computeBufferMD5(byArray);
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = mD5.getData();
        int n = 0;
        while (n < 5) {
            byArray2[n] = byArray3[n];
            ++n;
        }
        return byArray2;
    }

    private PropertyValues getEventProperties(Server server, String string, String[] stringArray) {
        CmdGetEventHandlerProps cmdGetEventHandlerProps = new CmdGetEventHandlerProps(server, string, stringArray);
        cmdGetEventHandlerProps.execute();
        return cmdGetEventHandlerProps.getPropertyValues();
    }

    static /* synthetic */ void access$0(MPXClient mPXClient, TipcMsg tipcMsg) throws MPXException {
        mPXClient.handleSubjectSubscribeMsg(tipcMsg);
    }

    static /* synthetic */ void access$1(MPXClient mPXClient, int n, String string, Object object) {
        mPXClient.handleFatalConnectionError(n, string, object);
    }

    public MPXClient(String string, Server server, EventHandlerProfile eventHandlerProfile) throws MPXException {
        if (!string.startsWith(CLIENT_SUBJECT_BASE)) {
            Assert.internalError("MPXClient.MPXClient(), 1. strSubject=" + string);
        }
        if (!string.endsWith("/")) {
            Assert.internalError("MPXClient.MPXClient(), 2. strSubject=" + string);
        }
        this.m_strSubjectBase = string;
        this.m_strRootSubject = this.m_strSubjectBase + "...";
        this.m_strServerSubject = MPXClient.getServerSubject(server);
        this.addMPXMessageCbs();
        this.setEncryptionKey(server);
        this.m_broker = MPXMessageBroker.connect(this, eventHandlerProfile);
        this.m_nCurrentState = 1;
        this.m_bIsOnLine = true;
    }

    static interface MPXBinaryMessageCb {
        public void handle(byte[] var1);
    }
}

