/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.BaseKeywords;
import com.starbase.util.OLEDate;
import com.starbase.util.XMLUtils;
import java.util.StringTokenizer;

public class LogLine {
    private static final String EMPTY_STRING = "";
    private static final String TAB = "\t";
    private static final String SPACE = " ";
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String WHITE = " \t\r\n";
    private int m_Version;
    private String m_ViewName;
    private String m_Dot;
    private OLEDate m_Date;
    private String m_Author;
    private String m_Comment;
    private int m_nMaxColumnWidth = 80;
    private int m_nVersionWidth = 5;
    private int m_nViewWidth = 10;
    private int m_nDotWidth = 12;
    private int m_nDateWidth;
    private int UTC_DATE_WIDTH = 21;
    private int LOCAL_DATE_WIDTH = 23;
    private int m_nAuthorWidth = 15;
    private int m_firstCommentWidth = 0;
    private int m_restCommentWidth = 0;

    private int commentIndent() {
        return 1 + this.m_nVersionWidth;
    }

    private int allWidths() {
        return 1 + this.m_nVersionWidth + this.m_nViewWidth + this.m_nDotWidth + this.m_nDateWidth + this.m_nAuthorWidth;
    }

    String format(String string, String string2, boolean bl) {
        this.m_nDateWidth = bl ? this.UTC_DATE_WIDTH : this.LOCAL_DATE_WIDTH;
        this.m_firstCommentWidth = this.m_nMaxColumnWidth - (string.length() + 1);
        if (this.m_firstCommentWidth < 0) {
            this.m_firstCommentWidth = 0;
        }
        this.m_restCommentWidth = this.m_nMaxColumnWidth - (1 + string.length() + this.commentIndent());
        if (this.m_restCommentWidth < 0) {
            this.m_restCommentWidth = 0;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(this.m_nMaxColumnWidth);
        stringBuffer.append(this.pad(Integer.toString(this.m_Version), this.m_nVersionWidth));
        stringBuffer.append(this.pad(this.m_ViewName, this.m_nViewWidth));
        stringBuffer.append(this.pad(this.m_Dot, this.m_nDotWidth));
        stringBuffer.append(this.dateString(bl));
        stringBuffer.append(this.pad(this.m_Author, this.m_nAuthorWidth));
        stringBuffer.append(SPACE);
        StringBuffer stringBuffer2 = new StringBuffer(this.m_nMaxColumnWidth);
        stringBuffer2.append(string);
        stringBuffer2.append(SPACE);
        stringBuffer2.append(this.commentString(stringBuffer.toString(), n, string, string2));
        stringBuffer2.append(string2);
        String string3 = stringBuffer2.toString();
        return string3;
    }

    private String dateString(boolean bl) {
        String string = BaseKeywords.formatDate(this.m_Date, bl);
        return this.pad(string, this.m_nDateWidth);
    }

    private boolean isCR(String string) {
        String string2 = "\r\n";
        return string.length() == 1 && string2.indexOf(string.charAt(0)) != -1;
    }

    private void addEOL(StringBuffer stringBuffer, int n, String string, String string2) {
        this.trim(stringBuffer);
        stringBuffer.append(string2);
        stringBuffer.append(string);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(SPACE);
            ++n2;
        }
    }

    private void trim(StringBuffer stringBuffer) {
        char c = ' ';
        while (stringBuffer.charAt(stringBuffer.length() - 1) == c) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
    }

    private boolean isWhite(String string) {
        String string2 = WHITE;
        return string.length() == 1 && string2.indexOf(string.charAt(0)) != -1;
    }

    private String commentString(String string, int n, String string2, String string3) {
        String string4 = string + this.m_Comment;
        StringTokenizer stringTokenizer = new StringTokenizer(string4, WHITE, true);
        StringBuffer stringBuffer = new StringBuffer(string4.length());
        int n2 = this.commentIndent();
        int[] nArray = new int[]{this.m_firstCommentWidth};
        int[] nArray2 = new int[]{0};
        String string5 = null;
        String string6 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string5 = string6;
            string6 = stringTokenizer.nextToken();
            this.insertWord(stringBuffer, string6, string5, string2, n2, string3, nArray2, nArray);
        }
        return stringBuffer.toString();
    }

    private void insertWord(StringBuffer stringBuffer, String string, String string2, String string3, int n, String string4, int[] nArray, int[] nArray2) {
        if (string.equals(CR)) {
            this.addEOL(stringBuffer, n, string3, string4);
            nArray2[0] = this.m_restCommentWidth;
            nArray[0] = 0;
        } else if (string.equals(LF)) {
            if (!CR.equals(string2)) {
                this.addEOL(stringBuffer, n, string3, string4);
                nArray2[0] = this.m_restCommentWidth;
                nArray[0] = 0;
            }
        } else {
            if (TAB.equals(string)) {
                string = SPACE;
            }
            if (nArray[0] != 0 || !SPACE.equals(string)) {
                String string5 = string;
                String string6 = EMPTY_STRING;
                String[] stringArray = new String[2];
                while (string5.length() > 0) {
                    int n2 = nArray2[0] - nArray[0];
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    this.split(string5, n2, nArray2[0], stringArray);
                    string6 = stringArray[0];
                    string5 = stringArray[1];
                    if (string6.length() > 0) {
                        stringBuffer.append(string6);
                        nArray[0] = nArray[0] + string6.length();
                        if (string5.length() <= 0) continue;
                        this.addEOL(stringBuffer, n, string3, string4);
                        nArray2[0] = this.m_restCommentWidth;
                        nArray[0] = 0;
                        continue;
                    }
                    this.addEOL(stringBuffer, n, string3, string4);
                    nArray2[0] = this.m_restCommentWidth;
                    stringBuffer.append(string5);
                    nArray[0] = string5.length();
                    string5 = EMPTY_STRING;
                }
            }
        }
    }

    private void split(String string, int n, int n2, String[] stringArray) {
        int n3 = string.length();
        if (n3 < n) {
            stringArray[0] = string;
            stringArray[1] = EMPTY_STRING;
        } else if (n != 0 && (n3 - n > n2 || n3 > n2)) {
            stringArray[0] = string.substring(0, n - 1);
            stringArray[1] = string.substring(n - 1);
        } else {
            stringArray[0] = EMPTY_STRING;
            stringArray[1] = string;
        }
    }

    private String pad(String string, int n) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = 0;
        while (n3 < n - n2) {
            stringBuffer.append(SPACE);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = LF;
        String string2 = "        ";
        stringBuffer.append("<logline>" + string);
        stringBuffer.append(string2);
        stringBuffer.append("<version>");
        stringBuffer.append(Integer.toString(this.m_Version));
        stringBuffer.append("</version>" + string);
        stringBuffer.append(string2);
        stringBuffer.append("<view>");
        XMLUtils.writeEscaped(this.m_ViewName, stringBuffer);
        stringBuffer.append("</view>" + string);
        stringBuffer.append(string2);
        stringBuffer.append("<dotnotation>");
        XMLUtils.writeEscaped(this.m_Dot, stringBuffer);
        stringBuffer.append("</dotnotation>" + string);
        stringBuffer.append(string2);
        stringBuffer.append("<date>");
        XMLUtils.writeEscaped(this.m_Date.toISO8601String(), stringBuffer);
        stringBuffer.append("</date>" + string);
        stringBuffer.append(string2);
        stringBuffer.append("<author>");
        XMLUtils.writeEscaped(this.m_Author, stringBuffer);
        stringBuffer.append("</author>" + string);
        stringBuffer.append(string2);
        stringBuffer.append("<comment>");
        XMLUtils.writeEscaped(this.m_Comment, stringBuffer);
        stringBuffer.append("</comment>" + string);
        stringBuffer.append("</logline>");
        return stringBuffer.toString();
    }

    public LogLine(int n, String string, String string2, OLEDate oLEDate, String string3, String string4) {
        this.m_Version = n;
        this.m_ViewName = string;
        this.m_Dot = string2;
        this.m_Date = oLEDate;
        this.m_Author = string3;
        this.m_Comment = string4;
    }
}

