/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Item;
import com.starbase.starteam.Link;
import com.starbase.starteam.Type;
import com.starbase.starteam.View;
import com.starbase.util.Assert;

public class LinkEndpoint {
    private Link m_parentLink;
    private Type m_type;
    private int m_VMID;
    private int m_objectID;
    private int m_revisionNumber;
    private String m_dotNotation;
    private int m_viewID = -1;
    private int m_folderObjectID = -1;

    public Type getType() {
        return this.m_type;
    }

    public int getItemID() {
        return this.m_VMID;
    }

    public int getObjectID() {
        return this.m_objectID;
    }

    public int getRevisionNumber() {
        return this.m_revisionNumber;
    }

    public String getDotNotation() {
        return this.m_dotNotation;
    }

    public int getViewID() {
        return this.m_viewID;
    }

    public int getFolderObjectID() {
        return this.m_folderObjectID;
    }

    public boolean isPinned() {
        return this.getRevisionNumber() != -1;
    }

    public Item getItem() {
        return this.m_parentLink.getView().getDisembodiedItem(this.m_VMID, this.m_type);
    }

    Item resolve(View view) {
        int n = this.getItemID();
        Type type = this.getType();
        if (!this.isPinned()) {
            return view.getDisembodiedItem(n, type);
        }
        Item item = null;
        String string = this.getDotNotation();
        Item[] itemArray = view.getHistoryForItemID(n, type);
        int n2 = itemArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Item item2 = itemArray[n3];
            if (string.equals(item2.getDotNotation())) {
                item = item2;
                break;
            }
            ++n3;
        }
        return item;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        String string = System.getProperty("line.separator");
        stringBuffer.append("m_isPinned: " + this.isPinned() + string);
        stringBuffer.append("m_type: " + this.m_type + string);
        stringBuffer.append("m_VMID: " + this.m_VMID + string);
        stringBuffer.append("m_objectID: " + this.m_objectID + string);
        stringBuffer.append("m_revisionNumber: " + this.m_revisionNumber + string);
        stringBuffer.append("m_dotNotation: " + this.m_dotNotation + string);
        stringBuffer.append("m_viewID: " + this.m_viewID + string);
        stringBuffer.append("m_folderObjectID: " + this.m_folderObjectID + string);
        return stringBuffer.toString();
    }

    LinkEndpoint(Link link, Type type, int n, int n2, int n3, String string, int n4, int n5) {
        if (link == null) {
            Assert.internalError("LinkEndpoint.LinkEndpoint(), parentLink=null");
        }
        if (type == null) {
            Assert.internalError("LinkEndpoint.LinkEndpoint(), type=null");
        }
        if (n == -1) {
            Assert.internalError("LinkEndpoint.LinkEndpoint(), vmid=-1");
        }
        if (string == null) {
            Assert.internalError("LinkEndpoint.LinkEndpoint(), dotNotation=null");
        }
        if (n4 == -1) {
            Assert.internalError("LinkEndpoint.LinkEndpoint(), viewID=-1");
        }
        this.m_parentLink = link;
        this.m_type = type;
        this.m_VMID = n;
        this.m_objectID = n2;
        this.m_revisionNumber = n3;
        this.m_dotNotation = string;
        this.m_viewID = n4;
        this.m_folderObjectID = n5;
    }
}

