/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Item;
import com.starbase.starteam.LinkEndpoint;
import com.starbase.starteam.PutMethods;
import com.starbase.starteam.Server;
import com.starbase.starteam.View;
import com.starbase.util.Indent;
import com.starbase.util.OLEDate;
import java.util.Vector;

public class Link {
    private static final String EMPTY = "";
    int m_nFirstParentRevision = -1;
    int m_nFirstChildRevision = -1;
    boolean m_bUpdateComment = false;
    boolean m_bUpdateParentPin = false;
    boolean m_bUpdateChildPin = false;
    Item m_parentItem;
    Item m_childItem;
    int m_createdUserID;
    OLEDate m_createdTime;
    String m_comment = "";
    int m_folderItemID = -1;
    private Server m_server;
    private View m_view;
    private int m_ID = -1;
    private LinkEndpoint m_parent;
    private LinkEndpoint m_child;

    public LinkEndpoint getParentEndpoint() {
        return this.m_parent;
    }

    void setParentEndpoint(LinkEndpoint linkEndpoint) {
        this.m_parent = linkEndpoint;
    }

    public LinkEndpoint getChildEndpoint() {
        return this.m_child;
    }

    void setChildEndpoint(LinkEndpoint linkEndpoint) {
        this.m_child = linkEndpoint;
    }

    public int getID() {
        return this.m_ID;
    }

    void setID(int n) {
        this.m_ID = n;
    }

    public int getParentFolderItemID() {
        return this.m_folderItemID;
    }

    public OLEDate getCreatedTime() {
        return this.m_createdTime;
    }

    public int getCreatedUserID() {
        return this.m_createdUserID;
    }

    public View getView() {
        return this.m_view;
    }

    public Server getServer() {
        return this.m_server;
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String string) {
        if (!this.m_comment.equals(string)) {
            this.m_comment = string;
            this.m_bUpdateComment = true;
        }
    }

    public Item resolveParent() {
        return this.getParentEndpoint().resolve(this.getView());
    }

    public Item resolveChild() {
        return this.getChildEndpoint().resolve(this.getView());
    }

    int getParentFolderID(Item item) {
        if (item.isDisembodied()) {
            return -1;
        }
        return item.getParentFolder() == null ? -1 : (Integer)item.getParentFolder().get(this.m_server.getPropertyNames().OBJECT_ID);
    }

    public void pinParent(Item item) {
        this.m_bUpdateParentPin = true;
        this.m_parent = new LinkEndpoint(this, this.m_parent.getType(), this.m_parent.getItemID(), item.getObjectID(), item.getRevisionNumber(), item.getDotNotation(), this.m_parent.getViewID(), this.m_parent.getFolderObjectID());
    }

    public void unpinParent() {
        this.m_bUpdateParentPin = true;
        this.m_parent = new LinkEndpoint(this, this.m_parent.getType(), this.m_parent.getItemID(), -1, -1, EMPTY, this.m_parent.getViewID(), this.m_parent.getFolderObjectID());
    }

    public void pinChild(Item item) {
        this.m_bUpdateChildPin = true;
        this.m_child = new LinkEndpoint(this, this.m_child.getType(), this.m_child.getItemID(), item.getObjectID(), item.getRevisionNumber(), item.getDotNotation(), this.m_child.getViewID(), this.m_child.getFolderObjectID());
    }

    public void unpinChild() {
        this.m_bUpdateChildPin = true;
        this.m_child = new LinkEndpoint(this, this.m_child.getType(), this.m_child.getItemID(), -1, -1, EMPTY, this.m_child.getViewID(), this.m_child.getFolderObjectID());
    }

    public void delete() {
        Vector<Link> vector = new Vector<Link>();
        vector.addElement(this);
        this.m_server.deleteItems(vector);
    }

    public void update() {
        Vector<Link> vector = new Vector<Link>();
        vector.addElement(this);
        this.m_server.putItems(vector);
    }

    public static Link linkAndPin(Item item, Item item2, String string, boolean bl) {
        Link link = null;
        if (item.getServer().getRevisionLevel() >= 83) {
            link = new Link(item, true, item2, true, string);
            PutMethods.createNewLink(link, true, bl);
        } else {
            if (bl) {
                int n = item2.getItemID();
                Link[] linkArray = item.getServer().findLinks(item);
                int n2 = 0;
                while (n2 < linkArray.length) {
                    if (n == linkArray[n2].getParentEndpoint().getItemID() || n == linkArray[n2].getChildEndpoint().getItemID()) {
                        link = linkArray[n2];
                        break;
                    }
                    ++n2;
                }
            }
            if (link == null) {
                link = new Link(item, item2);
            }
            link.unpinParent();
            link.unpinChild();
            link.pinParent(item);
            link.pinChild(item2);
            link.setComment(string);
            link.update();
        }
        return link;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        String string = System.getProperty("line.separator");
        stringBuffer.append("m_ID: " + this.m_ID + string);
        stringBuffer.append("m_view: " + this.m_view + string);
        stringBuffer.append("m_createdUserID: " + this.m_createdUserID + string);
        stringBuffer.append("m_createdTime: " + this.m_createdTime + string);
        stringBuffer.append("m_itemStore: " + this.m_server + string);
        stringBuffer.append("m_comment: " + this.m_comment + string);
        stringBuffer.append("m_parent: " + string + Indent.withTabs(this.m_parent.toDebugString(), 1) + string);
        stringBuffer.append("m_child: " + string + Indent.withTabs(this.m_child.toDebugString(), 1));
        return stringBuffer.toString();
    }

    Link(Item item, Server server, View view) {
        this.m_parentItem = item;
        this.m_server = server;
        this.m_view = view;
    }

    public Link(Item item, Item item2) {
        this(item, -1, item2, -1);
    }

    public Link(Item item, int n, Item item2, int n2) {
        this.m_server = item.getServer();
        this.m_view = item.getView();
        this.m_parentItem = item;
        this.m_childItem = item2;
        this.m_nFirstParentRevision = n;
        this.m_nFirstChildRevision = n2;
        int n3 = n == -1 ? -1 : item.getObjectID();
        String string = EMPTY;
        this.m_parent = new LinkEndpoint(this, item.getType(), item.getItemID(), n3, -1, string, item.getView().getViewID(), this.getParentFolderID(item));
        int n4 = n2 == -1 ? -1 : item2.getObjectID();
        String string2 = EMPTY;
        this.m_child = new LinkEndpoint(this, item2.getType(), item2.getItemID(), n4, -1, string2, item2.getView().getViewID(), this.getParentFolderID(item2));
    }

    public Link(Item item, boolean bl, Item item2, boolean bl2, String string) {
        this(item, -1, item2, -1);
        if (!string.equals(EMPTY)) {
            this.setComment(string);
        }
        if (bl) {
            this.pinParent(item);
        }
        if (bl2) {
            this.pinChild(item2);
        }
    }
}

