/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.borland.starteam.util.Encoding;
import com.starbase.starteam.Keyword;
import com.starbase.util.Assert;
import com.starbase.util.LineProcessor;
import com.starbase.util.LineReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;

public class KeywordReader
extends LineProcessor {
    private static final String EMPTY_STRING = "";
    private Keyword[] m_keywords = null;
    private boolean m_expand = true;
    private boolean m_keepprocessing;
    private Keyword m_currentMultiLineKeyword = null;
    private String m_multiLinePrefix = null;
    private String m_multiLineEOL = null;
    private Vector m_lookAhead = null;
    private String m_encoding = null;

    public Reader endofInput() throws IOException {
        if (this.m_currentMultiLineKeyword != null && this.m_lookAhead != null) {
            this.abandonLookAhead();
            this.m_currentMultiLineKeyword = null;
            return new StringReader(EMPTY_STRING);
        }
        return null;
    }

    private void abandonLookAhead() {
        Enumeration enumeration = this.m_lookAhead.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)enumeration.nextElement();
            this.pushBack(string, n);
        }
        this.m_lookAhead = null;
        this.m_multiLinePrefix = null;
        this.m_multiLineEOL = null;
        this.m_currentMultiLineKeyword = null;
    }

    private Keyword findMatchingKeyword(String string, int n, int[] nArray) {
        Keyword[] keywordArray = this.m_keywords;
        Keyword keyword = null;
        Keyword keyword2 = null;
        int n2 = keywordArray.length;
        int n3 = 0;
        while (n3 < n2) {
            keyword = keywordArray[n3];
            if (keyword.matches(string, n, nArray)) {
                keyword2 = keyword;
                break;
            }
            ++n3;
        }
        return keyword2;
    }

    private boolean isMultiLineEnd(String string) {
        return string.length() > this.m_multiLinePrefix.length() && string.startsWith(this.m_multiLinePrefix) && string.charAt(this.m_multiLinePrefix.length()) == '$';
    }

    private boolean legalMultiLine(String string) {
        boolean bl = string.length() > this.m_multiLinePrefix.length() && string.startsWith(this.m_multiLinePrefix);
        return bl;
    }

    private int finishMultiLine(StringBuffer stringBuffer) throws IOException {
        this.expandToBuffer(this.m_currentMultiLineKeyword.expand(this.m_multiLinePrefix, this.m_multiLineEOL, this.m_expand), stringBuffer);
        int n = this.m_multiLinePrefix.length() + 1;
        this.m_lookAhead = null;
        this.m_multiLinePrefix = null;
        this.m_multiLineEOL = null;
        this.m_currentMultiLineKeyword = null;
        return n;
    }

    private void saveMultiLine(String string, int n) {
        if (this.m_lookAhead == null) {
            this.m_lookAhead = new Vector();
        }
        this.m_lookAhead.addElement(string);
        this.m_lookAhead.addElement(new Integer(n));
    }

    private void startMultiLine(Keyword keyword, String string, String string2, String string3, int n) {
        this.m_multiLinePrefix = string;
        this.m_multiLineEOL = string2;
        this.m_currentMultiLineKeyword = keyword;
        this.saveMultiLine(string3, n);
    }

    private boolean doingMultiLine() {
        return this.m_currentMultiLineKeyword != null;
    }

    public Reader processLine(String string, int n) throws IOException {
        int n2 = -1;
        int n3 = 0;
        int n4 = string.length();
        int[] nArray = new int[1];
        String string2 = this.getEOLString(n);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (this.doingMultiLine()) {
            if (this.isMultiLineEnd(string)) {
                n3 = this.finishMultiLine(stringBuffer);
            } else {
                if (!this.legalMultiLine(string)) {
                    this.saveMultiLine(string, n);
                    this.abandonLookAhead();
                    return new StringReader(EMPTY_STRING);
                }
                this.saveMultiLine(string, n);
                return new StringReader(EMPTY_STRING);
            }
        }
        String string3 = null;
        boolean bl = false;
        while (this.m_keepprocessing && n3 < n4) {
            n2 = string.indexOf(36, n3);
            if (n2 == -1) break;
            stringBuffer.append(string.substring(n3, n2 + 1));
            Keyword keyword = this.findMatchingKeyword(string, n2, nArray);
            n3 = n2 + 1;
            if (keyword == null) continue;
            if (bl && keyword.multiLine()) break;
            string3 = string.substring(0, n2);
            if (keyword.multiLine() && nArray[0] == -1) {
                this.startMultiLine(keyword, string3, string2, string.substring(n3), n);
                break;
            }
            this.expandToBuffer(keyword.expand(string3, string2, this.m_expand), stringBuffer);
            this.m_keepprocessing = !keyword.stopExpanding();
            n3 = nArray[0] + 1;
            bl = true;
        }
        if (!this.doingMultiLine()) {
            if (n3 < n4) {
                stringBuffer.append(string.substring(n3));
            }
            stringBuffer.append(string2);
        }
        return new StringReader(stringBuffer.toString());
    }

    private String getEOLString(int n) {
        switch (n) {
            case -1: {
                Assert.internalError("KeywordReader.getEOLString(), lastEOL=EOL_UNKNOWN");
                return null;
            }
            case 0: {
                return "\r";
            }
            case 1: {
                return "\n";
            }
            case 2: {
                return "\r\n";
            }
            case 3: {
                return EMPTY_STRING;
            }
        }
        Assert.internalError("KeywordReader.getEOLString(), lastEOL=" + n);
        return null;
    }

    private void expandToBuffer(String string, StringBuffer stringBuffer) throws IOException {
        byte[] byArray = string.getBytes(this.m_encoding);
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = (char)(byArray[n2] & 0xFF);
            stringBuffer.append(c);
            ++n2;
        }
    }

    private void setEncoding() {
        Encoding encoding = Encoding.getDefaultStarTeamEncoding();
        if (encoding == null) {
            Assert.internalError("KeywordReader.setEncoding(), encoding=null");
        }
        this.m_encoding = encoding.getName();
        if (encoding.isReadingSupported()) {
            this.m_encoding = encoding.getPlatformNameForReading();
        }
        if (this.m_encoding == null) {
            Assert.internalError("KeywordReader.setEncoding(), name=null");
        }
    }

    public KeywordReader(LineReader lineReader, Keyword[] keywordArray, boolean bl) throws IOException {
        super(lineReader);
        this.m_keywords = keywordArray;
        this.m_expand = bl;
        this.m_keepprocessing = true;
        this.m_currentMultiLineKeyword = null;
        this.m_lookAhead = null;
        this.setEncoding();
    }
}

