/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Item;
import com.starbase.starteam.Items;
import com.starbase.starteam.ListEnumerator;
import com.starbase.starteam.NamedCacheRef;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.Server;
import com.starbase.starteam.Type;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ItemList
implements Runnable,
Items {
    private Thread m_Thread = null;
    private Vector m_Items = new Vector();
    private String[] m_Properties = null;
    private boolean m_RunInBackground = false;
    private int m_ThreadStartFrom = -1;
    private int m_ChunkSize = 0;

    public void addItem(Item item) {
        this.m_Items.addElement(item);
    }

    public void removeItem(Item item) {
        this.m_Items.removeElement(item);
    }

    public void copyInto(ItemList itemList) {
        Enumeration enumeration = this.m_Items.elements();
        while (enumeration.hasMoreElements()) {
            itemList.addItem((Item)enumeration.nextElement());
        }
    }

    Item[] toArray() {
        Object[] objectArray = new Item[this.m_Items.size()];
        this.m_Items.copyInto(objectArray);
        return objectArray;
    }

    public int size() {
        return this.m_Items.size();
    }

    public Item getAt(int n) throws NoSuchPropertyException {
        Item item = (Item)this.m_Items.elementAt(n);
        if (!item.hasValues(this.m_Properties)) {
            this.getItemsFrom(n);
        }
        return item;
    }

    public void setAt(Item item, int n) throws NoSuchPropertyException {
        this.m_Items.setElementAt(item, n);
        if (!item.hasValues(this.m_Properties)) {
            this.getItemsFrom(n);
        }
    }

    public synchronized void swap(int n, int n2) {
        Object e = this.m_Items.elementAt(n);
        this.m_Items.setElementAt(this.m_Items.elementAt(n2), n);
        this.m_Items.setElementAt(e, n2);
    }

    public synchronized Enumeration elements() {
        return new ListEnumerator(this);
    }

    public void populateNow(String[] stringArray) throws NoSuchPropertyException {
        this.m_ChunkSize = -1;
        this.m_RunInBackground = false;
        this.m_Properties = stringArray;
        this.fetchChunk(0, this.m_ChunkSize);
    }

    public void populateAsNeeded(String[] stringArray, int n) throws NoSuchPropertyException {
        this.m_ChunkSize = n;
        this.m_RunInBackground = false;
        this.m_Properties = stringArray;
        this.fetchChunk(0, this.m_ChunkSize);
    }

    public void populateInBackground(String[] stringArray, int n) {
        this.m_ChunkSize = n;
        this.m_RunInBackground = true;
        this.m_Properties = stringArray;
        this.startThread();
    }

    public void startThread() {
        if (this.m_ChunkSize == 0) {
            this.m_ChunkSize = -1;
        }
        if (this.m_Thread == null) {
            this.m_Thread = new Thread(this);
            this.m_Thread.start();
        } else {
            this.m_Thread.resume();
        }
    }

    public void endThread() {
        if (this.m_Thread != null) {
            this.m_Thread.suspend();
        }
    }

    public void killThread() {
        if (this.m_Thread != null) {
            this.m_Thread.stop();
            this.m_Thread = null;
        }
    }

    private void getItemsFrom(int n) throws NoSuchPropertyException {
        if (this.m_RunInBackground) {
            this.m_ThreadStartFrom = n;
            this.startThread();
            Item item = (Item)this.m_Items.elementAt(n);
            while (!item.hasValues(this.m_Properties)) {
                Thread.currentThread();
                Thread.yield();
            }
        } else {
            this.fetchChunk(n, this.m_ChunkSize);
        }
    }

    private void fetchChunk(int n, int n2) throws NoSuchPropertyException {
        if (n2 == 0) {
            return;
        }
        Vector<Item> vector = new Vector<Item>();
        int n3 = n;
        int n4 = this.m_Items.size();
        int n5 = 0;
        int n6 = 0;
        int n7 = n2 <= 0 ? n4 : n2;
        while (n5 < n4 && n6 < n7) {
            Item item = (Item)this.m_Items.elementAt(n3);
            if (!item.hasValues(this.m_Properties)) {
                vector.addElement(item);
                ++n6;
            }
            ++n5;
            n3 = (n3 + 1) % n4;
        }
        this.fetchThisChunk(vector);
    }

    private void fetchThisChunk(Vector vector) throws NoSuchPropertyException {
        Object object;
        Object object2;
        Cloneable cloneable;
        NamedCacheRef namedCacheRef;
        Hashtable hashtable = new Hashtable();
        Enumeration<Object> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            namedCacheRef = (Item)enumeration.nextElement();
            cloneable = namedCacheRef.getType();
            object2 = hashtable.get(cloneable);
            if (object2 == null) {
                object = new Vector<Item>();
                hashtable.put(cloneable, object);
            } else {
                object = (Vector<Item>)object2;
            }
            ((Vector)object).addElement(namedCacheRef);
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            namedCacheRef = (Type)enumeration.nextElement();
            cloneable = new Hashtable();
            object2 = ((Vector)hashtable.get(namedCacheRef)).elements();
            while (object2.hasMoreElements()) {
                Vector<Object> vector2;
                object = (Item)object2.nextElement();
                Server server = ((Item)object).getServer();
                Object v = ((Hashtable)cloneable).get(server);
                if (v == null) {
                    vector2 = new Vector<Object>();
                    ((Hashtable)cloneable).put(server, vector2);
                } else {
                    vector2 = (Vector<Object>)v;
                }
                vector2.addElement(object);
            }
            object2 = ((Hashtable)cloneable).keys();
            while (object2.hasMoreElements()) {
                object = (Server)object2.nextElement();
                ((Server)object).populateValues((Vector)((Hashtable)cloneable).get(object), this.m_Properties);
            }
        }
    }

    public void run() {
        if (this.m_Thread == null) {
            return;
        }
        boolean bl = true;
        while (bl) {
            int n = -1;
            if (this.m_ThreadStartFrom == -1) {
                int n2 = this.m_Items.size();
                int n3 = 0;
                while (n3 < n2) {
                    Item item = (Item)this.m_Items.elementAt(n3);
                    if (!item.hasValues(this.m_Properties)) {
                        n = n3;
                        break;
                    }
                    ++n3;
                }
            } else {
                n = this.m_ThreadStartFrom;
                this.m_ThreadStartFrom = -1;
            }
            if (n == -1) {
                bl = false;
                continue;
            }
            this.fetchChunk(n, this.m_ChunkSize);
        }
        this.m_Thread = null;
    }
}

