/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Folder;
import com.starbase.starteam.GetMethods;
import com.starbase.starteam.Item;
import com.starbase.starteam.Query;
import com.starbase.starteam.Server;
import com.starbase.starteam.Task;
import com.starbase.starteam.View;
import com.starbase.util.Assert;
import java.util.Vector;

class GetMethods
implements Query.ParameterKeys {
    private static final GetMethod ITEMS_IN_FOLDER = new 1();
    private static final GetMethod LABELS_IN_VIEW = new 2();
    private static final GetMethod PROMOTIONMODEL_IN_VIEW = new 3();
    private static final GetMethod LINKS_FOR_ITEM = new 4();
    private static final GetMethod FOLDERS_IN_VIEW = new 5();
    private static final GetMethod ALL_USERS = new 6();
    private static final GetMethod VERSIONS = new 7();
    private static final GetMethod ALL_SCHEMAS = new 8();
    private static final GetMethod WORKRECORDS_FOR_TASK = new 9();
    private static final GetMethod DEPENDENCIES_OF_TASK = new 10();

    static Vector get(Server server, Query query) {
        GetMethod getMethod;
        Vector vector;
        if (server == null) {
            Assert.internalError("GetMethods.get(), server=null");
        }
        if (query == null) {
            Assert.internalError("GetMethods.get(), query=null");
        }
        if ((vector = (getMethod = GetMethods.methodFor(query, server)).execute(server, query)) == null) {
            Assert.internalError("GetMethods.get(), v=null");
        }
        return vector;
    }

    private static GetMethod methodFor(Query query, Server server) {
        if (query == null) {
            Assert.internalError("GetMethods.methodFor(), query=null");
        }
        GetMethod getMethod = null;
        if (query.getType().equals(Query.Types.BULK_CONTAINED_BY)) {
            Item item;
            String string;
            Vector vector = (Vector)query.getParameter(Query.ParameterKeys.CONTAINER_LIST);
            if (vector == null) {
                Assert.internalError("GetMethods.methodFor(), containers=null");
            }
            if (vector.size() > 0 && vector.elementAt(0) instanceof Folder && (string = (item = (Item)vector.elementAt(0)).getType().getName()).equals(server.getTypeNames().FOLDER)) {
                getMethod = ITEMS_IN_FOLDER;
            }
        } else if (query.getType().equals(Query.Types.CONTAINED_BY)) {
            String string = (String)query.getParameter(Query.ParameterKeys.TYPE);
            Object object = query.getParameter(Query.ParameterKeys.CONTAINER);
            if (string.equals(server.getTypeNames().LABEL) && object instanceof View) {
                getMethod = LABELS_IN_VIEW;
            } else if (string.equals(server.getTypeNames().PROMOTIONMODEL) && object instanceof View) {
                getMethod = PROMOTIONMODEL_IN_VIEW;
            } else if (string.equals(server.getTypeNames().LINK) && object instanceof Item) {
                getMethod = LINKS_FOR_ITEM;
            } else if (string.equals(server.getTypeNames().FOLDER) && object instanceof View) {
                getMethod = FOLDERS_IN_VIEW;
            } else if (string.equals(server.getTypeNames().WORKRECORD) && object instanceof Task) {
                getMethod = WORKRECORDS_FOR_TASK;
            } else if (string.equals(server.getTypeNames().TASKDEPENDENCY) && object instanceof Task) {
                getMethod = DEPENDENCIES_OF_TASK;
            }
        } else if (query.getType().equals(Query.Types.ALL_OF_TYPE)) {
            String string = (String)query.getParameter(Query.ParameterKeys.TYPE);
            if (string.equals(server.getTypeNames().TYPE)) {
                getMethod = ALL_SCHEMAS;
            } else if (string.equals(server.getTypeNames().USER)) {
                getMethod = ALL_USERS;
            }
        } else if (query.getType().equals(Query.Types.VERSIONS_OF)) {
            Object object = query.getParameter(Query.ParameterKeys.VERSIONED_OBJECT);
            if (!(object instanceof Item)) {
                Assert.internalError("GetMethods.methodFor(), !instance(item)");
            }
            getMethod = VERSIONS;
        }
        if (getMethod == null) {
            Assert.internalError("GetMethods.methodFor(), method=null");
        }
        return getMethod;
    }

    private static boolean hasViewIDProperty(Item item) {
        return item.getType().hasPropertyForName(item.getPropertyNames().VIEW_ID);
    }

    static /* synthetic */ boolean access$0(Item item) {
        return GetMethods.hasViewIDProperty(item);
    }

    GetMethods() {
    }

    private static interface GetMethod {
        public Vector execute(Server var1, Query var2);
    }
}

