/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import System.Exception;
import com.starbase.starteam.Folder;
import com.starbase.starteam.FolderEventScope;
import com.starbase.starteam.FolderTreeEvent;
import com.starbase.starteam.FolderTreeListener;
import com.starbase.starteam.Folder_Cache;
import com.starbase.starteam.MPXEventMarshalerImpl;
import com.starbase.starteam.MPXFolderHierarchyEvent;
import com.starbase.starteam.MPXFolderHierarchyEvent_Marshaler;
import com.starbase.starteam.MPXFolderHierarchyEvent_Source;
import com.starbase.starteam.ServerException;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewAdapter;
import com.starbase.starteam.ViewEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class FolderTreeEvent_Marshaler
extends MPXEventMarshalerImpl
implements MPXFolderHierarchyEvent_Marshaler {
    private View m_view = null;
    private MPXFolderHierarchyEvent_Source m_source = null;
    private Vector m_listeners = new Vector();
    private Folder m_root = null;
    private Hashtable m_folders = new Hashtable();

    public synchronized void addListener(FolderTreeListener folderTreeListener, FolderEventScope folderEventScope) {
        FolderTreeEvent_Marshaler folderTreeEvent_Marshaler = this;
        if (folderTreeEvent_Marshaler == null) {
            throw null;
        }
        this.m_listeners.addElement(folderTreeEvent_Marshaler.new MyListener(folderTreeListener, folderEventScope));
        if (this.m_listeners.size() == 1) {
            this.m_source.addMPXFolderHierarchyEventMarshaler(this);
            this.getEventQueue().start();
            this.refreshFolders();
        }
    }

    public synchronized void removeListener(FolderTreeListener folderTreeListener, FolderEventScope folderEventScope) {
        if (this.m_listeners.size() == 0) {
            return;
        }
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            MyListener myListener = (MyListener)enumeration.nextElement();
            if (myListener.m_listener != folderTreeListener || folderEventScope == null != (myListener.m_scope == null) || folderEventScope != null && !folderEventScope.isEqualTo(myListener.m_scope)) continue;
            this.m_listeners.removeElement(myListener);
            break;
        }
        if (this.m_listeners.size() == 0) {
            this.getEventQueue().stop();
            this.m_source.removeMPXFolderHierarchyEventMarshaler(this);
        }
    }

    private synchronized void removeAll() {
        this.m_listeners.setSize(0);
        this.removeListener(null, null);
    }

    public synchronized void handleMPXFolderHierarchyEvent(MPXFolderHierarchyEvent mPXFolderHierarchyEvent) {
        if (this.m_view.getServer().isConnected() && this.m_listeners.size() > 0) {
            Folder folder;
            if (!mPXFolderHierarchyEvent.isDeleteViewEvent()) {
                try {
                    this.refreshFolders();
                }
                catch (ServerException serverException) {
                    // empty catch block
                }
            }
            if ((folder = this.findFolder(mPXFolderHierarchyEvent.getFolderID())) != null) {
                FolderTreeEvent folderTreeEvent = new FolderTreeEvent(folder);
                Enumeration enumeration = this.m_listeners.elements();
                while (enumeration.hasMoreElements()) {
                    MyListener myListener = (MyListener)enumeration.nextElement();
                    if (!myListener.isListener(folderTreeEvent)) continue;
                    FolderTreeListener folderTreeListener = myListener.m_listener;
                    try {
                        try {
                            if (folderTreeListener instanceof FolderTreeListenerEx) {
                                if (mPXFolderHierarchyEvent.isCreateViewEvent()) {
                                    ((FolderTreeListenerEx)folderTreeListener).rootFolderCreated(folderTreeEvent);
                                    continue;
                                }
                                if (mPXFolderHierarchyEvent.isDeleteViewEvent()) {
                                    ((FolderTreeListenerEx)folderTreeListener).rootFolderDeleted(folderTreeEvent);
                                    continue;
                                }
                                folderTreeListener.folderTreeChanged(folderTreeEvent);
                                continue;
                            }
                            folderTreeListener.folderTreeChanged(folderTreeEvent);
                        }
                        catch (Throwable throwable) {
                            this.onUncaughtEventHandlerException(throwable);
                        }
                    }
                    catch (Exception exception) {
                        this.onUncaughtEventHandlerException(exception);
                    }
                }
            }
        }
    }

    void refreshFolders() {
        Folder_Cache folder_Cache = this.m_view.getFolderCache();
        Vector vector = new Vector();
        if (this.m_root != null) {
            Folder.flattenFolderTree(this.m_root, vector, -1);
        }
        folder_Cache.refreshItems(this.m_view, vector);
        this.m_root = (Folder)vector.elementAt(0);
        this.m_folders.clear();
        this.rehashFolders(this.m_root);
    }

    private void rehashFolders(Folder folder) {
        Integer n = new Integer(folder.getItemID());
        this.m_folders.put(n, folder);
        Folder[] folderArray = folder.getSubFolders();
        int n2 = 0;
        while (n2 < folderArray.length) {
            this.rehashFolders(folderArray[n2]);
            ++n2;
        }
    }

    Folder getRootFolder() {
        return this.m_root;
    }

    Folder findFolder(int n) {
        return (Folder)this.m_folders.get(new Integer(n));
    }

    static /* synthetic */ void access$0(FolderTreeEvent_Marshaler folderTreeEvent_Marshaler) {
        folderTreeEvent_Marshaler.removeAll();
    }

    public FolderTreeEvent_Marshaler(View view) {
        super(view.getServer());
        this.m_view = view;
        this.m_source = this.m_view.getViewConfigCacheManager().getFolderCacheManager();
        FolderTreeEvent_Marshaler folderTreeEvent_Marshaler = this;
        if (folderTreeEvent_Marshaler == null) {
            throw null;
        }
        this.m_view.addViewListener(new ViewAdapter(folderTreeEvent_Marshaler){
            private final /* synthetic */ FolderTreeEvent_Marshaler this$0;

            public void viewDeleted(ViewEvent viewEvent) {
                FolderTreeEvent_Marshaler.access$0(this.this$0);
            }
            {
                this.this$0 = folderTreeEvent_Marshaler;
                this.constructor$0(folderTreeEvent_Marshaler);
            }

            private final void constructor$0(FolderTreeEvent_Marshaler folderTreeEvent_Marshaler) {
            }
        });
    }

    private class MyListener {
        public FolderTreeListener m_listener = null;
        public FolderEventScope m_scope = null;

        public boolean isListener(FolderTreeEvent folderTreeEvent) {
            return this.m_scope == null || this.m_scope.isMyEvent(folderTreeEvent.getFolder());
        }

        MyListener(FolderTreeListener folderTreeListener, FolderEventScope folderEventScope) {
            this.m_listener = folderTreeListener;
            this.m_scope = folderEventScope;
        }
    }

    static interface FolderTreeListenerEx
    extends FolderTreeListener {
        public void rootFolderCreated(FolderTreeEvent var1);

        public void rootFolderDeleted(FolderTreeEvent var1);
    }
}

