/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import System.Exception;
import com.starbase.starteam.Folder;
import com.starbase.starteam.FolderEvent;
import com.starbase.starteam.FolderEventScope;
import com.starbase.starteam.FolderListener;
import com.starbase.starteam.FolderTreeEvent;
import com.starbase.starteam.FolderTreeEvent_Marshaler;
import com.starbase.starteam.FolderTreeListener;
import com.starbase.starteam.Folder_Cache;
import com.starbase.starteam.Item_Data;
import com.starbase.starteam.MPXEventMarshalerImpl;
import com.starbase.starteam.MPXItemEvent_Marshaler;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerException;
import com.starbase.starteam.Type;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewAdapter;
import com.starbase.starteam.ViewEvent;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class FolderEvent_Marshaler
extends MPXEventMarshalerImpl
implements FolderTreeListener,
FolderTreeEvent_Marshaler.FolderTreeListenerEx,
MPXItemEvent_Marshaler {
    private View m_view = null;
    private FolderTreeEvent_Marshaler m_source = null;
    private Folder_Cache m_items = null;
    private BitSet m_bits = null;
    private Vector m_listeners = new Vector();
    Folder m_root = null;
    Hashtable m_folders = new Hashtable();

    public synchronized void addListener(FolderListener folderListener, FolderEventScope folderEventScope) {
        FolderEvent_Marshaler folderEvent_Marshaler = this;
        if (folderEvent_Marshaler == null) {
            throw null;
        }
        this.m_listeners.addElement(folderEvent_Marshaler.new MyListener(folderListener, folderEventScope));
        if (this.m_listeners.size() == 1) {
            this.m_source.addListener(this, null);
            this.m_items.addMPXItemEventMarshaler(this);
            this.initFolders();
            this.getEventQueue().start();
        }
    }

    public synchronized void removeListener(FolderListener folderListener, FolderEventScope folderEventScope) {
        if (this.m_listeners.size() == 0) {
            return;
        }
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            MyListener myListener = (MyListener)enumeration.nextElement();
            if (myListener.m_listener != folderListener || folderEventScope == null != (myListener.m_scope == null) || folderEventScope != null && !folderEventScope.isEqualTo(myListener.m_scope)) continue;
            this.m_listeners.removeElement(myListener);
            break;
        }
        if (this.m_listeners.size() == 0) {
            this.getEventQueue().stop();
            this.m_source.removeListener(this, null);
            this.m_items.removeMPXItemEventMarshaler(this);
        }
    }

    private synchronized void removeAll() {
        this.m_listeners.setSize(0);
        this.removeListener(null, null);
    }

    public synchronized void rootFolderCreated(FolderTreeEvent folderTreeEvent) {
        this.initFolders(null);
        this.onFolderAdded(folderTreeEvent.getFolder());
        this.folderTreeChanged(folderTreeEvent);
    }

    public synchronized void rootFolderDeleted(FolderTreeEvent folderTreeEvent) {
        this.onRemoveAllFolders(this.m_root);
    }

    private void onRemoveAllFolders(Folder folder) {
        if (folder != null) {
            Folder[] folderArray = folder.getSubFolders();
            int n = 0;
            while (n < folderArray.length) {
                this.onRemoveAllFolders(folderArray[n]);
                ++n;
            }
            this.onFolderRemoved(folder);
        }
    }

    public synchronized void folderTreeChanged(FolderTreeEvent folderTreeEvent) {
        Folder folder = folderTreeEvent.getFolder();
        this.diffFolderTree(folder);
        this.saveFolderTree(folder);
    }

    private void diffFolderTree(Folder folder) {
        this.findRemovedFolders(folder.getItemID());
        this.findAddedFolders(folder);
    }

    private void findRemovedFolders(int n) {
        Folder folder = this.findFolder(n);
        if (folder != null) {
            Folder[] folderArray = folder.getSubFolders();
            int n2 = 0;
            while (n2 < folderArray.length) {
                Folder folder2 = folderArray[n2];
                int n3 = folder2.getItemID();
                this.findRemovedFolders(n3);
                Folder folder3 = this.m_source.findFolder(n3);
                if (folder3 == null) {
                    this.onFolderRemoved(folder2);
                }
                ++n2;
            }
        }
    }

    private void onFolderRemoved(Folder folder) {
        FolderEvent folderEvent = new FolderEvent(folder, null);
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            MyListener myListener = (MyListener)enumeration.nextElement();
            if (!myListener.isListener(folderEvent)) continue;
            try {
                try {
                    myListener.m_listener.folderRemoved(folderEvent);
                }
                catch (Throwable throwable) {
                    this.onUncaughtEventHandlerException(throwable);
                }
            }
            catch (Exception exception) {
                this.onUncaughtEventHandlerException(exception);
            }
        }
    }

    private void findAddedFolders(Folder folder) {
        int n = folder.getItemID();
        Folder[] folderArray = folder.getSubFolders();
        int n2 = 0;
        while (n2 < folderArray.length) {
            Folder folder2 = folderArray[n2];
            Folder folder3 = this.findFolder(folder2.getItemID());
            if (folder3 != null) {
                if (folder3.getParentFolder() == null || folder3.getParentFolder().getItemID() != n) {
                    this.onFolderMoved(folder3, folder2);
                }
            } else {
                this.onFolderAdded(folder2);
            }
            this.findAddedFolders(folder2);
            ++n2;
        }
    }

    private void onFolderAdded(Folder folder) {
        FolderEvent folderEvent = new FolderEvent(null, folder);
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            MyListener myListener = (MyListener)enumeration.nextElement();
            if (!myListener.isListener(folderEvent)) continue;
            try {
                try {
                    myListener.m_listener.folderAdded(folderEvent);
                }
                catch (Throwable throwable) {
                    this.onUncaughtEventHandlerException(throwable);
                }
            }
            catch (Exception exception) {
                this.onUncaughtEventHandlerException(exception);
            }
        }
    }

    private void onFolderMoved(Folder folder, Folder folder2) {
        FolderEvent folderEvent = new FolderEvent(folder, folder2);
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            MyListener myListener = (MyListener)enumeration.nextElement();
            if (!myListener.isListener(folderEvent)) continue;
            try {
                try {
                    myListener.m_listener.folderMoved(folderEvent);
                }
                catch (Throwable throwable) {
                    this.onUncaughtEventHandlerException(throwable);
                }
            }
            catch (Exception exception) {
                this.onUncaughtEventHandlerException(exception);
            }
        }
    }

    public void handleMPXItemEvent(int n, Item_Data item_Data) {
        Folder folder = this.findFolder(n);
        if (folder != null) {
            Folder folder2 = (Folder)folder.copy();
            Folder folder3 = folder;
            if (item_Data != null) {
                folder.setCachedObject(item_Data);
            } else {
                try {
                    folder.refresh();
                }
                catch (ServerException serverException) {
                    // empty catch block
                }
            }
            FolderEvent folderEvent = new FolderEvent(folder2, folder3);
            Enumeration enumeration = this.m_listeners.elements();
            while (enumeration.hasMoreElements()) {
                MyListener myListener = (MyListener)enumeration.nextElement();
                if (!myListener.isListener(folderEvent)) continue;
                try {
                    try {
                        myListener.m_listener.folderChanged(folderEvent);
                    }
                    catch (Throwable throwable) {
                        this.onUncaughtEventHandlerException(throwable);
                    }
                }
                catch (Exception exception) {
                    this.onUncaughtEventHandlerException(exception);
                }
            }
        }
    }

    private void initFolders() {
        this.initFolders(this.m_source.getRootFolder());
    }

    private void initFolders(Folder folder) {
        this.m_folders.clear();
        this.m_root = null;
        if (folder != null) {
            this.saveFolderTree(folder);
        }
    }

    private void saveFolderTree(Folder folder) {
        Vector vector = new Vector();
        this.saveFolderTree(folder, vector);
        this.refreshProperties(vector);
    }

    private Folder saveFolderTree(Folder folder, Vector vector) {
        Folder folder2 = this.findFolder(folder.getItemID());
        if (folder2 == null) {
            folder2 = (Folder)folder.copy();
            this.m_folders.put(new Integer(folder.getItemID()), folder2);
            vector.addElement(folder2);
        }
        Folder[] folderArray = folder.getSubFolders();
        int n = folderArray.length;
        Folder[] folderArray2 = new Folder[n];
        int n2 = 0;
        while (n2 < n) {
            folderArray2[n2] = this.saveFolderTree(folderArray[n2], vector);
            ++n2;
        }
        folder2.setChildren(folderArray2);
        if (folder.getParentFolder() != null) {
            Folder folder3 = this.findFolder(folder.getParentFolder().getItemID());
            folder2.setParentFolder(folder3);
        } else {
            this.m_root = folder2;
        }
        return folder2;
    }

    public Folder getRootFolder() {
        return this.m_root;
    }

    public Folder findFolder(int n) {
        return (Folder)this.m_folders.get(new Integer(n));
    }

    void refreshProperties(Vector vector) {
        this.m_items.refreshProperties(this.m_view, vector, this.m_bits);
    }

    static /* synthetic */ void access$0(FolderEvent_Marshaler folderEvent_Marshaler) {
        folderEvent_Marshaler.removeAll();
    }

    public FolderEvent_Marshaler(View view) {
        super(view.getServer());
        this.m_view = view;
        this.m_source = this.m_view.getFolderTreeEventMarshaler();
        this.m_items = (Folder_Cache)this.m_view.getViewConfigCacheManager().getFolderCacheManager().getItemCache();
        Server server = this.m_view.getServer();
        String[] stringArray = new String[]{server.getPropertyNames().OBJECT_ID};
        Type type = server.typeForName(server.getTypeNames().FOLDER);
        this.m_bits = this.m_items.getBitsForPropertyNames(type, stringArray);
        FolderEvent_Marshaler folderEvent_Marshaler = this;
        if (folderEvent_Marshaler == null) {
            throw null;
        }
        this.m_view.addViewListener(new ViewAdapter(folderEvent_Marshaler){
            private final /* synthetic */ FolderEvent_Marshaler this$0;

            public void viewDeleted(ViewEvent viewEvent) {
                FolderEvent_Marshaler.access$0(this.this$0);
            }
            {
                this.this$0 = folderEvent_Marshaler;
                this.constructor$0(folderEvent_Marshaler);
            }

            private final void constructor$0(FolderEvent_Marshaler folderEvent_Marshaler) {
            }
        });
    }

    private class MyListener {
        public FolderListener m_listener = null;
        public FolderEventScope m_scope = null;

        public boolean isListener(FolderEvent folderEvent) {
            if (this.m_scope == null) {
                return true;
            }
            if (folderEvent.getNewFolder() != null && this.m_scope.isMyEvent(folderEvent.getNewFolder())) {
                return true;
            }
            return folderEvent.getOldFolder() != null && this.m_scope.isMyEvent(folderEvent.getOldFolder());
        }

        MyListener(FolderListener folderListener, FolderEventScope folderEventScope) {
            this.m_listener = folderListener;
            this.m_scope = folderEventScope;
        }
    }
}

