/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.BaseKeywords;
import com.starbase.starteam.IdentityReader;
import com.starbase.starteam.KeywordReader;
import com.starbase.util.BaseFileUtils;
import com.starbase.util.EOLReader;
import com.starbase.util.LineReader;
import com.starbase.util.MD5;
import com.starbase.util.StreamUtils;
import com.starbase.util.TextInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class FileStream {
    public static int computeSyncMD5(File file, MD5 mD5) throws IOException {
        return mD5.computeFileMD5(file);
    }

    public static int computeCompareMD5(File file, boolean bl, boolean bl2, MD5 mD5) throws IOException {
        InputStream inputStream = null;
        int n = 0;
        try {
            inputStream = FileStream.streamForCompareMD5(file, bl, bl2);
            n = StreamUtils.eatStream(inputStream, 1024, mD5);
        }
        finally {
            Object var7_6 = null;
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return n;
    }

    static InputStream streamForCompareMD5(File file, boolean bl, boolean bl2) throws IOException {
        boolean bl3 = BaseFileUtils.isBinary(file);
        FileInputStream fileInputStream = null;
        InputStream inputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStream = FileStream.streamToSend(fileInputStream, bl3, bl, bl2);
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                inputStream.close();
            }
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            throw iOException;
        }
        return inputStream;
    }

    static Sender getSender(File file, boolean bl, boolean bl2, boolean bl3) {
        File file2 = file;
        return new Sender(file2, bl, bl2, bl3){
            private final /* synthetic */ File val$myFile;

            public boolean isRetrySupported() {
                return true;
            }

            public void prepareForRetry() {
                this.close();
            }

            protected InputStream getSource() throws IOException {
                return new FileInputStream(this.val$myFile);
            }

            public void close() {
                if (this.m_stream != null) {
                    try {
                        this.m_stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.m_stream = null;
                }
            }
            {
                this.val$myFile = file;
                this.constructor$0(bl, bl2, bl3);
            }

            private final void constructor$0(boolean bl, boolean bl2, boolean bl3) {
            }
        };
    }

    static Sender getSender(InputStream inputStream, boolean bl, boolean bl2, boolean bl3) {
        InputStream inputStream2 = inputStream;
        return new Sender(inputStream2, bl, bl2, bl3){
            private boolean m_bStarted;
            private final /* synthetic */ InputStream val$mySource;

            public boolean isRetrySupported() {
                return !this.m_bStarted;
            }

            public void prepareForRetry() {
            }

            protected InputStream getSource() throws IOException {
                this.m_bStarted = true;
                return this.val$mySource;
            }

            public void close() {
            }
            {
                this.val$mySource = inputStream;
                this.m_bStarted = false;
                this.constructor$0(bl, bl2, bl3);
            }

            private final void constructor$0(boolean bl, boolean bl2, boolean bl3) {
            }
        };
    }

    private static InputStream streamToSend(InputStream inputStream, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (bl) {
            bl2 = false;
            bl3 = false;
        }
        if (!bl3 && !bl2) {
            return inputStream;
        }
        Reader reader = new IdentityReader(inputStream);
        if (bl3) {
            reader = new EOLReader(new LineReader(reader), "\r\n");
        }
        if (bl2) {
            reader = new KeywordReader(new LineReader(reader), new BaseKeywords().getKeywords(), false);
        }
        return new TextInputStream(reader);
    }

    static abstract class Sender {
        private final boolean m_bIsBinary;
        private final boolean m_bUsesKeywords;
        private final boolean m_bConvertEOL;
        protected InputStream m_stream = null;

        public InputStream getStream() throws IOException {
            if (this.m_stream == null) {
                InputStream inputStream = this.getSource();
                this.m_stream = FileStream.streamToSend(inputStream, this.m_bIsBinary, this.m_bUsesKeywords, this.m_bConvertEOL);
            }
            return this.m_stream;
        }

        public abstract boolean isRetrySupported();

        public abstract void prepareForRetry();

        protected abstract InputStream getSource() throws IOException;

        public abstract void close();

        public Sender(boolean bl, boolean bl2, boolean bl3) {
            this.m_bIsBinary = bl;
            this.m_bUsesKeywords = bl2;
            this.m_bConvertEOL = bl3;
        }
    }
}

