/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CmdGetEventHandlerProfileNames;
import com.starbase.starteam.CmdGetEventHandlerProps;
import com.starbase.starteam.CmdSetEventHandlerProps;
import com.starbase.starteam.EventHandlerProfile;
import com.starbase.starteam.NamedPropertyValues;
import com.starbase.starteam.Server;
import java.util.Hashtable;

public class EventHandlerInfo {
    public static final String MPX_TRANSMITTER = "StarbaseMPX Transmitter";
    private static String[] m_emptyPropertyNames = new String[0];
    Hashtable m_namedDescriptions = null;
    Server m_server = null;
    NamedPropertyValues m_pv = null;
    private boolean m_bLoaded = false;

    Server getServer() {
        return this.m_server;
    }

    void load() {
        if (!this.m_bLoaded) {
            EventHandlerInfo eventHandlerInfo = this;
            synchronized (eventHandlerInfo) {
                if (!this.m_bLoaded) {
                    CmdGetEventHandlerProps cmdGetEventHandlerProps = new CmdGetEventHandlerProps(this.getServer(), this.getName(), m_emptyPropertyNames);
                    cmdGetEventHandlerProps.execute();
                    this.m_pv.setPropertyValues(cmdGetEventHandlerProps.getPropertyValues());
                    this.m_bLoaded = true;
                }
            }
        }
    }

    public void update() {
        this.load();
        CmdSetEventHandlerProps cmdSetEventHandlerProps = new CmdSetEventHandlerProps(this.getServer(), this.getName(), this.m_pv.getPropertyValues());
        cmdSetEventHandlerProps.execute();
    }

    public String[] getProfileNames() {
        CmdGetEventHandlerProfileNames cmdGetEventHandlerProfileNames = new CmdGetEventHandlerProfileNames(this.getServer(), this.getName());
        cmdGetEventHandlerProfileNames.execute();
        this.m_namedDescriptions = new Hashtable();
        String[] stringArray = cmdGetEventHandlerProfileNames.getNames();
        String[] stringArray2 = cmdGetEventHandlerProfileNames.getDescriptions();
        int n = 0;
        while (n < stringArray.length) {
            this.m_namedDescriptions.put(stringArray[n], stringArray2[n]);
            ++n;
        }
        return stringArray;
    }

    public EventHandlerProfile getProfile(String string) {
        if (this.m_namedDescriptions == null) {
            this.getProfileNames();
        }
        if (this.m_namedDescriptions.containsKey(string)) {
            return new EventHandlerProfile(this, string, (String)this.m_namedDescriptions.get(string));
        }
        return null;
    }

    public void addProfile(EventHandlerProfile eventHandlerProfile) {
        eventHandlerProfile.setEventHandlerInfo(this);
        eventHandlerProfile.update();
        this.clearProfileList();
    }

    public void deleteProfile(EventHandlerProfile eventHandlerProfile) {
        eventHandlerProfile.remove();
        this.clearProfileList();
    }

    void clearProfileList() {
        this.m_namedDescriptions = null;
    }

    public String getName() {
        return this.m_pv.getName();
    }

    public String getDescription() {
        return this.m_pv.getDescription();
    }

    public void setDescription(String string) {
        this.m_pv.setDescription(string);
    }

    public String[] getPropertyNames() {
        this.load();
        return this.m_pv.getPropertyNames();
    }

    public Object getProperty(String string) {
        this.load();
        return this.m_pv.getProperty(string);
    }

    public Object putProperty(String string, Object object) {
        this.load();
        return this.m_pv.putProperty(string, object);
    }

    public Object removeProperty(String string) {
        this.load();
        return this.m_pv.removeProperty(string);
    }

    public String toString() {
        this.load();
        String string = "Server: " + this.getServer().getAddress();
        string = string + ", " + this.m_pv.toString();
        return string;
    }

    EventHandlerInfo(Server server, String string, String string2) {
        this.m_pv = new NamedPropertyValues(string, string2);
        this.m_server = server;
    }
}

