/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.FileStream;
import com.starbase.starteam.Item;
import com.starbase.starteam.Property;
import com.starbase.starteam.SyncUpdateType;
import com.starbase.starteam.TypedResource_Marshaler;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandMacro;
import com.starbase.starteam.vts.comm.CommandRoute;
import com.starbase.starteam.vts.comm.SystemRevisionNumbers;
import com.starbase.starteam.vts.pickle.Delta;
import com.starbase.starteam.vts.pickle.FileRevisionID;
import com.starbase.starteam.vts.pickle.ItemRevision;
import com.starbase.starteam.vts.pickle.KeywordValues;
import com.starbase.starteam.vts.pickle.StStatusData;
import com.starbase.util.GUID;
import com.starbase.util.MD5;
import com.starbase.util.OLEDate;
import java.io.IOException;

class CmdFileCheckin
extends CommandMacro {
    private static final CommandRoute m_route = new CommandRoute(Integer.MIN_VALUE, 524288, 2004, "PROJ_CMD_UPDATE_ITEM");
    private boolean m_forceCheckin = true;
    private Item m_fileItem = null;
    private String m_reason = null;
    private FileStream.Sender m_sender = null;
    private int m_LockStatus = 0;
    private Property[] m_UnsavedProperties;
    private boolean m_getKeywords = true;
    private int m_labelID = -1;
    private SyncUpdateType m_syncUpdateType = null;
    private boolean m_caseSensitive = false;
    private int m_destID = -1;
    private double m_syncTime = 0.0;
    private int m_syncSize = 0;
    private MD5 m_syncMD5 = new MD5();
    private StStatusData m_statusData = null;
    private KeywordValues m_keywordValues = null;
    private ItemRevision[] m_history = null;
    private TypedResource_Marshaler m_marshaler;
    private GUID m_serverID;
    private FileRevisionID m_syncRevisionID = null;
    private boolean m_locallyModified = false;

    public StStatusData getStatusData() {
        return this.m_statusData;
    }

    public KeywordValues getKeywordValues() {
        return this.m_keywordValues;
    }

    public ItemRevision[] getHistory() {
        return this.m_history;
    }

    protected boolean isRetrySupported() {
        return this.isRetrySupportedForEditCommand() && this.m_sender.isRetrySupported();
    }

    protected void prepareForRetry() {
        this.m_sender.prepareForRetry();
    }

    protected void push(Command command) throws IOException {
        command.writeInt(0);
        command.writeInt(this.m_fileItem.getItemID());
        command.writeInt(-1);
        this.m_marshaler.writeItemProperties(this.m_fileItem, this.m_UnsavedProperties, command);
        command.writeString(this.m_reason);
        OLEDate oLEDate = this.m_fileItem.getSnapshotTime();
        command.writeTime(oLEDate.getDoubleValue());
        command.writeInt(102);
        command.writeBoolean(this.m_forceCheckin);
        if (SystemRevisionNumbers.isClientManagedStatus(command.getRevisionLevel())) {
            this.m_syncRevisionID.writeGuts(command);
            command.writeBoolean(this.m_locallyModified);
        }
        command.writeInt(this.m_LockStatus);
        command.writeInt(this.m_labelID);
        if (!SystemRevisionNumbers.isClientManagedStatus(command.getRevisionLevel())) {
            command.writeInt(this.m_syncUpdateType.getCode());
            if (this.m_syncUpdateType == SyncUpdateType.UPDATE) {
                command.writeTime(this.m_syncTime);
                command.writeInt(this.m_syncSize);
                command.writeMD5(this.m_syncMD5);
            }
            command.writeBoolean(this.m_caseSensitive);
            command.writeInt(this.m_destID);
            command.writeBoolean(true);
        }
        command.writeBoolean(this.m_getKeywords);
        command.writeFileStream(this.m_sender.getStream());
    }

    protected void pop(Command command) throws IOException {
        command.readInt();
        double d = command.readTime();
        this.m_fileItem.setSnapshotTime(new OLEDate(d));
        if (SystemRevisionNumbers.isClientManagedStatus(command.getRevisionLevel())) {
            this.m_marshaler.readItem(this.m_fileItem, command);
        }
        if (!SystemRevisionNumbers.isClientManagedStatus(command.getRevisionLevel()) && this.m_syncUpdateType == SyncUpdateType.UPDATE) {
            this.m_statusData = StStatusData.read(this.m_serverID, command);
        }
        if (this.m_getKeywords) {
            this.m_keywordValues = KeywordValues.read(command);
            int n = command.readInt();
            ItemRevision[] itemRevisionArray = new ItemRevision[n];
            int n2 = 0;
            while (n2 < n) {
                itemRevisionArray[n2] = ItemRevision.read(command);
                ++n2;
            }
            this.m_history = itemRevisionArray;
        }
        Delta delta = Delta.readFromWire(command);
        if (delta.m_changes.length != 0) {
            // empty if block
        }
    }

    protected CommandRoute getCommandRoute() {
        return m_route;
    }

    public CmdFileCheckin(Item item, String string, FileStream.Sender sender, int n, Property[] propertyArray, boolean bl, int n2, SyncUpdateType syncUpdateType, int n3, boolean bl2, double d, int n4, MD5 mD5, boolean bl3, TypedResource_Marshaler typedResource_Marshaler, GUID gUID, FileRevisionID fileRevisionID, boolean bl4) {
        this.m_serverID = gUID;
        this.m_forceCheckin = bl;
        this.m_marshaler = typedResource_Marshaler;
        this.m_fileItem = item;
        this.m_reason = string;
        this.m_syncTime = d;
        this.m_syncSize = n4;
        this.m_syncMD5 = mD5;
        this.m_destID = n3;
        this.m_caseSensitive = bl2;
        this.m_getKeywords = bl3;
        this.m_sender = sender;
        this.m_LockStatus = n;
        this.m_UnsavedProperties = propertyArray;
        this.m_labelID = n2;
        this.m_syncUpdateType = syncUpdateType;
        this.m_syncRevisionID = fileRevisionID;
        this.m_locallyModified = bl4;
    }
}

