/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import System.Exception;
import com.starbase.starteam.File;
import com.starbase.starteam.SDKRuntimeException;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandMacro;
import com.starbase.starteam.vts.comm.CommandRoute;
import com.starbase.starteam.vts.comm.Connection;
import com.starbase.starteam.vts.pickle.CheckoutRequest;
import com.starbase.starteam.vts.pickle.FileRevisionID;
import com.starbase.starteam.vts.pickle.ItemRevision;
import com.starbase.starteam.vts.pickle.KeywordValues;
import com.starbase.starteam.vts.pickle.StStatusData;
import com.starbase.util.Assert;
import com.starbase.util.GUID;
import com.starbase.util.MD5;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;

class CmdCheckOutInputStream
extends CommandMacro {
    private static final CommandRoute m_route = new CommandRoute(Integer.MIN_VALUE, 0, 10104, "FILE_CMD_CHECKOUT");
    private byte[] tmp = new byte[1];
    private Connection m_conn;
    private GUID m_auth;
    private int m_viewState;
    private int m_target;
    private Connection m_connection = null;
    private Command m_Cmd = null;
    private CheckoutRequest m_Request = null;
    private double m_FileTime = 0.0;
    private boolean m_fileExecutable = false;
    private StStatusData m_statusData = null;
    private FileRevisionID m_revisionID = null;
    private MD5 m_fileMD5 = null;
    private MD5 m_syncMD5 = null;
    InputStream m_fileStream = null;
    private boolean m_Started = false;
    private boolean m_Done = false;
    private File m_file = null;
    private KeywordValues m_keywordValues = null;
    private ItemRevision[] m_history = null;
    private Hashtable m_userMap;
    private Hashtable m_viewMap;
    private int m_exclusiveLockerID = -1;
    private int m_myLockState = -1;
    private int m_storageType = -1;

    protected boolean isRetrySupported() {
        return false;
    }

    public double getFileTime() {
        return this.m_FileTime;
    }

    public boolean getFileExecutable() {
        return this.m_fileExecutable;
    }

    public StStatusData getStatusData() {
        return this.m_statusData;
    }

    public FileRevisionID getFileRevisionID() {
        return this.m_revisionID;
    }

    public MD5 getFileMD5() {
        return this.m_fileMD5;
    }

    public MD5 getSyncMD5() {
        return this.m_syncMD5;
    }

    public KeywordValues getKeywordValues() {
        return this.m_keywordValues;
    }

    public ItemRevision[] getHistory() {
        return this.m_history;
    }

    public Hashtable getUserMap() {
        return this.m_userMap;
    }

    public Hashtable getViewMap() {
        return this.m_viewMap;
    }

    int getExclusiveLockerID() {
        return this.m_exclusiveLockerID;
    }

    int getMyLockState() {
        return this.m_myLockState;
    }

    private void initialize() throws IOException {
        block13: {
            this.m_connection.usingCommand(this.getClass().getName());
            this.m_Cmd = this.prepare(this.m_conn, this.m_auth, this.m_viewState, this.m_target);
            this.push(this.m_Cmd);
            this.m_connection.execCommand(this.m_Cmd);
            if (this.m_Request.getGetKeywords()) {
                this.m_keywordValues = KeywordValues.read(this.m_Cmd);
                int n = this.m_Cmd.readInt();
                ItemRevision[] itemRevisionArray = new ItemRevision[n];
                int n2 = 0;
                while (n2 < n) {
                    itemRevisionArray[n2] = ItemRevision.read(this.m_Cmd);
                    ++n2;
                }
                this.m_history = itemRevisionArray;
                this.m_userMap = new Hashtable();
                this.m_viewMap = new Hashtable();
                if (this.m_Cmd.getRevisionLevel() >= 51) {
                    String string;
                    int n3;
                    n = this.m_Cmd.readInt();
                    n2 = 0;
                    while (n2 < n) {
                        n3 = this.m_Cmd.readInt();
                        string = this.m_Cmd.readString();
                        this.m_userMap.put(new Integer(n3), string);
                        ++n2;
                    }
                    n = this.m_Cmd.readInt();
                    n2 = 0;
                    while (n2 < n) {
                        n3 = this.m_Cmd.readInt();
                        string = this.m_Cmd.readString();
                        this.m_viewMap.put(new Integer(n3), string);
                        ++n2;
                    }
                }
            }
            this.m_storageType = this.m_Cmd.readInt();
            if (this.m_storageType == 3) {
                this.m_Done = false;
                this.m_Started = true;
                try {
                    this.m_Cmd.setHasGZIPContents(true);
                    try {
                        this.m_fileStream = new GZIPInputStream(this.m_Cmd.getChunkStream());
                        break block13;
                    }
                    catch (RuntimeException runtimeException) {
                        this.restoreCompression();
                        throw runtimeException;
                    }
                    catch (Throwable throwable) {
                        this.restoreCompression();
                        throw new SDKRuntimeException(throwable);
                    }
                }
                catch (Exception exception) {
                    this.restoreCompression();
                    throw new SDKRuntimeException(exception.get_Message());
                }
            }
            if (this.m_storageType != 1) {
                Assert.internalError("CmdCheckOutInputStream.initialize(), returnType=" + this.m_storageType + ".");
            } else {
                this.m_Done = false;
                this.m_Started = true;
                this.m_fileStream = this.m_Cmd.getChunkStream();
            }
        }
    }

    private void finish() throws IOException {
        this.restoreCompression();
        this.m_FileTime = this.m_Cmd.readTime();
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        if (this.m_Cmd.getRevisionLevel() >= 62) {
            n = this.m_Cmd.readInt();
            n2 = this.m_Cmd.readInt();
            this.m_myLockState = n;
            this.m_exclusiveLockerID = n2;
        } else {
            bl = this.m_Cmd.readBoolean();
            this.m_myLockState = -1;
            this.m_exclusiveLockerID = -1;
            if (bl) {
                this.m_myLockState = this.m_file.getServer().getPropertyEnums().MY_LOCK_EXCLUSIVELY_LOCKED_BY_ME;
                this.m_exclusiveLockerID = this.m_file.getServer().getSession().getUserID();
            } else {
                this.m_myLockState = -1;
                this.m_exclusiveLockerID = -1;
            }
        }
        if (this.m_Cmd.getRevisionLevel() >= 80) {
            this.m_revisionID = FileRevisionID.read(this.m_Cmd);
            this.m_syncMD5 = this.m_fileMD5 = this.m_Cmd.readMD5();
        } else if (this.m_Request.isUpdateStatus()) {
            this.m_statusData = StStatusData.read(this.m_file.getServer().getRepositoryID(), this.m_Cmd, this.m_Request.isUpdateStatus());
            this.m_syncMD5 = this.m_statusData.m_syncMD5;
        } else {
            this.m_syncMD5 = null;
            this.m_revisionID = FileRevisionID.read(this.m_Cmd);
        }
        this.m_fileExecutable = this.m_file.getServer().getSupportedFeatures().hasFileExecutablePermission() ? this.m_Cmd.readBoolean() : false;
        try {
            this.m_connection.terminateCommand(this.m_Cmd);
        }
        catch (IOException iOException) {
            this.m_connection.onCommandException(iOException);
            throw iOException;
        }
    }

    private void restoreCompression() {
        if (this.m_Cmd.hasGZIPContents()) {
            this.m_Cmd.setHasGZIPContents(false);
            this.m_Cmd.setReadingGZIPContents(false);
        }
    }

    int read() throws IOException {
        return this.read(this.tmp, 0, 1) == -1 ? -1 : this.tmp[0] & 0xFF;
    }

    int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.m_Started) {
            this.initialize();
        }
        if (this.m_Done) {
            return -1;
        }
        boolean bl = false;
        try {
            try {
                int n3 = this.m_fileStream.read(byArray, n, n2);
                if (n3 == -1) {
                    this.m_Done = true;
                    this.finish();
                    return -1;
                }
                return n3;
            }
            catch (IOException iOException) {
                this.restoreCompression();
                this.m_Cmd.onError(iOException);
                bl = true;
                throw iOException;
            }
            catch (RuntimeException runtimeException) {
                this.restoreCompression();
                this.m_Cmd.onError(runtimeException);
                bl = true;
                throw runtimeException;
            }
        }
        catch (Exception exception) {
            this.restoreCompression();
            SDKRuntimeException sDKRuntimeException = new SDKRuntimeException(exception.get_Message());
            if (!bl) {
                this.m_Cmd.onError(sDKRuntimeException);
                bl = true;
            }
            throw sDKRuntimeException;
        }
    }

    protected void push(Command command) throws IOException {
        this.m_Request.writeGuts(command);
    }

    protected void pop(Command command) throws IOException {
    }

    protected CommandRoute getCommandRoute() {
        return m_route;
    }

    public CmdCheckOutInputStream(Connection connection, GUID gUID, int n, int n2, CheckoutRequest checkoutRequest, File file) throws IOException {
        this.m_connection = connection;
        this.m_conn = connection;
        this.m_auth = gUID;
        this.m_viewState = n;
        this.m_target = n2;
        this.m_Request = checkoutRequest;
        this.m_file = file;
        this.initialize();
    }
}

