/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Folder;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandMacro;
import com.starbase.starteam.vts.comm.CommandRoute;
import com.starbase.util.Assert;
import java.io.IOException;
import java.util.Vector;

class CmdAddFolders
extends CommandMacro {
    private static final CommandRoute m_route = new CommandRoute(Integer.MIN_VALUE, 0, 10023, "PROJ_CMD_ADD_FOLDERS");
    private Folder m_folder;
    private Vector m_flattenedFolders = null;

    protected boolean isRetrySupported() {
        return this.isRetrySupportedForEditCommand();
    }

    protected CommandRoute getCommandRoute() {
        return m_route;
    }

    protected void push(Command command) throws IOException {
        command.writeInt(this.m_folder.getParentFolder().getItemID());
        command.writeString(this.m_folder.getName());
        command.writeString(this.m_folder.getDefaultPathFragment());
        command.writeString(this.m_folder.getDescription() == null ? "" : this.m_folder.getDescription());
        command.writeInt(this.m_flattenedFolders.size());
        int n = 0;
        while (n < this.m_flattenedFolders.size()) {
            command.writeString(((Folder)this.m_flattenedFolders.elementAt(n)).getName());
            ++n;
        }
        command.writeInt(this.m_flattenedFolders.size());
        n = 0;
        while (n < this.m_flattenedFolders.size()) {
            command.writeInt(((Folder)this.m_flattenedFolders.elementAt(n)).getSubFolderCount());
            ++n;
        }
    }

    protected void pop(Command command) throws IOException {
        int n = command.readInt();
        if (n != this.m_flattenedFolders.size()) {
            Assert.internalError("CmdAddFolders.pop(), count=" + n + ", m_flattenedFolders.size()=" + this.m_flattenedFolders.size() + ".");
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = command.readInt();
            ((Folder)this.m_flattenedFolders.elementAt(n2)).setItemID(n3);
            ++n2;
        }
    }

    private void flattenFolders(Folder folder) {
        this.m_flattenedFolders.addElement(folder);
        Folder[] folderArray = folder.getSubFolders();
        int n = 0;
        while (n < folderArray.length) {
            this.flattenFolders(folderArray[n]);
            ++n;
        }
    }

    public CmdAddFolders(Folder folder) {
        this.m_folder = folder;
        this.m_flattenedFolders = new Vector();
        this.flattenFolders(this.m_folder);
    }
}

