/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.DescriptorCache;
import com.starbase.starteam.DescriptorCacheRefCollection;
import com.starbase.starteam.ObjectDescriptors;
import com.starbase.starteam.Property;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.Server;
import com.starbase.starteam.Type;
import com.starbase.util.Assert;
import java.util.Enumeration;
import java.util.Hashtable;

class CatalogBase {
    private int m_primaryDescriptorID = -1;
    private Server m_server = null;
    private Type m_type = null;
    private DescriptorCacheRefCollection m_descriptorRefs = null;

    protected void populate() {
        this.m_descriptorRefs.populate();
    }

    protected void refreshIDs(int[] nArray) {
        this.m_descriptorRefs.refreshIDs(nArray);
    }

    protected void discard() {
        this.m_descriptorRefs.discard();
    }

    protected void refresh() {
        this.m_descriptorRefs.refreshAll();
    }

    protected int[] getPropertyIDs() {
        return this.m_descriptorRefs.getPropertyIDs();
    }

    protected Object get(int n, int n2) {
        ObjectDescriptors objectDescriptors = (ObjectDescriptors)this.m_descriptorRefs.getByID(n);
        if (objectDescriptors == null) {
            this.refreshIDs(new int[]{n});
            objectDescriptors = (ObjectDescriptors)this.m_descriptorRefs.getByID(n);
        }
        if (objectDescriptors == null) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.OBJECT_WITH_ID_NOT_FOUND_FMT, new Object[]{new Integer(n)}));
        }
        return objectDescriptors.getDescriptor(this.getPropertyIndex(n2));
    }

    protected Object getPrimaryDescriptor(int n) {
        return this.get(n, this.getPrimaryDescriptorPropertyID());
    }

    protected boolean hasID(int n) {
        return this.m_descriptorRefs.getByID(n) != null;
    }

    protected int[] getAllIDs() {
        Hashtable hashtable = this.getContents();
        int[] nArray = new int[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            nArray[n++] = n2;
        }
        return nArray;
    }

    protected Hashtable getContents() {
        return this.m_descriptorRefs.getCachedIDs();
    }

    protected boolean isRefreshRequired() {
        return this.m_descriptorRefs.isRefreshAllRequired();
    }

    protected boolean isRefreshIDsRequired(int[] nArray) {
        return this.m_descriptorRefs.isRefreshIDsRequired(nArray);
    }

    private int getPrimaryDescriptorPropertyID() {
        if (this.m_primaryDescriptorID == -1) {
            throw new RuntimeException(Res.formatKey(ResIDs.TYPE_HAS_NO_PRIMARY_DESCRIPTOR_FMT, new Object[]{this.m_type.getName()}));
        }
        return this.m_primaryDescriptorID;
    }

    private int getPropertyIndex(int n) {
        int[] nArray = this.m_descriptorRefs.getPropertyIDs();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        Assert.internalError("Catalog.getPropertyIndex(), pid=" + n + ".");
        return -1;
    }

    private void cachePrimaryDescriptorID() {
        Property[] propertyArray = this.m_type.propertiesForNames(null);
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            if (property.isPrimaryDescriptor()) {
                this.m_primaryDescriptorID = property.getID();
                break;
            }
            ++n;
        }
    }

    protected CatalogBase(Server server, Type type) {
        this.m_server = server;
        this.m_type = type;
        this.cachePrimaryDescriptorID();
        DescriptorCache descriptorCache = this.m_server.getServerCacheManager().getTypeCacheManager(this.m_type.getClassID()).getDescriptorCache();
        this.m_descriptorRefs = new DescriptorCacheRefCollection(descriptorCache, this.m_server);
    }
}

