/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CacheRef;
import com.starbase.starteam.ReferenceFactoryCache;
import com.starbase.util.Assert;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class CacheRefCollection {
    protected ReferenceFactoryCache m_cache = null;
    protected Object m_repository = null;
    protected Vector m_refs = new Vector();
    protected long m_timestamp = 0L;
    protected Hashtable m_idHashedRefs = new Hashtable();
    protected long m_idHashtableTimestamp = 0L;

    public boolean isPopulated() {
        return this.m_timestamp != 0L;
    }

    public void populate() {
        if (this.m_timestamp == 0L) {
            this.refresh();
        }
    }

    public void refresh() {
        this.m_timestamp = this.m_cache.refreshAll(this.m_repository, this.m_refs, this.m_timestamp);
    }

    public boolean isRefreshRequired() {
        return this.m_cache.isRefreshAllRequired(this.m_refs, this.m_timestamp);
    }

    public void clear() {
        this.m_refs.removeAllElements();
        this.m_timestamp = 0L;
        this.m_idHashedRefs.clear();
        this.m_idHashtableTimestamp = 0L;
    }

    public void discard() {
        this.clear();
        this.m_cache.discardAll();
    }

    public void add(CacheRef cacheRef) {
        cacheRef.getCachedObject().setDirty(true);
        this.m_refs.addElement(cacheRef);
    }

    public CacheRef getByID(int n) {
        int n2;
        this.populate();
        if (this.m_idHashtableTimestamp < this.m_timestamp && (n2 = this.m_refs.size()) > 0) {
            Hashtable hashtable;
            this.m_idHashedRefs = hashtable = new Hashtable(n2);
            Enumeration enumeration = this.m_refs.elements();
            while (enumeration.hasMoreElements()) {
                CacheRef cacheRef = (CacheRef)enumeration.nextElement();
                this.m_idHashedRefs.put(new Integer(cacheRef.getCachedObject().getID()), cacheRef);
            }
            this.m_idHashtableTimestamp = this.m_timestamp;
        }
        return (CacheRef)this.m_idHashedRefs.get(new Integer(n));
    }

    public Vector getRefs() {
        return this.m_refs;
    }

    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    public int getCount() {
        return this.getRefs().size();
    }

    protected long getTimestamp() {
        return this.m_timestamp;
    }

    protected void setTimestamp(long l) {
        this.m_timestamp = l;
    }

    public CacheRefCollection(ReferenceFactoryCache referenceFactoryCache, Object object) {
        this.m_cache = referenceFactoryCache;
        this.m_repository = object;
    }

    CacheRefCollection(CacheRefCollection cacheRefCollection) {
        this.m_cache = cacheRefCollection.m_cache;
        this.m_repository = cacheRefCollection.m_repository;
        int n = cacheRefCollection.m_refs.size();
        this.m_refs = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            try {
                this.m_refs.addElement(((CacheRef)cacheRefCollection.m_refs.elementAt(n2)).clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Assert.internalError("CacheRefCollection.CacheRefCollection(other)", cloneNotSupportedException);
            }
            ++n2;
        }
        this.m_timestamp = cacheRefCollection.m_timestamp;
        this.m_idHashedRefs = null;
        this.m_idHashtableTimestamp = this.m_timestamp - 1L;
    }
}

