/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.AccessTestResults;
import com.starbase.starteam.AclEntry;
import com.starbase.starteam.CacheRef;
import com.starbase.starteam.EffectiveACE;
import com.starbase.starteam.GroupAccount;
import com.starbase.starteam.ISecurable;
import com.starbase.starteam.ISecurableContainer;
import com.starbase.starteam.ISecurableObject;
import com.starbase.starteam.MatchedACE;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.Server;
import com.starbase.starteam.SystemPolicy;
import com.starbase.starteam.Type;
import com.starbase.starteam.User;
import com.starbase.util.Assert;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AccessRightsManager {
    private static final EffectiveACE[] NO_ACL = new EffectiveACE[0];
    private Server m_server = null;
    private SystemPolicy m_policy = null;
    private EffectiveACE[] m_ACLForPrivileges = null;
    private Hashtable m_containerAclCache = null;
    private Hashtable m_userAccessLists = null;

    public void refresh() {
        this.discard();
    }

    public void discard() {
        this.m_policy = null;
        this.m_ACLForPrivileges = null;
        this.m_containerAclCache = null;
        this.m_userAccessLists = null;
    }

    public EffectiveACE[] getEffectiveACL(ISecurable iSecurable) {
        Vector vector = new Vector();
        this.addACEsForPrivileges(vector);
        if (iSecurable instanceof ISecurableObject) {
            this.addACEForOwner((ISecurableObject)iSecurable, vector);
        }
        this.addACEsForACL(iSecurable, vector);
        Object[] objectArray = new EffectiveACE[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public EffectiveACE[] getEffectiveContainerACL(ISecurableContainer iSecurableContainer, Type type) {
        Vector vector = new Vector();
        this.addACEsForPrivileges(vector);
        this.addACEsForACL(iSecurableContainer, type, vector);
        Object[] objectArray = new EffectiveACE[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void addACEsForPrivileges(Vector vector) {
        if (this.m_ACLForPrivileges == null) {
            Vector<EffectiveACE> vector2 = new Vector<EffectiveACE>();
            if (this.getPrivilegesEnabled()) {
                GroupAccount[] groupAccountArray = this.m_server.getAdministration().getGroupAccounts();
                int n = 0;
                while (n < groupAccountArray.length) {
                    GroupAccount groupAccount = groupAccountArray[n];
                    int n2 = groupAccount.getPermissionsFlags();
                    if (n2 != 0) {
                        vector2.addElement(EffectiveACE.forGroupPrivileges(this.m_server, groupAccount));
                    }
                    ++n;
                }
            }
            this.m_ACLForPrivileges = new EffectiveACE[vector2.size()];
            vector2.copyInto(this.m_ACLForPrivileges);
        }
        this.addAll(this.m_ACLForPrivileges, vector);
    }

    private void addAll(EffectiveACE[] effectiveACEArray, Vector vector) {
        if (effectiveACEArray != null) {
            int n = effectiveACEArray.length;
            int n2 = 0;
            while (n2 < n) {
                vector.addElement(effectiveACEArray[n2]);
                ++n2;
            }
        }
    }

    private void addACEForOwner(ISecurableObject iSecurableObject, Vector vector) {
        if (this.getOwnershipEnabled()) {
            EffectiveACE effectiveACE = EffectiveACE.forOwner(this.m_server, iSecurableObject.getOwner(), iSecurableObject);
            vector.addElement(effectiveACE);
        }
    }

    private void addACEsForACL(ISecurable iSecurable, Vector vector) {
        if (!this.addACEsForObjectLevelACL(iSecurable, vector) && !this.addACEsForContainerLevelACL(iSecurable.getParentContainer(), iSecurable.getType(), vector)) {
            this.addACEforMissingACL(vector);
            return;
        }
        this.addImpliedACE(iSecurable, vector);
    }

    private void addACEsForACL(ISecurableContainer iSecurableContainer, Type type, Vector vector) {
        if (!this.addACEsForContainerLevelACL(iSecurableContainer, type, vector)) {
            this.addACEforMissingACL(vector);
            return;
        }
        this.addImpliedACE(iSecurableContainer, type, vector);
    }

    private void addACEforMissingACL(Vector vector) {
        EffectiveACE effectiveACE = EffectiveACE.forMissingACL(this.m_server);
        vector.addElement(effectiveACE);
    }

    private boolean addACEsForObjectLevelACL(ISecurable iSecurable, Vector vector) {
        EffectiveACE[] effectiveACEArray = this.getObjectLevelACL(iSecurable);
        if (effectiveACEArray != null) {
            this.addAll(effectiveACEArray, vector);
            return true;
        }
        return false;
    }

    private EffectiveACE[] getObjectLevelACL(ISecurable iSecurable) {
        EffectiveACE[] effectiveACEArray = null;
        AclEntry[] aclEntryArray = iSecurable.getACL();
        if (aclEntryArray != null) {
            int n = aclEntryArray.length;
            effectiveACEArray = new EffectiveACE[n];
            int n2 = 0;
            while (n2 < n) {
                effectiveACEArray[n2] = EffectiveACE.forObjectACE(this.m_server, aclEntryArray[n2], iSecurable);
                ++n2;
            }
        }
        return effectiveACEArray;
    }

    private boolean addACEsForContainerLevelACL(ISecurableContainer iSecurableContainer, Type type, Vector vector) {
        EffectiveACE[] effectiveACEArray = this.getContainerLevelACL(iSecurableContainer, type);
        if (effectiveACEArray != null) {
            this.addAll(effectiveACEArray, vector);
            return true;
        }
        return false;
    }

    private EffectiveACE[] getContainerLevelACL(ISecurableContainer iSecurableContainer, Type type) {
        if (iSecurableContainer == null) {
            return null;
        }
        EffectiveACE[] effectiveACEArray = this.getCachedContainerACL(iSecurableContainer, type);
        if (effectiveACEArray != null) {
            return effectiveACEArray != NO_ACL ? effectiveACEArray : null;
        }
        AclEntry[] aclEntryArray = iSecurableContainer.getContainerLevelACL(type.getName());
        if (aclEntryArray != null) {
            int n = aclEntryArray.length;
            effectiveACEArray = new EffectiveACE[n];
            int n2 = 0;
            while (n2 < n) {
                effectiveACEArray[n2] = EffectiveACE.forContainerACE(this.m_server, aclEntryArray[n2], iSecurableContainer, type);
                ++n2;
            }
        } else {
            effectiveACEArray = this.getContainerLevelACL(iSecurableContainer.getParentContainer(), type);
        }
        this.setCachedContainerACL(iSecurableContainer, type, effectiveACEArray != null ? effectiveACEArray : NO_ACL);
        return effectiveACEArray;
    }

    private EffectiveACE[] getCachedContainerACL(ISecurableContainer iSecurableContainer, Type type) {
        Integer n;
        Hashtable hashtable;
        if (this.m_containerAclCache != null && (hashtable = (Hashtable)this.m_containerAclCache.get(n = new Integer(type.getClassID()))) != null) {
            return (EffectiveACE[])hashtable.get(iSecurableContainer);
        }
        return null;
    }

    private void setCachedContainerACL(ISecurableContainer iSecurableContainer, Type type, EffectiveACE[] effectiveACEArray) {
        Integer n;
        Hashtable<ISecurableContainer, EffectiveACE[]> hashtable;
        if (this.m_containerAclCache == null) {
            this.m_containerAclCache = new Hashtable();
        }
        if ((hashtable = (Hashtable<ISecurableContainer, EffectiveACE[]>)this.m_containerAclCache.get(n = new Integer(type.getClassID()))) == null) {
            hashtable = new Hashtable<ISecurableContainer, EffectiveACE[]>();
            this.m_containerAclCache.put(n, hashtable);
        }
        hashtable.put(iSecurableContainer, effectiveACEArray);
    }

    private void addImpliedACE(ISecurable iSecurable, Vector vector) {
        this.addImpliedACE(this.getAllRights(iSecurable), vector);
    }

    private void addImpliedACE(ISecurableContainer iSecurableContainer, Type type, Vector vector) {
        this.addImpliedACE(this.getAllRights(iSecurableContainer, type), vector);
    }

    private void addImpliedACE(int n, Vector vector) {
        int n2 = this.getUnspecifiedPermissions(n, Integer.MIN_VALUE, vector);
        if (n2 != 0) {
            EffectiveACE effectiveACE = EffectiveACE.forMissingACE(this.m_server, n2);
            vector.addElement(effectiveACE);
        }
    }

    private int getUnspecifiedPermissions(int n, int n2, Vector vector) {
        int n3 = n;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EffectiveACE effectiveACE = (EffectiveACE)enumeration.nextElement();
            if (effectiveACE.getID() != n2) continue;
            n3 &= ~effectiveACE.getPermissionFlags();
        }
        return n3;
    }

    private boolean getPrivilegesEnabled() {
        SystemPolicy systemPolicy = this.getSystemPolicy();
        return !systemPolicy.getSkipGroupPrivilegesCheck();
    }

    private boolean getOwnershipEnabled() {
        SystemPolicy systemPolicy = this.getSystemPolicy();
        return !systemPolicy.getSkipOwnershipCheck();
    }

    private SystemPolicy getSystemPolicy() {
        if (this.m_policy == null) {
            this.m_policy = this.m_server.getAdministration().getPolicy();
        }
        return this.m_policy;
    }

    private int getAllRights(ISecurable iSecurable) {
        return this.getAllRights(iSecurable.getType());
    }

    private int getAllRights(Type type) {
        String string = type.getName();
        if (type.isItemType()) {
            if (string.equals(this.m_server.getTypeNames().FILE)) {
                return this.getFileRights();
            }
            return this.getItemRights();
        }
        if (string.equals(this.m_server.getTypeNames().FOLDER)) {
            return this.getFolderRights();
        }
        if (string.equals(this.m_server.getTypeNames().VIEW)) {
            return this.getViewRights();
        }
        if (string.equals(this.m_server.getTypeNames().PROJECT)) {
            return this.getProjectRights();
        }
        if (string.equals(this.m_server.getTypeNames().PROMOTIONSTATE)) {
            return this.getPromotionStateRights();
        }
        Assert.internalError("AccessRightsManager.getAllRights(), type=" + string);
        return this.getGenericObjectRights();
    }

    private int getGenericObjectRights() {
        return 114;
    }

    private int getGenericItemRights() {
        int n = this.getGenericObjectRights() | 0x1000 | 0x800;
        if (this.m_server.getRevisionLevel() >= 81) {
            n = n | 4 | 8;
        }
        return n;
    }

    private int getItemRights() {
        return this.getGenericItemRights() | this.getItemLabelRights() | this.getItemLinkRights();
    }

    private int getItemLabelRights() {
        if (this.m_server.getRevisionLevel() >= 72) {
            return 201408512;
        }
        if (this.m_server.getRevisionLevel() >= 62) {
            return 81920;
        }
        return 32768;
    }

    private int getItemLinkRights() {
        return 925696;
    }

    private int getFileRights() {
        return this.getItemRights() | 4 | 8 | 0x100000 | 0x200000;
    }

    private int getViewLabelRights() {
        if (this.m_server.getRevisionLevel() >= 72) {
            return 0x770000;
        }
        return 0x700000;
    }

    private int getFolderRights() {
        return this.getGenericObjectRights() | 0x1000 | this.getItemLabelRights() | this.getItemLinkRights();
    }

    private int getViewRights() {
        return this.getGenericObjectRights() | this.getViewLabelRights() | 0x1000000;
    }

    private int getProjectRights() {
        return this.getGenericObjectRights();
    }

    private int getPromotionStateRights() {
        return 131074;
    }

    private int getAllRights(ISecurableContainer iSecurableContainer, Type type) {
        int n = this.getAllRights(type);
        String string = type.getName();
        if (type.isItemType()) {
            n |= this.getItemContainerRights();
        } else if (string.equals(this.m_server.getTypeNames().FOLDER)) {
            n |= this.getFolderContainerRights();
        } else if (string.equals(this.m_server.getTypeNames().VIEW)) {
            n |= this.getViewContainerRights();
        }
        return n;
    }

    private int getItemContainerRights() {
        return 1792;
    }

    private int getFolderContainerRights() {
        return this.getItemContainerRights();
    }

    private int getViewContainerRights() {
        return 256;
    }

    public boolean isAccessGranted(int n, int n2, ISecurable iSecurable) {
        return this.isAccessGranted(n, n2, this.getEffectiveACL(iSecurable));
    }

    public boolean isAccessGranted(int n, int n2, ISecurableContainer iSecurableContainer, Type type) {
        return this.isAccessGranted(n, n2, this.getEffectiveContainerACL(iSecurableContainer, type));
    }

    public boolean isAccessGranted(int n, int n2, EffectiveACE[] effectiveACEArray) {
        return this.accessTest(n, n2, effectiveACEArray, null);
    }

    public AccessTestResults accessTest(int n, int n2, ISecurable iSecurable) {
        return this.accessTest(n, n2, this.getEffectiveACL(iSecurable));
    }

    public AccessTestResults accessTest(int n, int n2, ISecurableContainer iSecurableContainer, Type type) {
        return this.accessTest(n, n2, this.getEffectiveContainerACL(iSecurableContainer, type));
    }

    public AccessTestResults accessTest(int n, int n2, EffectiveACE[] effectiveACEArray) {
        Vector vector = new Vector();
        boolean bl = this.accessTest(n, n2, effectiveACEArray, vector);
        Object[] objectArray = new MatchedACE[vector.size()];
        vector.copyInto(objectArray);
        return new AccessTestResults(bl, (MatchedACE[])objectArray);
    }

    private boolean accessTest(int n, int n2, EffectiveACE[] effectiveACEArray, Vector vector) {
        if (effectiveACEArray == null) {
            if (vector != null) {
                EffectiveACE effectiveACE = EffectiveACE.forMissingACL(this.m_server);
                vector.addElement(new MatchedACE(-1, n2, effectiveACE));
            }
            return true;
        }
        int[] nArray = this.getAccessListForUser(n);
        boolean bl = true;
        int n3 = effectiveACEArray.length;
        int n4 = 0;
        while (n4 < n3 && n2 != 0) {
            EffectiveACE effectiveACE = effectiveACEArray[n4];
            int n5 = effectiveACE.getPermissionFlags() & n2;
            if (n5 != 0 && this.isForUser(effectiveACE, nArray)) {
                if (!effectiveACE.isGranted()) {
                    bl = false;
                }
                if (vector != null) {
                    vector.addElement(new MatchedACE(n4, n5, effectiveACE));
                } else if (!bl) break;
                n2 &= ~n5;
            }
            ++n4;
        }
        if (n2 != 0) {
            bl = false;
            if (vector != null) {
                EffectiveACE effectiveACE = EffectiveACE.forMissingACE(this.m_server, n2);
                vector.addElement(new MatchedACE(-1, n2, effectiveACE));
            }
        }
        return bl;
    }

    private int[] getAccessListForUser(int n) {
        CacheRef cacheRef;
        int[] nArray = null;
        Integer n2 = new Integer(n);
        if (this.m_userAccessLists != null) {
            nArray = (int[])this.m_userAccessLists.get(n2);
            if (nArray != null) {
                return nArray;
            }
        } else {
            this.m_userAccessLists = new Hashtable();
        }
        Vector<CacheRef> vector = new Vector<CacheRef>();
        GroupAccount[] groupAccountArray = this.m_server.getAdministration().getGroupAccounts();
        int n3 = 0;
        while (n3 < groupAccountArray.length) {
            cacheRef = groupAccountArray[n3];
            if (((GroupAccount)cacheRef).isMember(n)) {
                vector.addElement(cacheRef);
            }
            ++n3;
        }
        n3 = vector.size();
        if (n3 == 0) {
            cacheRef = this.m_server.getUser(n);
            if (cacheRef == null) {
                String string = Res.getString(ResIDs.USERID_INVALID);
                throw new IllegalArgumentException(string);
            }
            if (((User)cacheRef).isDeleted()) {
                String string = Res.getString(ResIDs.USERID_DELETED);
                throw new IllegalArgumentException(string);
            }
        }
        nArray = new int[n3 + 1];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = ((GroupAccount)vector.elementAt(n4)).getID();
            ++n4;
        }
        nArray[n3] = n;
        this.m_userAccessLists.put(n2, nArray);
        return nArray;
    }

    private boolean isForUser(AclEntry aclEntry, int[] nArray) {
        int n = aclEntry.getID();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (n == nArray[n3]) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public AccessRightsManager(Server server) {
        this.m_server = server;
    }
}

