/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.diff;

import com.starbase.diff.DiffCompare;
import com.starbase.diff.DiffException;
import com.starbase.diff.Differ;
import com.starbase.diff.Edit;
import com.starbase.diff.EditList;
import com.starbase.diff.Res;
import com.starbase.diff.ResIDs;
import com.starbase.diff.Sequence;
import com.starbase.util.Assert;

public class StarTeamDiff
implements Differ {
    private static final int DIAG_MAX = Integer.MAX_VALUE;
    private final char DELETE_CODE = (char)100;
    private final char ADD_CODE = (char)97;
    private final char CHANGE_CODE = (char)99;
    private ArgInfo m_Source;
    private ArgInfo m_Target;
    int[] m_pAllocFwdDiag;
    int[] m_pAllocBackDiag;
    int m_nFwdDiagOffset;
    int m_nBackDiagOffset;
    int m_nCost;
    private int m_nFreeIndex;
    private DiffCompare m_compare;

    final int getFwdDiag(int n) {
        return this.m_pAllocFwdDiag[n + this.m_nFwdDiagOffset];
    }

    final int getBackDiag(int n) {
        return this.m_pAllocBackDiag[n + this.m_nBackDiagOffset];
    }

    final void setFwdDiag(int n, int n2) {
        this.m_pAllocFwdDiag[n + this.m_nFwdDiagOffset] = n2;
    }

    final void setBackDiag(int n, int n2) {
        this.m_pAllocBackDiag[n + this.m_nBackDiagOffset] = n2;
    }

    public EditList diff(Sequence sequence, Sequence sequence2, DiffCompare diffCompare) throws DiffException {
        this.m_compare = diffCompare;
        EditList editList = new EditList();
        this.findIdenticalEnds(sequence, sequence2);
        if (this.m_Source.m_nLastPrefix == this.m_Source.m_nFirstSuffix && this.m_Target.m_nLastPrefix == this.m_Target.m_nFirstSuffix) {
            return editList;
        }
        this.hashLines(this.m_Source, sequence);
        this.hashLines(this.m_Target, sequence2);
        this.assignEquivalenceValues();
        Change change = this.findDiffs();
        if (change != null) {
            this.outputEditScript(change, editList);
        }
        return editList;
    }

    void findIdenticalEnds(Sequence sequence, Sequence sequence2) {
        int n = 0;
        int n2 = sequence.size() - 1;
        if (-1 == n2) {
            n2 = 0;
        }
        int n3 = 0;
        int n4 = sequence2.size() - 1;
        if (-1 == n4) {
            n4 = 0;
        }
        int n5 = n;
        int n6 = n3;
        Object object = null;
        Object object2 = null;
        int n7 = 0;
        while (n != n2 && n3 != n4) {
            n5 = n;
            n6 = n3;
            if (!this.m_compare.equalObjects(object = sequence.get(n++), object2 = sequence2.get(n3++))) break;
            ++n7;
        }
        this.m_Source.m_nLastPrefix = n7;
        this.m_Target.m_nLastPrefix = n7;
        int n8 = 0;
        while (n2 != n5 && n4 != n6) {
            if (!this.m_compare.equalObjects(object = sequence.get(n2--), object2 = sequence2.get(n4--))) break;
            ++n8;
        }
        this.m_Source.m_nFirstSuffix = sequence.size() - n8;
        this.m_Target.m_nFirstSuffix = sequence2.size() - n8;
    }

    void hashLines(ArgInfo argInfo, Sequence sequence) {
        int n = argInfo.m_nLastPrefix;
        int n2 = sequence.size();
        if (n2 > 0) {
            argInfo.m_pLines = new LineInfo[n2];
            int n3 = 0;
            while (n3 < n2) {
                StarTeamDiff starTeamDiff = this;
                if (starTeamDiff == null) {
                    throw null;
                }
                argInfo.m_pLines[n3] = starTeamDiff.new LineInfo();
                ++n3;
            }
        }
        argInfo.m_nLines = argInfo.m_nLastPrefix;
        Object object = null;
        int n4 = sequence.size();
        while (n < argInfo.m_nFirstSuffix && n < n4) {
            int n5 = 0;
            Object object2 = sequence.get(n);
            if (argInfo.m_nLastPrefix <= n) {
                object = object2;
                n5 = this.m_compare.hashObject(object);
            }
            argInfo.m_pLines[argInfo.m_nLines].m_nLine = n++;
            argInfo.m_pLines[argInfo.m_nLines].m_pLine = object;
            argInfo.m_pLines[argInfo.m_nLines].m_nHash = n5;
            ++argInfo.m_nLines;
        }
    }

    void assignEquivalenceValues() throws DiffException {
        int n;
        int n2 = n = this.m_Source.m_nLines + this.m_Target.m_nLines + 5;
        this.m_nFreeIndex = 1;
        Equivalence[] equivalenceArray = new Equivalence[n2];
        int n3 = 0;
        while (n3 < n2) {
            StarTeamDiff starTeamDiff = this;
            if (starTeamDiff == null) {
                throw null;
            }
            equivalenceArray[n3] = starTeamDiff.new Equivalence(n3);
            ++n3;
        }
        Equivalence[] equivalenceArray2 = new Equivalence[n];
        this.m_Source.m_pEquivs = new int[this.m_Source.m_nLines + 5];
        n3 = 0;
        while (n3 < this.m_Source.m_nLines) {
            this.m_Source.m_pEquivs[n3] = this.findEquivalence(n3, this.m_Source, n, equivalenceArray2, n2, equivalenceArray);
            ++n3;
        }
        this.m_Target.m_pEquivs = new int[this.m_Target.m_nLines + 5];
        n3 = 0;
        while (n3 < this.m_Target.m_nLines) {
            this.m_Target.m_pEquivs[n3] = this.findEquivalence(n3, this.m_Target, n, equivalenceArray2, n2, equivalenceArray);
            ++n3;
        }
        this.m_Source.m_nMaxEquivValue = this.m_Target.m_nMaxEquivValue = this.m_nFreeIndex;
    }

    int findEquivalence(int n, ArgInfo argInfo, int n2, Equivalence[] equivalenceArray, int n3, Equivalence[] equivalenceArray2) throws DiffException {
        Equivalence equivalence = null;
        Equivalence equivalence2 = null;
        if (n < argInfo.m_nLastPrefix || argInfo.m_pLines[n].m_nLine >= argInfo.m_nFirstSuffix) {
            return 0;
        }
        int n4 = argInfo.m_pLines[n].m_nHash;
        int n5 = Math.abs(n4 % n2);
        equivalence = equivalenceArray[n5];
        while (equivalence != null) {
            if (argInfo.m_pLines[n].m_nHash == equivalence.m_pLine.m_nHash && this.m_compare.equalObjects(argInfo.m_pLines[n].m_pLine, equivalence.m_pLine.m_pLine)) {
                return equivalence.m_nIndex;
            }
            equivalence2 = equivalence;
            equivalence = equivalence.m_pNext;
        }
        if (this.m_nFreeIndex >= n3) {
            throw new DiffException(Res.getString(ResIDs.TOO_MANY_DIFFS));
        }
        equivalence2 = equivalenceArray2[this.m_nFreeIndex++];
        equivalence2.m_pNext = equivalenceArray[n5];
        equivalenceArray[n5] = equivalence2;
        equivalence2.m_pLine = argInfo.m_pLines[n];
        return this.m_nFreeIndex - 1;
    }

    private Change findDiffs() {
        this.m_Source.m_pChanges = new char[this.m_Source.m_nLines + 2];
        this.m_Target.m_pChanges = new char[this.m_Target.m_nLines + 2];
        this.excludeUnmatchedLines();
        this.m_pAllocFwdDiag = new int[this.m_Source.m_nRemainingLines + this.m_Target.m_nRemainingLines + 3];
        this.m_pAllocBackDiag = new int[this.m_Source.m_nRemainingLines + this.m_Target.m_nRemainingLines + 3];
        this.m_nFwdDiagOffset = this.m_Target.m_nRemainingLines + 1;
        this.m_nBackDiagOffset = this.m_Target.m_nRemainingLines + 1;
        this.compareSeq(0, this.m_Source.m_nRemainingLines, 0, this.m_Target.m_nRemainingLines);
        this.shiftBoundaries();
        return this.buildReverseScript();
    }

    void shiftBoundaries() {
        this.shiftBoundaries(this.m_Source.m_pChanges, this.m_Source.m_nLines, this.m_Target.m_pChanges, this.m_Source.m_pEquivs);
        this.shiftBoundaries(this.m_Target.m_pChanges, this.m_Target.m_nLines, this.m_Source.m_pChanges, this.m_Target.m_pEquivs);
    }

    /*
     * Exception decompiling
     */
    void shiftBoundaries(char[] var1_1, int var2_2, char[] var3_3, int[] var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 2[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void excludeUnmatchedLines() {
        int n;
        char[] cArray = null;
        char[] cArray2 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        this.m_Source.m_pVector = new int[this.m_Source.m_nLines];
        this.m_Target.m_pVector = new int[this.m_Target.m_nLines];
        this.m_Source.m_pLineMap = new int[this.m_Source.m_nLines];
        this.m_Target.m_pLineMap = new int[this.m_Target.m_nLines];
        nArray = new int[this.m_Source.m_nMaxEquivValue];
        nArray2 = new int[this.m_Target.m_nMaxEquivValue];
        int n2 = 0;
        while (n2 < this.m_Source.m_nLines) {
            n = this.m_Source.m_pEquivs[n2];
            nArray[n] = nArray[n] + 1;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_Target.m_nLines) {
            n = this.m_Target.m_pEquivs[n2];
            nArray2[n] = nArray2[n] + 1;
            ++n2;
        }
        cArray = new char[this.m_Source.m_nLines];
        cArray2 = new char[this.m_Target.m_nLines];
        this.markDiscards(cArray, this.m_Source.m_nLines, nArray2, this.m_Source.m_pEquivs);
        this.markDiscards(cArray2, this.m_Target.m_nLines, nArray, this.m_Target.m_pEquivs);
        this.reviewDiscards(this.m_Source.m_nLines, cArray);
        this.reviewDiscards(this.m_Target.m_nLines, cArray2);
        this.discardLines(this.m_Source.m_nLines, cArray, this.m_Source);
        this.discardLines(this.m_Target.m_nLines, cArray2, this.m_Target);
    }

    void compareSeq(int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4 && this.m_Source.m_pVector[n] == this.m_Target.m_pVector[n3]) {
            ++n;
            ++n3;
        }
        while (n2 > n && n4 > n3 && this.m_Source.m_pVector[n2 - 1] == this.m_Target.m_pVector[n4 - 1]) {
            --n2;
            --n4;
        }
        if (n == n2) {
            while (n3 < n4) {
                this.m_Target.m_pChanges[this.m_Target.m_pLineMap[n3++]] = '\u0001';
            }
        } else if (n3 == n4) {
            while (n < n2) {
                this.m_Source.m_pChanges[this.m_Source.m_pLineMap[n++]] = '\u0001';
            }
        } else {
            int n5 = this.diag(n, n2, n3, n4);
            int n6 = this.getFwdDiag(n5);
            int n7 = this.getBackDiag(n5);
            if (this.m_nCost == 1) {
                String string = "StarTeamDiff.compareSeq(), nCost=1";
                Assert.internalError(string);
            } else {
                this.compareSeq(n, n7, n3, n7 - n5);
                this.compareSeq(n7, n2, n7 - n5, n4);
            }
        }
    }

    Change buildReverseScript() {
        Change change = null;
        Change change2 = null;
        int n = 0;
        int n2 = 0;
        while (n < this.m_Source.m_nLines || n2 < this.m_Target.m_nLines) {
            if (this.m_Source.m_pChanges[n] != '\u0000' || this.m_Target.m_pChanges[n2] != '\u0000') {
                int n3 = n;
                int n4 = n2;
                while (this.m_Source.m_pChanges[n] != '\u0000') {
                    ++n;
                }
                while (this.m_Target.m_pChanges[n2] != '\u0000') {
                    ++n2;
                }
                change2 = this.addChange(n3, n4, n - n3, n2 - n4, change2);
                if (change == null) {
                    change = change2;
                }
            }
            ++n;
            ++n2;
        }
        return change;
    }

    void markDiscards(char[] cArray, int n, int[] nArray, int[] nArray2) {
        int n2 = 5;
        int n3 = n / 64;
        while ((n3 >>= 2) > 0) {
            n2 *= 2;
        }
        int n4 = 0;
        while (n4 < n) {
            if (nArray2[n4] != 0) {
                int n5 = nArray[nArray2[n4]];
                if (n5 == 0) {
                    cArray[n4] = '\u0001';
                } else if (n5 > n2) {
                    cArray[n4] = 2;
                }
            }
            ++n4;
        }
    }

    void reviewDiscards(int n, char[] cArray) {
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] == '\u0002') {
                cArray[n2] = '\u0000';
            } else if (cArray[n2] != '\u0000') {
                int n3 = 0;
                int n4 = n2;
                while (n4 < n) {
                    if (cArray[n4] == '\u0000') break;
                    if (cArray[n4] == '\u0002') {
                        ++n3;
                    }
                    ++n4;
                }
                while (n4 > n2 && cArray[n4 - 1] == '\u0002') {
                    cArray[--n4] = '\u0000';
                    --n3;
                }
                int n5 = n4 - n2;
                if (n3 * 4 > n5) {
                    while (n4 > n2) {
                        if (cArray[--n4] != '\u0002') continue;
                        cArray[n4] = '\u0000';
                    }
                } else {
                    int n6 = 1;
                    int n7 = n5 / 4;
                    while ((n7 >>= 2) > 0) {
                        n6 *= 2;
                    }
                    ++n6;
                    n4 = 0;
                    int n8 = 0;
                    while (n4 < n5) {
                        if (cArray[n2 + n4] != '\u0002') {
                            n8 = 0;
                        } else if (n6 == ++n8) {
                            n4 -= n8;
                        } else if (n6 < n8) {
                            cArray[n2 + n4] = '\u0000';
                        }
                        ++n4;
                    }
                    n4 = 0;
                    n8 = 0;
                    while (n4 < n5) {
                        if (n4 >= 8 && cArray[n2 + n4] == '\u0001') break;
                        if (cArray[n2 + n4] == '\u0002') {
                            n8 = 0;
                            cArray[n2 + n4] = '\u0000';
                        } else {
                            n8 = cArray[n2 + n4] == '\u0000' ? 0 : ++n8;
                        }
                        if (n8 == 3) break;
                        ++n4;
                    }
                    n2 += n5 - 1;
                    n4 = 0;
                    n8 = 0;
                    while (n4 < n5) {
                        if (n4 >= 8 && cArray[n2 - n4] == '\u0001') break;
                        if (cArray[n2 - n4] == '\u0002') {
                            n8 = 0;
                            cArray[n2 - n4] = '\u0000';
                        } else {
                            n8 = cArray[n2 - n4] == '\u0000' ? 0 : ++n8;
                        }
                        if (n8 != 3) {
                            ++n4;
                            continue;
                        }
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    void discardLines(int n, char[] cArray, ArgInfo argInfo) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (cArray[n3] == '\u0000') {
                argInfo.m_pVector[n2] = argInfo.m_pEquivs[n3];
                argInfo.m_pLineMap[n2++] = n3;
            } else {
                argInfo.m_pChanges[n3] = '\u0001';
            }
            ++n3;
        }
        argInfo.m_nRemainingLines = n2;
    }

    Change addChange(int n, int n2, int n3, int n4, Change change) {
        StarTeamDiff starTeamDiff = this;
        if (starTeamDiff == null) {
            throw null;
        }
        Change change2 = starTeamDiff.new Change();
        change2.m_n1stDel = n;
        change2.m_n1stIns = n2;
        change2.m_nInserts = n4;
        change2.m_nDeletes = n3;
        change2.m_pLink = null;
        if (change != null) {
            change.m_pLink = change2;
        }
        return change2;
    }

    int diag(int n, int n2, int n3, int n4) {
        int n5 = n - n4;
        int n6 = n2 - n3;
        int n7 = n - n3;
        int n8 = n2 - n4;
        int n9 = n7;
        int n10 = n7;
        int n11 = n8;
        int n12 = n8;
        boolean bl = (n7 - n8 & 1) != 0;
        this.setFwdDiag(n7, n);
        this.setBackDiag(n8, n2);
        int n13 = 1;
        while (true) {
            int n14;
            int n15;
            int n16;
            int n17;
            if (n9 > n5) {
                this.setFwdDiag(--n9 - 1, -1);
            } else {
                ++n9;
            }
            if (n10 < n6) {
                this.setFwdDiag(++n10 + 1, -1);
            } else {
                --n10;
            }
            int n18 = n10;
            while (n18 >= n9) {
                n17 = this.getFwdDiag(n18 - 1);
                n15 = n17 < (n16 = this.getFwdDiag(n18 + 1)) ? n16 : n17 + 1;
                n14 = n15 - n18;
                while (n15 < n2 && n14 < n4 && this.m_Source.m_pVector[n15] == this.m_Target.m_pVector[n14]) {
                    ++n15;
                    ++n14;
                }
                this.setFwdDiag(n18, n15);
                if (bl && n11 <= n18 && n18 <= n12 && this.getBackDiag(n18) <= this.getFwdDiag(n18)) {
                    this.m_nCost = 2 * n13 - 1;
                    return n18;
                }
                n18 -= 2;
            }
            if (n11 > n5) {
                this.setBackDiag(--n11 - 1, Integer.MAX_VALUE);
            } else {
                ++n11;
            }
            if (n12 < n6) {
                this.setBackDiag(++n12 + 1, Integer.MAX_VALUE);
            } else {
                --n12;
            }
            n18 = n12;
            while (n18 >= n11) {
                n17 = this.getBackDiag(n18 - 1);
                n15 = n17 < (n16 = this.getBackDiag(n18 + 1)) ? n17 : n16 - 1;
                n14 = n15 - n18;
                while (n15 > n && n14 > n3 && this.m_Source.m_pVector[n15 - 1] == this.m_Target.m_pVector[n14 - 1]) {
                    --n15;
                    --n14;
                }
                this.setBackDiag(n18, n15);
                if (!bl && n9 <= n18 && n18 <= n10 && this.getBackDiag(n18) <= this.getFwdDiag(n18)) {
                    this.m_nCost = 2 * n13;
                    return n18;
                }
                n18 -= 2;
            }
            ++n13;
        }
    }

    void outputEditScript(Change change, EditList editList) {
        Change change2 = change;
        while (change2 != null) {
            Change change3 = change2;
            Change change4 = change2;
            change2 = change4.m_pLink;
            change4.m_pLink = null;
            this.outputEditChunk(change3, editList);
            change4.m_pLink = change2;
        }
    }

    void outputEditChunk(Change change, EditList editList) {
        ChunkInfo chunkInfo = this.analyzeEditChunk(change);
        int n = chunkInfo.m_nSrcFirst;
        int n2 = chunkInfo.m_nSrcLast;
        int n3 = chunkInfo.m_nTrgFirst;
        int n4 = chunkInfo.m_nTrgLast;
        int n5 = chunkInfo.m_nDeletes;
        int n6 = chunkInfo.m_nInserts;
        if (n5 == 0 && n6 == 0) {
            return;
        }
        Edit edit = null;
        int n7 = 0;
        int n8 = 0;
        char c = this.getChangeCode(n6, n5);
        switch (c) {
            case 'd': {
                edit = new Edit(2, n + 1, n2 + 1, n3, n3);
                break;
            }
            case 'a': {
                edit = new Edit(1, n, n, n3 + 1, n4 + 1);
                break;
            }
            case 'c': {
                n7 = n2 - n + 1;
                n8 = n4 - n3 + 1;
                edit = new Edit(3, n + 1, n2 + 1, n3 + 1, n4 + 1);
                break;
            }
            default: {
                String string = "StarTeamDiff.outputEditChunk(), code=" + c;
                Assert.internalError(string);
            }
        }
        editList.addChange(edit);
    }

    ChunkInfo analyzeEditChunk(Change change) {
        StarTeamDiff starTeamDiff = this;
        if (starTeamDiff == null) {
            throw null;
        }
        ChunkInfo chunkInfo = starTeamDiff.new ChunkInfo();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n6 = 0;
        n5 = 0;
        n = change.m_n1stDel;
        n3 = change.m_n1stIns;
        Change change2 = change;
        while (change2 != null) {
            n2 = change2.m_n1stDel + change2.m_nDeletes - 1;
            n4 = change2.m_n1stIns + change2.m_nInserts - 1;
            n5 += change2.m_nDeletes;
            n6 += change2.m_nInserts;
            change2 = change2.m_pLink;
        }
        chunkInfo.m_nSrcFirst = n;
        chunkInfo.m_nSrcLast = n2;
        chunkInfo.m_nTrgFirst = n3;
        chunkInfo.m_nTrgLast = n4;
        chunkInfo.m_nDeletes = n5;
        chunkInfo.m_nInserts = n6;
        return chunkInfo;
    }

    char getChangeCode(int n, int n2) {
        if (n == 0) {
            return 'd';
        }
        if (n2 == 0) {
            return 'a';
        }
        return 'c';
    }

    public StarTeamDiff() {
        StarTeamDiff starTeamDiff = this;
        if (starTeamDiff == null) {
            throw null;
        }
        this.m_Source = starTeamDiff.new ArgInfo();
        StarTeamDiff starTeamDiff2 = this;
        if (starTeamDiff2 == null) {
            throw null;
        }
        this.m_Target = starTeamDiff2.new ArgInfo();
        this.m_pAllocFwdDiag = null;
        this.m_pAllocBackDiag = null;
        this.m_nFwdDiagOffset = 0;
        this.m_nBackDiagOffset = 0;
        this.m_nCost = 0;
        this.m_nFreeIndex = 0;
        this.m_compare = null;
    }

    private class ChunkInfo {
        int m_nSrcFirst = 0;
        int m_nSrcLast = 0;
        int m_nTrgFirst = 0;
        int m_nTrgLast = 0;
        int m_nDeletes = 0;
        int m_nInserts = 0;

        ChunkInfo() {
        }
    }

    private class Equivalence {
        Equivalence m_pNext = null;
        LineInfo m_pLine = null;
        int m_nIndex = 0;

        Equivalence(int n) {
            this.m_nIndex = n;
        }
    }

    private class ArgInfo {
        int m_nLines = 0;
        int m_nLastPrefix = 0;
        int m_nFirstSuffix = 0;
        int m_nMaxEquivValue = 0;
        int[] m_pEquivs = null;
        int m_nRemainingLines = 0;
        int[] m_pVector = null;
        char[] m_pChanges = null;
        int[] m_pLineMap = null;
        LineInfo[] m_pLines = null;

        ArgInfo() {
        }
    }

    private class Change {
        Change m_pLink = null;
        int m_nInserts = 0;
        int m_nDeletes = 0;
        int m_n1stDel = 0;
        int m_n1stIns = 0;

        Change() {
        }
    }

    private class LineInfo {
        Object m_pLine = null;
        int m_nLine = 0;
        int m_nHash = 0;

        LineInfo() {
        }
    }
}

