/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.diff;

import com.starbase.diff.CharSequence;
import com.starbase.diff.DiffCompare;
import com.starbase.diff.Sequence;
import java.util.Vector;

public class IntralineSequence
implements Sequence {
    private static final int SYMBOLS = 1;
    private static final int LOWERCASE = 2;
    private static final int LETTERS = 3;
    private static final int WHITE = 4;
    private static final int DIGITS = 5;
    private static DiffCompare m_diffCompareSingleton = null;
    Vector m_fragments = new Vector();

    private static int getCharType(char c) {
        if (Character.isLowerCase(c)) {
            return 3;
        }
        if (Character.isLetter(c)) {
            return 3;
        }
        if (Character.isDigit(c)) {
            return 5;
        }
        if (Character.isWhitespace(c)) {
            return 4;
        }
        return 1;
    }

    private void addFragment(CharSequence charSequence, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 - n);
        int n3 = n;
        while (n3 < n2) {
            stringBuffer.append(charSequence.charAt(n3));
            ++n3;
        }
        this.m_fragments.addElement(stringBuffer.toString());
    }

    public boolean add(Object object) {
        this.m_fragments.addElement(object);
        return true;
    }

    public Object get(int n) {
        return this.m_fragments.elementAt(n);
    }

    public int size() {
        return this.m_fragments.size();
    }

    public static DiffCompare getDiffCompare() {
        if (m_diffCompareSingleton == null) {
            m_diffCompareSingleton = new IntralineDiffCompare();
        }
        return m_diffCompareSingleton;
    }

    public IntralineSequence(CharSequence charSequence) {
        this(charSequence, false);
    }

    public IntralineSequence(CharSequence charSequence, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < charSequence.length()) {
                this.m_fragments.addElement(String.valueOf(charSequence.charAt(n)));
                ++n;
            }
        } else if (charSequence.length() != 0) {
            int n = IntralineSequence.getCharType(charSequence.charAt(0));
            int n2 = 0;
            int n3 = 0;
            while (n3 < charSequence.length()) {
                int n4 = IntralineSequence.getCharType(charSequence.charAt(n3));
                if (n != n4 || n == 1 || n3 == charSequence.length() - 1) {
                    this.addFragment(charSequence, n2, n3);
                    n2 = n3;
                    n = n4;
                }
                ++n3;
            }
            if (n2 < charSequence.length()) {
                this.addFragment(charSequence, n2, charSequence.length());
            }
        }
    }

    private static class IntralineDiffCompare
    implements DiffCompare {
        public int hashObject(Object object) {
            return ((String)object).hashCode();
        }

        public boolean equalObjects(Object object, Object object2) {
            return ((String)object).equals((String)object2);
        }

        IntralineDiffCompare() {
        }
    }
}

