/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.diff;

import com.starbase.diff.CharSequence;
import com.starbase.diff.DiffException;
import com.starbase.diff.HTMLDiffWriter;
import com.starbase.diff.ParsedCharSequence;
import com.starbase.diff.Res;
import com.starbase.diff.ResIDs;
import com.starbase.util.Assert;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;

abstract class HTMLTableDiffWriter
extends HTMLDiffWriter {
    protected static final String CLASSNAME_HEADING = "HD";
    protected static final String CLASSNAME_CELL_HEADING = "CHD";
    protected static final String CLASSNAME_CELL_HEADING2 = "CH2";
    protected static final String CLASSNAME_CELL_FILE_NAME = "CFN";
    protected static final String CLASSNAME_CELL_FILE_NAME2 = "CF2";
    protected static final String CLASSNAME_CELL_NAV = "CNV";
    protected static final String CLASSNAME_CELL_NAVHD = "CNVD";
    protected static final String CLASSNAME_CELL_CHGTYPHD = "CCHD";
    protected static final String CLASSNAME_CELL_CHGTYP_UNCHANGED = "CTU";
    protected static final String CLASSNAME_CELL_CHGTYP_ADDED = "CTA";
    protected static final String CLASSNAME_CELL_CHGTYP_DELETED = "CTD";
    protected static final String CLASSNAME_CELL_CHGTYP_REPLACED = "CTR";
    protected static final String CLASSNAME_CELL_LINE_NUMBERS = "CLN";
    protected static final String CLASSNAME_CELL_LINE_NUMBERSD = "CLND";
    protected static final String CLASSNAME_CELL_LINE_NUMBERS2 = "CL2";
    protected static final String CLASSNAME_CELL_LINE_NUMBERS2D = "CL2D";
    protected static final String CLASSNAME_CELL_UNCHANGED = "CSM";
    protected static final String CLASSNAME_CELL_ADDED = "CAD";
    protected static final String CLASSNAME_CELL_DELETED = "CDL";
    protected static final String CLASSNAME_CELL_REPLACED = "CRL";
    protected static final String CLASSNAME_CELL_PHANTOM = "CPH";
    protected static final String CLASSNAME_CELL_BOR = "CBR";
    protected static final String CSS_SOURCE_TABLE = "class=\"difftabl\"";
    protected static final String CSS_LINE_ADD = "class=\"add\"";
    protected static final String CSS_LINE_DEL = "class=\"del\"";
    protected static final String CSS_LINE_REPL = "class=\"rep\"";
    protected static final String CSS_HEADING = "class=\"HD\"";
    protected static final String CSS_CELL_HEADING = "class=\"CHD\"";
    protected static final String CSS_CELL_HEADING2 = "class=\"CH2\"";
    protected static final String CSS_CELL_FILE_NAME = "class=\"CFN\"";
    protected static final String CSS_CELL_FILE_NAME2 = "class=\"CF2\"";
    protected static final String CSS_CELL_NAV = "class=\"CNV\"";
    protected static final String CSS_CELL_NAVHD = "class=\"CNVD\"";
    protected static final String CSS_CELL_CHGTYPHD = "class=\"CCHD\"";
    protected static final String CSS_CELL_CHGTYP_UNCHANGED = "class=\"CTU\"";
    protected static final String CSS_CELL_CHGTYP_ADDED = "class=\"CTA\"";
    protected static final String CSS_CELL_CHGTYP_DELETED = "class=\"CTD\"";
    protected static final String CSS_CELL_CHGTYP_REPLACED = "class=\"CTR\"";
    protected static final String CSS_CELL_LINE_NUMBERS = "class=\"CLN\"";
    protected static final String CSS_CELL_LINE_NUMBERSD = "class=\"CLND\"";
    protected static final String CSS_CELL_LINE_NUMBERS2 = "class=\"CL2\"";
    protected static final String CSS_CELL_LINE_NUMBERS2D = "class=\"CL2D\"";
    protected static final String CSS_CELL_UNCHANGED = "class=\"CSM\"";
    protected static final String CSS_CELL_ADDED = "class=\"CAD\"";
    protected static final String CSS_CELL_DELETED = "class=\"CDL\"";
    protected static final String CSS_CELL_REPLACED = "class=\"CRL\"";
    protected static final String CSS_CELL_PHANTOM = "class=\"CPH\"";
    protected static final String CSS_CELL_BOR = "class=\"CBR\"";
    String[] m_noLineNumberArguments = new String[]{"{0}", "{1}", "{2}", "{3}", "", "{5}", "{6}", "{7}", "", "{9}", "{10}", "{11}", "{12}", "{13}"};

    private void init() {
        HTMLDiffWriter.HTML_SP = "&nbsp;";
    }

    protected abstract String getRowHeaderHTML();

    protected abstract String getRowFooterHTML();

    protected abstract String getRowBorderHTML();

    protected abstract String getHTMLRowLineSame();

    protected abstract String getHTMLRowLineAdded();

    protected abstract String getHTMLRowLineDeleted();

    protected abstract String getHTMLRowLineReplaced();

    protected abstract String getHTMLRowEllipsis();

    protected void writeClassHeader() throws IOException {
        this.writeln("<TABLE cellspacing=0 cellpadding=0 border=0 width=\"100%\" class=\"difftabl\">");
        this.writeFileNameRow(false);
    }

    protected void writeFileNameRow(boolean bl) throws IOException {
        String string = this.getSourceFileHTML();
        String string2 = this.getTargetFileHTML();
        String[] stringArray = new String[]{null, this.makeUrl(bl ? "#" + this.getLastAnchorName() : "#" + this.getBottomAnchorName(), bl ? this.getGotoLastDiffHTML() : this.getGotoBottomHTML(), bl ? Res.getString(ResIDs.LAST_DIFF) : Res.getString(ResIDs.END_OF_FILE)), this.makeUrl(bl ? "#" + this.getTopAnchorName() : "#" + this.getFirstAnchorName(), bl ? this.getGotoTopHTML() : this.getGotoFirstDiffHTML(), bl ? Res.getString(ResIDs.TOP_OF_FILE) : Res.getString(ResIDs.FIRST_DIFF)), this.makeUrl(this.getSourceFileURL(), string != null ? string : Res.getString(ResIDs.SOURCE_FILE), null), this.makeUrl(this.getTargetFileURL(), string2 != null ? string2 : Res.getString(ResIDs.TARGET_FILE), null)};
        if (bl) {
            this.write(this.getRowBorderHTML());
        }
        this.write(HTMLTableDiffWriter.messageFormat(bl ? this.getRowFooterHTML() : this.getRowHeaderHTML(), stringArray));
        if (!bl) {
            this.write(this.getRowBorderHTML());
        }
    }

    protected void writeClassStyles() throws IOException {
        this.writeln(".HD { COLOR: white; FONT-WEIGHT: bold; TEXT-ALIGN: center }");
        this.writeln(".HD A:link { COLOR: white; FONT-WEIGHT: bold }");
        this.writeln(".HD A:active { COLOR: white; FONT-WEIGHT: bold }");
        this.writeln(".HD A:visited { COLOR: white; FONT-WEIGHT: bold }");
        this.writeln(".CHD { BACKGROUND-COLOR: maroon; PADDING-BOTTOM: 4pt; PADDING-LEFT: 4pt; PADDING-RIGHT: 4pt; PADDING-TOP: 4pt; TEXT-ALIGN: center }");
        this.writeln(".CH2 { BACKGROUND-COLOR: navy; TEXT-ALIGN: center }");
        this.writeln(".CFN { BACKGROUND-COLOR: maroon; COLOR: white; FONT-WEIGHT: bold; PADDING-BOTTOM: 4pt; PADDING-LEFT: 4pt; PADDING-RIGHT: 4pt; PADDING-TOP: 4pt }");
        this.writeln(".CF2 { BACKGROUND-COLOR: navy; COLOR: white; FONT-WEIGHT: bold; PADDING-BOTTOM: 4pt; PADDING-LEFT: 4pt; PADDING-RIGHT: 4pt; PADDING-TOP: 4pt }");
        this.writeln(".CNV { }");
        this.writeln(".CNVD { FONT-FAMILY: 'Courier New', Courier, Fixed }");
        this.writeln(".CCHD { FONT-FAMILY: 'Courier New', Courier, Fixed; PADDING-LEFT: 4pt; PADDING-RIGHT: 4pt }");
        this.writeln(".CTU { FONT-FAMILY: 'Courier New', Courier, Fixed; PADDING-LEFT: 4pt; PADDING-RIGHT: 4pt }");
        this.writeln(".CTA { COLOR: green; FONT-FAMILY: 'Courier New', Courier, Fixed; PADDING-LEFT: 4pt; PADDING-RIGHT: 4pt }");
        this.writeln(".CTD { COLOR: red; FONT-FAMILY: 'Courier New', Courier, Fixed; PADDING-LEFT: 4pt; PADDING-RIGHT: 4pt }");
        this.writeln(".CTR { COLOR: blue; FONT-FAMILY: 'Courier New', Courier, Fixed; PADDING-LEFT: 4pt; PADDING-RIGHT: 4pt }");
        this.writeln(".CLN { BACKGROUND-COLOR: maroon; COLOR: white; PADDING-LEFT: 4pt; PADDING-RIGHT: 4pt; TEXT-ALIGN: right }");
        this.writeln(".CLND { BACKGROUND-COLOR: maroon; COLOR: white; PADDING-LEFT: 4pt; PADDING-RIGHT: 4pt; TEXT-ALIGN: right }");
        this.writeln(".CL2 { BACKGROUND-COLOR: navy; COLOR: white; PADDING-LEFT: 4pt; PADDING-RIGHT: 4pt; TEXT-ALIGN: right }");
        this.writeln(".CL2D { BACKGROUND-COLOR: navy; COLOR: white; PADDING-LEFT: 4pt; PADDING-RIGHT: 4pt; TEXT-ALIGN: right }");
        this.writeln(".CSM { }");
        this.writeln(".CAD { }");
        this.writeln(".CDL { }");
        this.writeln(".CRL { }");
        this.writeln(".CPH { BACKGROUND-COLOR: silver }");
        this.writeln(".CBR { BACKGROUND-COLOR: silver }");
    }

    protected void writeClassFooter() throws IOException {
        this.writeFileNameRow(true);
        this.writeln("</TABLE>");
    }

    public void unchangedLines(int n, int n2, int n3) throws IOException {
        block8: {
            int n4;
            int n5;
            boolean bl;
            boolean bl2;
            boolean bl3;
            block7: {
                if (n3 == 0) {
                    return;
                }
                if (!this.getShowUnchangedLines()) {
                    return;
                }
                bl3 = n == 1 && n2 == 1;
                bl2 = n + n3 - 1 == this.m_sourceLength && n2 + n3 - 1 == this.m_targetLength;
                bl = bl3 || bl2;
                n5 = this.getNumContextLines();
                if (n5 >= 0 && (!bl || n5 < n3) && (bl || 2 * n5 < n3)) break block7;
                int n6 = 0;
                while (n6 < n3) {
                    this.doUnchangedLine(n + n6, n2 + n6);
                    ++n6;
                }
                break block8;
            }
            if (!bl3) {
                n4 = 0;
                while (n4 < n5) {
                    this.doUnchangedLine(n + n4, n2 + n4);
                    ++n4;
                }
            }
            if (!bl) {
                this.writeEllipsis();
            }
            if (bl2) break block8;
            n4 = n3 - n5;
            while (n4 < n3) {
                this.doUnchangedLine(n + n4, n2 + n4);
                ++n4;
            }
        }
    }

    protected void doUnchangedLine(int n, int n2) throws IOException {
        String[] stringArray = new String[]{"", null, "", "", null, null, "", "", null, null, CSS_CELL_LINE_NUMBERS, "", CSS_CELL_LINE_NUMBERS, ""};
        stringArray[1] = this.getFormattedUnchangedSymbol();
        stringArray[4] = this.makeLineNumber(n);
        stringArray[5] = this.makeSourceLine(this.m_source.getLine(n - 1));
        stringArray[8] = this.makeLineNumber(n2);
        stringArray[9] = this.makeSourceLine(this.m_target.getLine(n2 - 1));
        this.write(HTMLTableDiffWriter.messageFormat(this.getHTMLRowLineSame(), stringArray));
    }

    protected void writeEllipsis() throws IOException {
        this.write(this.getHTMLRowEllipsis());
    }

    public void insertLines(int n, int n2, int n3) throws IOException {
        String[] stringArray = new String[]{null, null, CSS_CELL_PHANTOM, "", "&nbsp;", "&nbsp;", CSS_CELL_ADDED, CSS_LINE_ADD, null, null, CSS_CELL_PHANTOM, "", CSS_CELL_LINE_NUMBERS, ""};
        boolean bl = true;
        ++this.m_anchornum;
        int n4 = 0;
        while (n4 < n3) {
            stringArray[0] = this.makeNav(bl);
            stringArray[1] = this.getFormattedAddedSymbol();
            stringArray[8] = this.makeLineNumber(n2 + n4);
            stringArray[9] = this.makeSourceLine(this.m_target.getLine(n2 + n4 - 1));
            this.write(HTMLTableDiffWriter.messageFormat(this.getHTMLRowLineAdded(), stringArray));
            bl = this.getNavigateOnEveryChangedLine();
            ++n4;
        }
    }

    public void deleteLines(int n, int n2, int n3) throws IOException {
        String[] stringArray = new String[]{null, null, CSS_CELL_DELETED, CSS_LINE_DEL, null, null, CSS_CELL_PHANTOM, "", "&nbsp;", "&nbsp;", CSS_CELL_LINE_NUMBERS, "", CSS_CELL_PHANTOM, CSS_CELL_PHANTOM};
        boolean bl = true;
        ++this.m_anchornum;
        int n4 = 0;
        while (n4 < n3) {
            stringArray[0] = this.makeNav(bl);
            stringArray[1] = this.getFormattedDeletedSymbol();
            stringArray[4] = this.makeLineNumber(n + n4);
            stringArray[5] = this.makeSourceLine(this.m_source.getLine(n + n4 - 1));
            this.write(HTMLTableDiffWriter.messageFormat(this.getHTMLRowLineDeleted(), stringArray));
            bl = this.getNavigateOnEveryChangedLine();
            ++n4;
        }
    }

    public void replaceLines(int n, int n2, int n3, int n4) throws IOException {
        if (!this.getShowInlineDiffs() || n2 != n4) {
            this.insertLines(n, n3, n4);
            this.deleteLines(n, n3, n2);
        } else {
            String[] stringArray = new String[]{null, null, CSS_CELL_REPLACED, CSS_LINE_REPL, null, null, CSS_CELL_REPLACED, CSS_LINE_REPL, null, null, CSS_CELL_LINE_NUMBERS, "", CSS_CELL_LINE_NUMBERS, ""};
            boolean bl = true;
            ++this.m_anchornum;
            int n5 = 0;
            while (n5 < n2) {
                int n6 = n + n5;
                int n7 = n3 + n5;
                CharSequence charSequence = this.m_source.getLine(n6 - 1);
                CharSequence charSequence2 = this.m_target.getLine(n7 - 1);
                try {
                    HTMLTableDiffWriter hTMLTableDiffWriter = this;
                    if (hTMLTableDiffWriter == null) {
                        throw null;
                    }
                    HTMLDiffWriter.IntralineDiff intralineDiff = hTMLTableDiffWriter.new HTMLDiffWriter.IntralineDiff(charSequence, charSequence2);
                    String string = this.getLeftReplaceText(intralineDiff);
                    String string2 = this.getRightReplaceText(intralineDiff);
                    stringArray[0] = this.makeNav(bl);
                    stringArray[1] = this.getFormattedReplacedSymbol();
                    stringArray[4] = this.makeLineNumber(n6);
                    stringArray[5] = string;
                    stringArray[8] = this.makeLineNumber(n7);
                    stringArray[9] = string2;
                    this.write(HTMLTableDiffWriter.messageFormat(this.getHTMLRowLineReplaced(), stringArray));
                    bl = this.getNavigateOnEveryChangedLine();
                }
                catch (DiffException diffException) {
                    // empty catch block
                }
                ++n5;
            }
        }
    }

    protected abstract String getLeftReplaceText(HTMLDiffWriter.IntralineDiff var1) throws IOException;

    protected abstract String getRightReplaceText(HTMLDiffWriter.IntralineDiff var1) throws IOException;

    private static String messageFormat(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("{")) {
                String string3 = stringTokenizer.nextToken();
                stringBuffer.append(stringArray[Integer.parseInt(string3)]);
                if (stringTokenizer.nextToken().equals("}")) continue;
                Assert.internalError("HTMLTableDiffWriter.messageFormat()");
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected String getHTMLRowLine_LineNumbers(String string) {
        return this.getShowLineNumbers() ? string : HTMLTableDiffWriter.messageFormat(string, this.m_noLineNumberArguments);
    }

    protected String makeLineNumber(int n) {
        return n > 0 ? String.valueOf(n) : "";
    }

    protected String getFormattedUnchangedSymbol() {
        String string = this.getUnchangedSymbolHTML();
        if (string.equals("&nbsp;")) {
            string = "";
        }
        return string;
    }

    protected String getFormattedAddedSymbol() {
        return this.getAddedSymbolHTML();
    }

    protected String getFormattedDeletedSymbol() {
        return this.getDeletedSymbolHTML();
    }

    protected String getFormattedReplacedSymbol() {
        return this.getReplacedSymbolHTML();
    }

    protected HTMLTableDiffWriter(ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2, File file) throws IOException {
        super(parsedCharSequence, parsedCharSequence2, file);
        this.init();
    }

    protected HTMLTableDiffWriter(ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2, BufferedWriter bufferedWriter) {
        this(parsedCharSequence, parsedCharSequence2, (Writer)bufferedWriter);
    }

    protected HTMLTableDiffWriter(ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2, Writer writer) {
        super(parsedCharSequence, parsedCharSequence2, writer);
        this.init();
    }
}

