/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.packet.VCard;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VCardProvider
implements IQProvider {
    public IQ parseIQ(XmlPullParser parser) throws Exception {
        StringBuffer sb = new StringBuffer();
        try {
            int event = parser.getEventType();
            while (true) {
                switch (event) {
                    case 4: {
                        sb.append(parser.getText());
                        break;
                    }
                    case 2: {
                        sb.append('<' + parser.getName() + '>');
                        break;
                    }
                    case 3: {
                        sb.append("</" + parser.getName() + '>');
                        break;
                    }
                }
                if (event != 3 || !"vCard".equals(parser.getName())) {
                    event = parser.next();
                    continue;
                }
                break;
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String xmlText = sb.toString();
        VCard vCard = new VCard();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(xmlText.getBytes()));
            new VCardReader(vCard, document).initializeFields();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return vCard;
    }

    private class VCardReader {
        private final VCard vCard;
        private final Document document;

        VCardReader(VCard vCard, Document document) {
            this.vCard = vCard;
            this.document = document;
        }

        public void initializeFields() {
            this.vCard.setFirstName(this.getTagContents("GIVEN"));
            this.vCard.setLastName(this.getTagContents("FAMILY"));
            this.vCard.setMiddleName(this.getTagContents("MIDDLE"));
            this.setupEmails();
            this.vCard.setOrganization(this.getTagContents("ORGNAME"));
            this.vCard.setOrganizationUnit(this.getTagContents("ORGUNIT"));
            this.setupSimpleFields();
            this.setupPhones("WORK", true);
            this.setupPhones("HOME", false);
            this.setupAddress("WORK", true);
            this.setupAddress("HOME", false);
        }

        private void setupEmails() {
            NodeList nodes = this.document.getElementsByTagName("USERID");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                if ("WORK".equals(element.getParentNode().getFirstChild().getNodeName())) {
                    this.vCard.setEmailWork(this.getTextContent(element));
                    continue;
                }
                this.vCard.setEmailHome(this.getTextContent(element));
            }
        }

        private void setupPhones(String type, boolean work) {
            NodeList allPhones = this.document.getElementsByTagName("TEL");
            for (int i = 0; i < allPhones.getLength(); ++i) {
                Element node = (Element)allPhones.item(i);
                if (!type.equals(node.getChildNodes().item(1).getNodeName())) continue;
                String code = node.getFirstChild().getNodeName();
                String value = this.getTextContent(node.getChildNodes().item(2));
                if (work) {
                    this.vCard.setPhoneWork(code, value);
                    continue;
                }
                this.vCard.setPhoneHome(code, value);
            }
        }

        private void setupAddress(String type, boolean work) {
            NodeList allAddresses = this.document.getElementsByTagName("ADR");
            for (int i = 0; i < allAddresses.getLength(); ++i) {
                Element node = (Element)allAddresses.item(i);
                NodeList childNodes = node.getChildNodes();
                if (!type.equals(childNodes.item(0).getNodeName())) continue;
                for (int j = 1; j < childNodes.getLength(); ++j) {
                    Node item = childNodes.item(j);
                    if (!(item instanceof Element)) continue;
                    if (work) {
                        this.vCard.setAddressFieldWork(item.getNodeName(), this.getTextContent(item));
                        continue;
                    }
                    this.vCard.setAddressFieldHome(item.getNodeName(), this.getTextContent(item));
                }
            }
        }

        private String getTagContents(String tag) {
            NodeList nodes = this.document.getElementsByTagName(tag);
            if (nodes.getLength() == 1) {
                return this.getTextContent(nodes.item(0));
            }
            return null;
        }

        private void setupSimpleFields() {
            NodeList childNodes = this.document.getDocumentElement().getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Element element;
                Node node = childNodes.item(i);
                if (!(node instanceof Element) || "FN".equals((element = (Element)node).getNodeName())) continue;
                if (element.getChildNodes().getLength() == 0) {
                    this.vCard.setField(element.getNodeName(), "");
                    continue;
                }
                if (element.getChildNodes().getLength() != 1 || !(element.getChildNodes().item(0) instanceof Text)) continue;
                this.vCard.setField(element.getNodeName(), this.getTextContent(element));
            }
        }

        private String getTextContent(Node node) {
            StringBuffer result = new StringBuffer();
            this.appendText(result, node);
            return result.toString();
        }

        private void appendText(StringBuffer result, Node node) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node nd = childNodes.item(i);
                String nodeValue = nd.getNodeValue();
                if (nodeValue != null) {
                    result.append(nodeValue);
                }
                this.appendText(result, nd);
            }
        }
    }
}

