/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionEstablishedListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.NodeInformationProvider;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.InvitationRejectionListener;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.packet.MUCAdmin;
import org.jivesoftware.smackx.packet.MUCInitialPresence;
import org.jivesoftware.smackx.packet.MUCOwner;
import org.jivesoftware.smackx.packet.MUCUser;

public class MultiUserChat {
    private static final String discoNamespace = "http://jabber.org/protocol/muc";
    private static final String discoNode = "http://jabber.org/protocol/muc#rooms";
    private static Map joinedRooms = new WeakHashMap();
    private XMPPConnection connection;
    private String room;
    private String subject;
    private String nickname = null;
    private boolean joined = false;
    private Map occupantsMap = new HashMap();
    private List invitationRejectionListeners = new ArrayList();
    private List subjectUpdatedListeners = new ArrayList();
    private List userStatusListeners = new ArrayList();
    private List participantStatusListeners = new ArrayList();
    private PacketFilter presenceFilter;
    private PacketListener presenceListener;
    private PacketFilter subjectFilter;
    private PacketListener subjectListener;
    private PacketFilter messageFilter;
    private PacketFilter declinesFilter;
    private PacketListener declinesListener;
    private PacketCollector messageCollector;
    private List connectionListeners = new ArrayList();
    static /* synthetic */ Class class$org$jivesoftware$smack$packet$Presence;
    static /* synthetic */ Class class$org$jivesoftware$smack$packet$IQ;
    static /* synthetic */ Class class$org$jivesoftware$smack$packet$Message;
    static /* synthetic */ Class class$org$jivesoftware$smackx$muc$UserStatusListener;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jivesoftware$smackx$muc$ParticipantStatusListener;

    public MultiUserChat(XMPPConnection connection, String room) {
        this.connection = connection;
        this.room = room.toLowerCase();
        this.init();
    }

    public static boolean isServiceEnabled(XMPPConnection connection, String user) {
        try {
            DiscoverInfo result = ServiceDiscoveryManager.getInstanceFor(connection).discoverInfo(user);
            return result.containsFeature(discoNamespace);
        }
        catch (XMPPException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Iterator getJoinedRooms(XMPPConnection connection) {
        ArrayList rooms = (ArrayList)joinedRooms.get(connection);
        if (rooms != null) {
            return rooms.iterator();
        }
        return new ArrayList().iterator();
    }

    public static Iterator getJoinedRooms(XMPPConnection connection, String user) {
        try {
            ArrayList<String> answer = new ArrayList<String>();
            DiscoverItems result = ServiceDiscoveryManager.getInstanceFor(connection).discoverItems(user, discoNode);
            Iterator items = result.getItems();
            while (items.hasNext()) {
                answer.add(((DiscoverItems.Item)items.next()).getEntityID());
            }
            return answer.iterator();
        }
        catch (XMPPException e) {
            e.printStackTrace();
            return new ArrayList().iterator();
        }
    }

    public static RoomInfo getRoomInfo(XMPPConnection connection, String room) throws XMPPException {
        DiscoverInfo info = ServiceDiscoveryManager.getInstanceFor(connection).discoverInfo(room);
        return new RoomInfo(info);
    }

    public static Collection getServiceNames(XMPPConnection connection) throws XMPPException {
        ArrayList<String> answer = new ArrayList<String>();
        ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor(connection);
        DiscoverItems items = discoManager.discoverItems(connection.getServiceName());
        Iterator it = items.getItems();
        while (it.hasNext()) {
            DiscoverItems.Item item = (DiscoverItems.Item)it.next();
            DiscoverInfo info = discoManager.discoverInfo(item.getEntityID());
            if (!info.containsFeature(discoNamespace)) continue;
            answer.add(item.getEntityID());
        }
        return answer;
    }

    public static Collection getHostedRooms(XMPPConnection connection, String serviceName) throws XMPPException {
        ArrayList<HostedRoom> answer = new ArrayList<HostedRoom>();
        ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor(connection);
        DiscoverItems items = discoManager.discoverItems(serviceName);
        Iterator it = items.getItems();
        while (it.hasNext()) {
            DiscoverItems.Item item = (DiscoverItems.Item)it.next();
            answer.add(new HostedRoom(item));
        }
        return answer;
    }

    public String getRoom() {
        return this.room;
    }

    public synchronized void create(String nickname) throws XMPPException {
        if (nickname == null || nickname.equals("")) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (this.joined) {
            throw new IllegalStateException("Creation failed - User already joined the room.");
        }
        Presence joinPresence = new Presence(Presence.Type.AVAILABLE);
        joinPresence.setTo(this.room + "/" + nickname);
        joinPresence.addExtension(new MUCInitialPresence());
        AndFilter responseFilter = new AndFilter(new FromMatchesFilter(this.room + "/" + nickname), new PacketTypeFilter(class$org$jivesoftware$smack$packet$Presence == null ? (class$org$jivesoftware$smack$packet$Presence = MultiUserChat.class$("org.jivesoftware.smack.packet.Presence")) : class$org$jivesoftware$smack$packet$Presence));
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(joinPresence);
        Presence presence = (Presence)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (presence == null) {
            throw new XMPPException("No response from server.");
        }
        if (presence.getError() != null) {
            throw new XMPPException(presence.getError());
        }
        this.nickname = nickname;
        this.joined = true;
        this.userHasJoined();
        MUCUser mucUser = this.getMUCUserExtension(presence);
        if (mucUser != null && mucUser.getStatus() != null && "201".equals(mucUser.getStatus().getCode())) {
            return;
        }
        this.leave();
        throw new XMPPException("Creation failed - Missing acknowledge of room creation.");
    }

    public void join(String nickname) throws XMPPException {
        this.join(nickname, null, null, SmackConfiguration.getPacketReplyTimeout());
    }

    public void join(String nickname, String password) throws XMPPException {
        this.join(nickname, password, null, SmackConfiguration.getPacketReplyTimeout());
    }

    public synchronized void join(String nickname, String password, DiscussionHistory history, long timeout) throws XMPPException {
        if (nickname == null || nickname.equals("")) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (this.joined) {
            this.leave();
        }
        Presence joinPresence = new Presence(Presence.Type.AVAILABLE);
        joinPresence.setTo(this.room + "/" + nickname);
        MUCInitialPresence mucInitialPresence = new MUCInitialPresence();
        if (password != null) {
            mucInitialPresence.setPassword(password);
        }
        if (history != null) {
            mucInitialPresence.setHistory(history.getMUCHistory());
        }
        joinPresence.addExtension(mucInitialPresence);
        AndFilter responseFilter = new AndFilter(new FromMatchesFilter(this.room + "/" + nickname), new PacketTypeFilter(class$org$jivesoftware$smack$packet$Presence == null ? (class$org$jivesoftware$smack$packet$Presence = MultiUserChat.class$("org.jivesoftware.smack.packet.Presence")) : class$org$jivesoftware$smack$packet$Presence));
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(joinPresence);
        Presence presence = (Presence)response.nextResult(timeout);
        response.cancel();
        if (presence == null) {
            throw new XMPPException("No response from server.");
        }
        if (presence.getError() != null) {
            throw new XMPPException(presence.getError());
        }
        this.nickname = nickname;
        this.joined = true;
        this.userHasJoined();
    }

    public boolean isJoined() {
        return this.joined;
    }

    public synchronized void leave() {
        if (!this.joined) {
            return;
        }
        Presence leavePresence = new Presence(Presence.Type.UNAVAILABLE);
        leavePresence.setTo(this.room + "/" + this.nickname);
        this.connection.sendPacket(leavePresence);
        this.occupantsMap = new HashMap();
        this.nickname = null;
        this.joined = false;
        this.userHasLeft();
    }

    public Form getConfigurationForm() throws XMPPException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.GET);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
        return Form.getFormFrom(answer);
    }

    public void sendConfigurationForm(Form form) throws XMPPException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        iq.addExtension(form.getDataFormToSend());
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    public Form getRegistrationForm() throws XMPPException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.GET);
        reg.setTo(this.room);
        AndFilter filter = new AndFilter(new PacketIDFilter(reg.getPacketID()), new PacketTypeFilter(class$org$jivesoftware$smack$packet$IQ == null ? (class$org$jivesoftware$smack$packet$IQ = MultiUserChat.class$("org.jivesoftware.smack.packet.IQ")) : class$org$jivesoftware$smack$packet$IQ));
        PacketCollector collector = this.connection.createPacketCollector(filter);
        this.connection.sendPacket(reg);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
        return Form.getFormFrom(result);
    }

    public void sendRegistrationForm(Form form) throws XMPPException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.SET);
        reg.setTo(this.room);
        reg.addExtension(form.getDataFormToSend());
        AndFilter filter = new AndFilter(new PacketIDFilter(reg.getPacketID()), new PacketTypeFilter(class$org$jivesoftware$smack$packet$IQ == null ? (class$org$jivesoftware$smack$packet$IQ = MultiUserChat.class$("org.jivesoftware.smack.packet.IQ")) : class$org$jivesoftware$smack$packet$IQ));
        PacketCollector collector = this.connection.createPacketCollector(filter);
        this.connection.sendPacket(reg);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
    }

    public void destroy(String reason, String alternateJID) throws XMPPException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        MUCOwner.Destroy destroy = new MUCOwner.Destroy();
        destroy.setReason(reason);
        destroy.setJid(alternateJID);
        iq.setDestroy(destroy);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
        this.occupantsMap = new HashMap();
        this.nickname = null;
        this.joined = false;
        this.userHasLeft();
    }

    public void invite(String user, String reason) {
        this.invite(new Message(), user, reason);
    }

    public void invite(Message message, String user, String reason) {
        message.setTo(this.room);
        MUCUser mucUser = new MUCUser();
        MUCUser.Invite invite = new MUCUser.Invite();
        invite.setTo(user);
        invite.setReason(reason);
        mucUser.setInvite(invite);
        message.addExtension(mucUser);
        this.connection.sendPacket(message);
    }

    public static void decline(XMPPConnection conn, String room, String inviter, String reason) {
        Message message = new Message(room);
        MUCUser mucUser = new MUCUser();
        MUCUser.Decline decline = new MUCUser.Decline();
        decline.setTo(inviter);
        decline.setReason(reason);
        mucUser.setDecline(decline);
        message.addExtension(mucUser);
        conn.sendPacket(message);
    }

    public static void addInvitationListener(XMPPConnection conn, InvitationListener listener) {
        InvitationsMonitor.getInvitationsMonitor(conn).addInvitationListener(listener);
    }

    public static void removeInvitationListener(XMPPConnection conn, InvitationListener listener) {
        InvitationsMonitor.getInvitationsMonitor(conn).removeInvitationListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationRejectionListener(InvitationRejectionListener listener) {
        List list = this.invitationRejectionListeners;
        synchronized (list) {
            if (!this.invitationRejectionListeners.contains(listener)) {
                this.invitationRejectionListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitationRejectionListener(InvitationRejectionListener listener) {
        List list = this.invitationRejectionListeners;
        synchronized (list) {
            this.invitationRejectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInvitationRejectionListeners(String invitee, String reason) {
        InvitationRejectionListener[] listeners = null;
        List list = this.invitationRejectionListeners;
        synchronized (list) {
            listeners = new InvitationRejectionListener[this.invitationRejectionListeners.size()];
            this.invitationRejectionListeners.toArray(listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].invitationDeclined(invitee, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubjectUpdatedListener(SubjectUpdatedListener listener) {
        List list = this.subjectUpdatedListeners;
        synchronized (list) {
            if (!this.subjectUpdatedListeners.contains(listener)) {
                this.subjectUpdatedListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubjectUpdatedListener(SubjectUpdatedListener listener) {
        List list = this.subjectUpdatedListeners;
        synchronized (list) {
            this.subjectUpdatedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSubjectUpdatedListeners(String subject, String from) {
        SubjectUpdatedListener[] listeners = null;
        List list = this.subjectUpdatedListeners;
        synchronized (list) {
            listeners = new SubjectUpdatedListener[this.subjectUpdatedListeners.size()];
            this.subjectUpdatedListeners.toArray(listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].subjectUpdated(subject, from);
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public String getReservedNickname() {
        try {
            DiscoverInfo result = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(this.room, "x-roomuser-item");
            Iterator identities = result.getIdentities();
            if (identities.hasNext()) {
                DiscoverInfo.Identity identity = (DiscoverInfo.Identity)identities.next();
                return identity.getName();
            }
            return null;
        }
        catch (XMPPException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getNickname() {
        return this.nickname;
    }

    public void changeNickname(String nickname) throws XMPPException {
        if (nickname == null || nickname.equals("")) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (!this.joined) {
            throw new IllegalStateException("Must be logged into the room to change nickname.");
        }
        Presence joinPresence = new Presence(Presence.Type.AVAILABLE);
        joinPresence.setTo(this.room + "/" + nickname);
        AndFilter responseFilter = new AndFilter(new FromMatchesFilter(this.room + "/" + nickname), new PacketTypeFilter(class$org$jivesoftware$smack$packet$Presence == null ? (class$org$jivesoftware$smack$packet$Presence = MultiUserChat.class$("org.jivesoftware.smack.packet.Presence")) : class$org$jivesoftware$smack$packet$Presence));
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(joinPresence);
        Presence presence = (Presence)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (presence == null) {
            throw new XMPPException("No response from server.");
        }
        if (presence.getError() != null) {
            throw new XMPPException(presence.getError());
        }
        this.nickname = nickname;
    }

    public void changeAvailabilityStatus(String status, Presence.Mode mode) {
        if (this.nickname == null || this.nickname.equals("")) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (!this.joined) {
            throw new IllegalStateException("Must be logged into the room to change the availability status.");
        }
        Presence joinPresence = new Presence(Presence.Type.AVAILABLE);
        joinPresence.setStatus(status);
        joinPresence.setMode(mode);
        joinPresence.setTo(this.room + "/" + this.nickname);
        this.connection.sendPacket(joinPresence);
    }

    public void kickParticipant(String nickname, String reason) throws XMPPException {
        this.changeRole(nickname, "none", reason);
    }

    public void grantVoice(Collection nicknames) throws XMPPException {
        this.changeRole(nicknames, "participant");
    }

    public void grantVoice(String nickname) throws XMPPException {
        this.changeRole(nickname, "participant", null);
    }

    public void revokeVoice(Collection nicknames) throws XMPPException {
        this.changeRole(nicknames, "visitor");
    }

    public void revokeVoice(String nickname) throws XMPPException {
        this.changeRole(nickname, "visitor", null);
    }

    public void banUsers(Collection jids) throws XMPPException {
        this.changeAffiliationByAdmin(jids, "outcast");
    }

    public void banUser(String jid, String reason) throws XMPPException {
        this.changeAffiliationByAdmin(jid, "outcast", reason);
    }

    public void grantMembership(Collection jids) throws XMPPException {
        this.changeAffiliationByAdmin(jids, "member");
    }

    public void grantMembership(String jid) throws XMPPException {
        this.changeAffiliationByAdmin(jid, "member", null);
    }

    public void revokeMembership(Collection jids) throws XMPPException {
        this.changeAffiliationByAdmin(jids, "none");
    }

    public void revokeMembership(String jid) throws XMPPException {
        this.changeAffiliationByAdmin(jid, "none", null);
    }

    public void grantModerator(Collection nicknames) throws XMPPException {
        this.changeRole(nicknames, "moderator");
    }

    public void grantModerator(String nickname) throws XMPPException {
        this.changeRole(nickname, "moderator", null);
    }

    public void revokeModerator(Collection nicknames) throws XMPPException {
        this.changeRole(nicknames, "participant");
    }

    public void revokeModerator(String nickname) throws XMPPException {
        this.changeRole(nickname, "participant", null);
    }

    public void grantOwnership(Collection jids) throws XMPPException {
        this.changeAffiliationByOwner(jids, "owner");
    }

    public void grantOwnership(String jid) throws XMPPException {
        this.changeAffiliationByOwner(jid, "owner");
    }

    public void revokeOwnership(Collection jids) throws XMPPException {
        this.changeAffiliationByOwner(jids, "admin");
    }

    public void revokeOwnership(String jid) throws XMPPException {
        this.changeAffiliationByOwner(jid, "admin");
    }

    public void grantAdmin(Collection jids) throws XMPPException {
        this.changeAffiliationByOwner(jids, "admin");
    }

    public void grantAdmin(String jid) throws XMPPException {
        this.changeAffiliationByOwner(jid, "admin");
    }

    public void revokeAdmin(Collection jids) throws XMPPException {
        this.changeAffiliationByOwner(jids, "member");
    }

    public void revokeAdmin(String jid) throws XMPPException {
        this.changeAffiliationByOwner(jid, "member");
    }

    private void changeAffiliationByOwner(String jid, String affiliation) throws XMPPException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        MUCOwner.Item item = new MUCOwner.Item(affiliation);
        item.setJid(jid);
        iq.addItem(item);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    private void changeAffiliationByOwner(Collection jids, String affiliation) throws XMPPException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        Iterator it = jids.iterator();
        while (it.hasNext()) {
            MUCOwner.Item item = new MUCOwner.Item(affiliation);
            item.setJid((String)it.next());
            iq.addItem(item);
        }
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    private void changeAffiliationByAdmin(String jid, String affiliation, String reason) throws XMPPException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        MUCAdmin.Item item = new MUCAdmin.Item(affiliation, null);
        item.setJid(jid);
        item.setReason(reason);
        iq.addItem(item);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    private void changeAffiliationByAdmin(Collection jids, String affiliation) throws XMPPException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        Iterator it = jids.iterator();
        while (it.hasNext()) {
            MUCAdmin.Item item = new MUCAdmin.Item(affiliation, null);
            item.setJid((String)it.next());
            iq.addItem(item);
        }
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    private void changeRole(String nickname, String role, String reason) throws XMPPException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        MUCAdmin.Item item = new MUCAdmin.Item(null, role);
        item.setNick(nickname);
        item.setReason(reason);
        iq.addItem(item);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    private void changeRole(Collection nicknames, String role) throws XMPPException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        Iterator it = nicknames.iterator();
        while (it.hasNext()) {
            MUCAdmin.Item item = new MUCAdmin.Item(null, role);
            item.setNick((String)it.next());
            iq.addItem(item);
        }
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOccupantsCount() {
        Map map = this.occupantsMap;
        synchronized (map) {
            return this.occupantsMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getOccupants() {
        Map map = this.occupantsMap;
        synchronized (map) {
            return Collections.unmodifiableList(new ArrayList(this.occupantsMap.keySet())).iterator();
        }
    }

    public Presence getOccupantPresence(String user) {
        return (Presence)this.occupantsMap.get(user);
    }

    public Occupant getOccupant(String user) {
        Presence presence = (Presence)this.occupantsMap.get(user);
        if (presence != null) {
            return new Occupant(presence);
        }
        return null;
    }

    public void addParticipantListener(PacketListener listener) {
        this.connection.addPacketListener(listener, this.presenceFilter);
        this.connectionListeners.add(listener);
    }

    public void removeParticipantListener(PacketListener listener) {
        this.connection.removePacketListener(listener);
        this.connectionListeners.remove(listener);
    }

    public Collection getOwners() throws XMPPException {
        return this.getAffiliatesByOwner("owner");
    }

    public Collection getAdmins() throws XMPPException {
        return this.getAffiliatesByOwner("admin");
    }

    public Collection getMembers() throws XMPPException {
        return this.getAffiliatesByAdmin("member");
    }

    public Collection getOutcasts() throws XMPPException {
        return this.getAffiliatesByAdmin("outcast");
    }

    private Collection getAffiliatesByOwner(String affiliation) throws XMPPException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.GET);
        MUCOwner.Item item = new MUCOwner.Item(affiliation);
        iq.addItem(item);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        MUCOwner answer = (MUCOwner)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
        ArrayList<Affiliate> affiliates = new ArrayList<Affiliate>();
        Iterator it = answer.getItems();
        while (it.hasNext()) {
            affiliates.add(new Affiliate((MUCOwner.Item)it.next()));
        }
        return affiliates;
    }

    private Collection getAffiliatesByAdmin(String affiliation) throws XMPPException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.GET);
        MUCAdmin.Item item = new MUCAdmin.Item(affiliation, null);
        iq.addItem(item);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        MUCAdmin answer = (MUCAdmin)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
        ArrayList<Affiliate> affiliates = new ArrayList<Affiliate>();
        Iterator it = answer.getItems();
        while (it.hasNext()) {
            affiliates.add(new Affiliate((MUCAdmin.Item)it.next()));
        }
        return affiliates;
    }

    public Collection getModerators() throws XMPPException {
        return this.getOccupants("moderator");
    }

    public Collection getParticipants() throws XMPPException {
        return this.getOccupants("participant");
    }

    private Collection getOccupants(String role) throws XMPPException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.GET);
        MUCAdmin.Item item = new MUCAdmin.Item(null, role);
        iq.addItem(item);
        PacketIDFilter responseFilter = new PacketIDFilter(iq.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(iq);
        MUCAdmin answer = (MUCAdmin)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
        ArrayList<Occupant> participants = new ArrayList<Occupant>();
        Iterator it = answer.getItems();
        while (it.hasNext()) {
            participants.add(new Occupant((MUCAdmin.Item)it.next()));
        }
        return participants;
    }

    public void sendMessage(String text) throws XMPPException {
        Message message = new Message(this.room, Message.Type.GROUP_CHAT);
        message.setBody(text);
        this.connection.sendPacket(message);
    }

    public Chat createPrivateChat(String occupant) {
        return new Chat(this.connection, occupant);
    }

    public Message createMessage() {
        return new Message(this.room, Message.Type.GROUP_CHAT);
    }

    public void sendMessage(Message message) throws XMPPException {
        this.connection.sendPacket(message);
    }

    public Message pollMessage() {
        return (Message)this.messageCollector.pollResult();
    }

    public Message nextMessage() {
        return (Message)this.messageCollector.nextResult();
    }

    public Message nextMessage(long timeout) {
        return (Message)this.messageCollector.nextResult(timeout);
    }

    public void addMessageListener(PacketListener listener) {
        this.connection.addPacketListener(listener, this.messageFilter);
        this.connectionListeners.add(listener);
    }

    public void removeMessageListener(PacketListener listener) {
        this.connection.removePacketListener(listener);
        this.connectionListeners.remove(listener);
    }

    public void changeSubject(final String subject) throws XMPPException {
        Message message = new Message(this.room, Message.Type.GROUP_CHAT);
        message.setSubject(subject);
        AndFilter responseFilter = new AndFilter(new FromMatchesFilter(this.room), new PacketTypeFilter(class$org$jivesoftware$smack$packet$Message == null ? (class$org$jivesoftware$smack$packet$Message = MultiUserChat.class$("org.jivesoftware.smack.packet.Message")) : class$org$jivesoftware$smack$packet$Message));
        responseFilter = new AndFilter(responseFilter, new PacketFilter(){

            public boolean accept(Packet packet) {
                Message msg = (Message)packet;
                return subject.equals(msg.getSubject());
            }
        });
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(message);
        Message answer = (Message)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    private synchronized void userHasJoined() {
        ArrayList<String> rooms = (ArrayList<String>)joinedRooms.get(this.connection);
        if (rooms == null) {
            rooms = new ArrayList<String>();
            joinedRooms.put(this.connection, rooms);
        }
        rooms.add(this.room);
    }

    private synchronized void userHasLeft() {
        ArrayList rooms = (ArrayList)joinedRooms.get(this.connection);
        if (rooms == null) {
            return;
        }
        rooms.remove(this.room);
    }

    private MUCUser getMUCUserExtension(Packet packet) {
        if (packet != null) {
            return (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserStatusListener(UserStatusListener listener) {
        List list = this.userStatusListeners;
        synchronized (list) {
            if (!this.userStatusListeners.contains(listener)) {
                this.userStatusListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserStatusListener(UserStatusListener listener) {
        List list = this.userStatusListeners;
        synchronized (list) {
            this.userStatusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUserStatusListeners(String methodName, Object[] params) {
        UserStatusListener[] listeners = null;
        List list = this.userStatusListeners;
        synchronized (list) {
            listeners = new UserStatusListener[this.userStatusListeners.size()];
            this.userStatusListeners.toArray(listeners);
        }
        Class[] paramClasses = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramClasses[i] = params[i].getClass();
        }
        try {
            Method method = (class$org$jivesoftware$smackx$muc$UserStatusListener == null ? (class$org$jivesoftware$smackx$muc$UserStatusListener = MultiUserChat.class$("org.jivesoftware.smackx.muc.UserStatusListener")) : class$org$jivesoftware$smackx$muc$UserStatusListener).getDeclaredMethod(methodName, paramClasses);
            for (int i = 0; i < listeners.length; ++i) {
                method.invoke((Object)listeners[i], params);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipantStatusListener(ParticipantStatusListener listener) {
        List list = this.participantStatusListeners;
        synchronized (list) {
            if (!this.participantStatusListeners.contains(listener)) {
                this.participantStatusListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParticipantStatusListener(ParticipantStatusListener listener) {
        List list = this.participantStatusListeners;
        synchronized (list) {
            this.participantStatusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireParticipantStatusListeners(String methodName, String param) {
        ParticipantStatusListener[] listeners = null;
        List list = this.participantStatusListeners;
        synchronized (list) {
            listeners = new ParticipantStatusListener[this.participantStatusListeners.size()];
            this.participantStatusListeners.toArray(listeners);
        }
        try {
            Method method = (class$org$jivesoftware$smackx$muc$ParticipantStatusListener == null ? (class$org$jivesoftware$smackx$muc$ParticipantStatusListener = MultiUserChat.class$("org.jivesoftware.smackx.muc.ParticipantStatusListener")) : class$org$jivesoftware$smackx$muc$ParticipantStatusListener).getDeclaredMethod(methodName, class$java$lang$String == null ? (class$java$lang$String = MultiUserChat.class$("java.lang.String")) : class$java$lang$String);
            for (int i = 0; i < listeners.length; ++i) {
                method.invoke((Object)listeners[i], param);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.messageFilter = new AndFilter(new FromMatchesFilter(this.room), new MessageTypeFilter(Message.Type.GROUP_CHAT));
        this.messageFilter = new AndFilter(this.messageFilter, new PacketFilter(){

            public boolean accept(Packet packet) {
                Message msg = (Message)packet;
                return msg.getBody() != null;
            }
        });
        this.messageCollector = this.connection.createPacketCollector(this.messageFilter);
        this.subjectFilter = new AndFilter(new FromMatchesFilter(this.room), new MessageTypeFilter(Message.Type.GROUP_CHAT));
        this.subjectFilter = new AndFilter(this.subjectFilter, new PacketFilter(){

            public boolean accept(Packet packet) {
                Message msg = (Message)packet;
                return msg.getSubject() != null;
            }
        });
        this.subjectListener = new PacketListener(){

            public void processPacket(Packet packet) {
                Message msg = (Message)packet;
                MultiUserChat.this.subject = msg.getSubject();
                MultiUserChat.this.fireSubjectUpdatedListeners(msg.getSubject(), msg.getFrom());
            }
        };
        this.connection.addPacketListener(this.subjectListener, this.subjectFilter);
        this.presenceFilter = new AndFilter(new FromMatchesFilter(this.room), new PacketTypeFilter(class$org$jivesoftware$smack$packet$Presence == null ? (class$org$jivesoftware$smack$packet$Presence = MultiUserChat.class$("org.jivesoftware.smack.packet.Presence")) : class$org$jivesoftware$smack$packet$Presence));
        this.presenceListener = new PacketListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processPacket(Packet packet) {
                Presence presence = (Presence)packet;
                String from = presence.getFrom();
                String myRoomJID = MultiUserChat.this.room + "/" + MultiUserChat.this.nickname;
                boolean isUserStatusModification = presence.getFrom().equals(myRoomJID);
                if (presence.getType() == Presence.Type.AVAILABLE) {
                    Presence oldPresence;
                    Map map = MultiUserChat.this.occupantsMap;
                    synchronized (map) {
                        oldPresence = (Presence)MultiUserChat.this.occupantsMap.get(from);
                        MultiUserChat.this.occupantsMap.put(from, presence);
                    }
                    if (oldPresence != null) {
                        MUCUser mucExtension = MultiUserChat.this.getMUCUserExtension(oldPresence);
                        String oldAffiliation = mucExtension.getItem().getAffiliation();
                        String oldRole = mucExtension.getItem().getRole();
                        mucExtension = MultiUserChat.this.getMUCUserExtension(presence);
                        String newAffiliation = mucExtension.getItem().getAffiliation();
                        String newRole = mucExtension.getItem().getRole();
                        MultiUserChat.this.checkRoleModifications(oldRole, newRole, isUserStatusModification, from);
                        MultiUserChat.this.checkAffiliationModifications(oldAffiliation, newAffiliation, isUserStatusModification, from);
                    } else if (!isUserStatusModification) {
                        MultiUserChat.this.fireParticipantStatusListeners("joined", from);
                    }
                } else if (presence.getType() == Presence.Type.UNAVAILABLE) {
                    Map oldPresence = MultiUserChat.this.occupantsMap;
                    synchronized (oldPresence) {
                        MultiUserChat.this.occupantsMap.remove(from);
                    }
                    MUCUser mucUser = MultiUserChat.this.getMUCUserExtension(presence);
                    if (mucUser != null && mucUser.getStatus() != null) {
                        MultiUserChat.this.checkPresenceCode(mucUser.getStatus().getCode(), presence.getFrom().equals(myRoomJID), mucUser, from);
                    } else if (!isUserStatusModification) {
                        MultiUserChat.this.fireParticipantStatusListeners("left", from);
                    }
                }
            }
        };
        this.connection.addPacketListener(this.presenceListener, this.presenceFilter);
        this.declinesFilter = new PacketExtensionFilter("x", "http://jabber.org/protocol/muc#user");
        this.declinesListener = new PacketListener(){

            public void processPacket(Packet packet) {
                MUCUser mucUser = MultiUserChat.this.getMUCUserExtension(packet);
                if (mucUser.getDecline() != null) {
                    MultiUserChat.this.fireInvitationRejectionListeners(mucUser.getDecline().getFrom(), mucUser.getDecline().getReason());
                }
            }
        };
        this.connection.addPacketListener(this.declinesListener, this.declinesFilter);
    }

    private void checkRoleModifications(String oldRole, String newRole, boolean isUserModification, String from) {
        if (("visitor".equals(oldRole) || "none".equals(oldRole)) && "participant".equals(newRole)) {
            if (isUserModification) {
                this.fireUserStatusListeners("voiceGranted", new Object[0]);
            } else {
                this.fireParticipantStatusListeners("voiceGranted", from);
            }
        } else if ("participant".equals(oldRole) && ("visitor".equals(newRole) || "none".equals(newRole))) {
            if (isUserModification) {
                this.fireUserStatusListeners("voiceRevoked", new Object[0]);
            } else {
                this.fireParticipantStatusListeners("voiceRevoked", from);
            }
        }
        if (!"moderator".equals(oldRole) && "moderator".equals(newRole)) {
            if ("visitor".equals(oldRole) || "none".equals(oldRole)) {
                if (isUserModification) {
                    this.fireUserStatusListeners("voiceGranted", new Object[0]);
                } else {
                    this.fireParticipantStatusListeners("voiceGranted", from);
                }
            }
            if (isUserModification) {
                this.fireUserStatusListeners("moderatorGranted", new Object[0]);
            } else {
                this.fireParticipantStatusListeners("moderatorGranted", from);
            }
        } else if ("moderator".equals(oldRole) && !"moderator".equals(newRole)) {
            if ("visitor".equals(newRole) || "none".equals(newRole)) {
                if (isUserModification) {
                    this.fireUserStatusListeners("voiceRevoked", new Object[0]);
                } else {
                    this.fireParticipantStatusListeners("voiceRevoked", from);
                }
            }
            if (isUserModification) {
                this.fireUserStatusListeners("moderatorRevoked", new Object[0]);
            } else {
                this.fireParticipantStatusListeners("moderatorRevoked", from);
            }
        }
    }

    private void checkAffiliationModifications(String oldAffiliation, String newAffiliation, boolean isUserModification, String from) {
        if ("owner".equals(oldAffiliation) && !"owner".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("ownershipRevoked", new Object[0]);
            } else {
                this.fireParticipantStatusListeners("ownershipRevoked", from);
            }
        } else if ("admin".equals(oldAffiliation) && !"admin".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("adminRevoked", new Object[0]);
            } else {
                this.fireParticipantStatusListeners("adminRevoked", from);
            }
        } else if ("member".equals(oldAffiliation) && !"member".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("membershipRevoked", new Object[0]);
            } else {
                this.fireParticipantStatusListeners("membershipRevoked", from);
            }
        }
        if (!"owner".equals(oldAffiliation) && "owner".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("ownershipGranted", new Object[0]);
            } else {
                this.fireParticipantStatusListeners("ownershipGranted", from);
            }
        } else if (!"admin".equals(oldAffiliation) && "admin".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("adminGranted", new Object[0]);
            } else {
                this.fireParticipantStatusListeners("adminGranted", from);
            }
        } else if (!"member".equals(oldAffiliation) && "member".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("membershipGranted", new Object[0]);
            } else {
                this.fireParticipantStatusListeners("membershipGranted", from);
            }
        }
    }

    private void checkPresenceCode(String code, boolean isUserModification, MUCUser mucUser, String from) {
        if ("307".equals(code)) {
            if (isUserModification) {
                this.joined = false;
                this.fireUserStatusListeners("kicked", new Object[]{mucUser.getItem().getActor(), mucUser.getItem().getReason()});
                this.occupantsMap = new HashMap();
                this.nickname = null;
                this.userHasLeft();
            } else {
                this.fireParticipantStatusListeners("kicked", from);
            }
        } else if ("301".equals(code)) {
            if (isUserModification) {
                this.joined = false;
                this.fireUserStatusListeners("banned", new Object[]{mucUser.getItem().getActor(), mucUser.getItem().getReason()});
                this.occupantsMap = new HashMap();
                this.nickname = null;
                this.userHasLeft();
            } else {
                this.fireParticipantStatusListeners("banned", from);
            }
        } else if ("321".equals(code)) {
            if (isUserModification) {
                this.joined = false;
                this.fireUserStatusListeners("membershipRevoked", new Object[0]);
                this.occupantsMap = new HashMap();
                this.nickname = null;
                this.userHasLeft();
            }
        } else if ("303".equals(code)) {
            this.fireParticipantStatusListeners("nicknameChanged", mucUser.getItem().getNick());
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        try {
            if (this.connection != null) {
                this.messageCollector.cancel();
                this.connection.removePacketListener(this.subjectListener);
                this.connection.removePacketListener(this.presenceListener);
                this.connection.removePacketListener(this.declinesListener);
                Iterator it = this.connectionListeners.iterator();
                while (it.hasNext()) {
                    this.connection.removePacketListener((PacketListener)it.next());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Iterator access$000(XMPPConnection x0) {
        return MultiUserChat.getJoinedRooms(x0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        XMPPConnection.addConnectionListener(new ConnectionEstablishedListener(){

            public void connectionEstablished(XMPPConnection connection) {
                ServiceDiscoveryManager.getInstanceFor(connection).addFeature(MultiUserChat.discoNamespace);
                ServiceDiscoveryManager.getInstanceFor(connection).setNodeInformationProvider(MultiUserChat.discoNode, new NodeInformationProvider(this, connection){
                    private final /* synthetic */ XMPPConnection val$connection;
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$connection = val$connection;
                    }

                    public Iterator getNodeItems() {
                        ArrayList<DiscoverItems.Item> answer = new ArrayList<DiscoverItems.Item>();
                        Iterator rooms = MultiUserChat.access$000(this.val$connection);
                        while (rooms.hasNext()) {
                            answer.add(new DiscoverItems.Item((String)rooms.next()));
                        }
                        return answer.iterator();
                    }
                });
            }
        });
    }

    private static class InvitationsMonitor
    implements ConnectionListener {
        private static Map monitors = new WeakHashMap();
        private List invitationsListeners = new ArrayList();
        private XMPPConnection connection;
        private PacketFilter invitationFilter;
        private PacketListener invitationPacketListener;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static InvitationsMonitor getInvitationsMonitor(XMPPConnection conn) {
            Map map = monitors;
            synchronized (map) {
                if (!monitors.containsKey(conn)) {
                    monitors.put(conn, new WeakReference<InvitationsMonitor>(new InvitationsMonitor(conn)));
                }
                return (InvitationsMonitor)((WeakReference)monitors.get(conn)).get();
            }
        }

        private InvitationsMonitor(XMPPConnection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addInvitationListener(InvitationListener listener) {
            List list = this.invitationsListeners;
            synchronized (list) {
                if (this.invitationsListeners.size() == 0) {
                    this.init();
                }
                if (!this.invitationsListeners.contains(listener)) {
                    this.invitationsListeners.add(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeInvitationListener(InvitationListener listener) {
            List list = this.invitationsListeners;
            synchronized (list) {
                if (this.invitationsListeners.contains(listener)) {
                    this.invitationsListeners.remove(listener);
                }
                if (this.invitationsListeners.size() == 0) {
                    this.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireInvitationListeners(String room, String inviter, String reason, String password, Message message) {
            InvitationListener[] listeners = null;
            List list = this.invitationsListeners;
            synchronized (list) {
                listeners = new InvitationListener[this.invitationsListeners.size()];
                this.invitationsListeners.toArray(listeners);
            }
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].invitationReceived(this.connection, room, inviter, reason, password, message);
            }
        }

        public void connectionClosed() {
            this.cancel();
        }

        public void connectionClosedOnError(Exception e) {
            this.cancel();
        }

        private void init() {
            this.invitationFilter = new PacketExtensionFilter("x", "http://jabber.org/protocol/muc#user");
            this.invitationPacketListener = new PacketListener(this){
                private final /* synthetic */ InvitationsMonitor this$0;
                {
                    this.this$0 = this$0;
                }

                public void processPacket(Packet packet) {
                    MUCUser mucUser = (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
                    if (mucUser.getInvite() != null) {
                        InvitationsMonitor.access$1200(this.this$0, packet.getFrom(), mucUser.getInvite().getFrom(), mucUser.getInvite().getReason(), mucUser.getPassword(), (Message)packet);
                    }
                }
            };
            this.connection.addPacketListener(this.invitationPacketListener, this.invitationFilter);
            this.connection.addConnectionListener(this);
        }

        private void cancel() {
            this.connection.removePacketListener(this.invitationPacketListener);
            this.connection.removeConnectionListener(this);
        }

        static /* synthetic */ void access$1200(InvitationsMonitor x0, String x1, String x2, String x3, String x4, Message x5) {
            x0.fireInvitationListeners(x1, x2, x3, x4, x5);
        }
    }
}

