/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.partial;

import net.sf.tacos.partial.PartialService;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;

public abstract class Part
extends AbstractComponent {
    private static final String CURRENTID_ATTRIBUTE = "net.sf.tacos.Part:currentId";
    private static final String RENDERING_ATTRIBUTE = "net.sf.tacos.Part:rendering";

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        this.getContainer();
        String id = this.getPartId();
        if (id == null) {
            id = "part-" + cycle.getNextActionId();
        }
        String lastId = (String)cycle.getAttribute(CURRENTID_ATTRIBUTE);
        Boolean lastRendering = (Boolean)cycle.getAttribute(RENDERING_ATTRIBUTE);
        boolean partialRender = false;
        if (PartialService.isPartialRender()) {
            IMarkupWriter partWriter = PartialService.getPartWriter(id);
            if (partWriter == null && this.isOptimize() && lastRendering == null) {
                return;
            }
            if (partWriter != null) {
                partialRender = true;
                writer = partWriter;
            }
        }
        cycle.setAttribute(CURRENTID_ATTRIBUTE, (Object)id);
        if (partialRender) {
            cycle.setAttribute(RENDERING_ATTRIBUTE, (Object)Boolean.TRUE);
        }
        if (!cycle.isRewinding() && !partialRender) {
            writer.begin(this.getElement());
            writer.attribute("id", id);
            this.renderInformalParameters(writer, cycle);
        }
        this.renderBody(writer, cycle);
        if (!cycle.isRewinding() && !partialRender) {
            writer.end();
        }
        cycle.setAttribute(CURRENTID_ATTRIBUTE, (Object)lastId);
        cycle.setAttribute(RENDERING_ATTRIBUTE, (Object)lastRendering);
    }

    public abstract String getElement();

    public abstract String getPartId();

    public abstract boolean isOptimize();

    public static String getCurrentId(IRequestCycle cycle) {
        return (String)cycle.getAttribute(CURRENTID_ATTRIBUTE);
    }
}

